/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.webportal.gui;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.webportal.proto.Webportal;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public abstract class UserEditDialog
extends CommonDialog {
    private static final long serialVersionUID = -7883854897755727679L;
    private Webportal.User user;
    private JTextField name;
    private JTextField login;
    private JPasswordField password;
    private JCheckBox active;
    private JTextField city;
    private JTextField email;
    private JTextField fax;
    private JTextField phone;
    private JTextField postcode;
    private JComboBox salutation;
    private JTextField street;
    private JTextField customerNumber;
    private JCheckBox passwordActive;
    private JTextField logoUrl;

    public UserEditDialog(Component parent, String title, Webportal.User user) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.user = user;
        this.buildLayout();
        this.fillValue();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    private void fillValue() {
        if (this.user != null) {
            this.name.setText(this.user.getName());
            this.login.setText(this.user.getLogin());
            this.active.setSelected(this.user.getActive());
            this.city.setText(this.user.getCity());
            this.email.setText(this.user.getEmail());
            this.fax.setText(this.user.getFax());
            this.phone.setText(this.user.getPhone());
            this.postcode.setText(this.user.getPostcode());
            if (this.user.hasSalutation()) {
                String salutation = this.user.getSalutation();
                if (salutation.equals("MISTER")) {
                    this.salutation.setSelectedIndex(1);
                } else if (salutation.equals("MISSES")) {
                    this.salutation.setSelectedIndex(2);
                }
            }
            this.street.setText(this.user.getStreet());
            this.customerNumber.setText(this.user.getCustomerNumber());
            this.logoUrl.setText(this.user.hasLogoUrl() ? this.user.getLogoUrl() : "");
        }
    }

    private void adaptValuesToUser() {
        Webportal.User.Builder userBuilder = Webportal.User.newBuilder().setActive(this.active.isSelected()).setCity(this.city.getText()).setEmail(this.email.getText()).setFax(this.fax.getText()).setLogin(this.login.getText()).setName(this.name.getText()).setPhone(this.phone.getText()).setPostcode(this.postcode.getText()).setStreet(this.street.getText()).setCustomerNumber(this.customerNumber.getText()).setLogoUrl(this.logoUrl.getText());
        int selectedSalutation = this.salutation.getSelectedIndex();
        switch (selectedSalutation) {
            case 1: {
                userBuilder.setSalutation("MISTER");
                break;
            }
            case 2: {
                userBuilder.setSalutation("MISSES");
            }
        }
        if (this.passwordActive.isSelected()) {
            userBuilder.setPassword(new String(this.password.getPassword()));
        }
        this.user = userBuilder.build();
    }

    public UserEditDialog(Component parent, String title) {
        this(parent, title, (Webportal.User)null);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -5094083609866261139L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserEditDialog.this.adaptValuesToUser();
                UserEditDialog.this.dispose();
                UserEditDialog.this.doAfterOk();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -2300655639551177709L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserEditDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        this.login = new JTextField();
        this.addLine(panel, "messages.user.login", this.login);
        JPanel passwordPanel = new JPanel(new BorderLayout());
        this.passwordActive = new JCheckBox();
        passwordPanel.add((Component)this.passwordActive, "West");
        this.password = new JPasswordField();
        passwordPanel.add((Component)this.password, "Center");
        this.addLine(panel, "messages.user.password", passwordPanel);
        this.salutation = new JComboBox<String>(new String[]{"", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.mister", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.misses", new Serializable[0])});
        this.addLine(panel, "messages.user.salutation", this.salutation);
        this.name = new JTextField();
        this.addLine(panel, "messages.user.name", this.name);
        this.street = new JTextField();
        this.addLine(panel, "messages.user.street", this.street);
        this.postcode = new JTextField();
        this.addLine(panel, "messages.user.postcode", this.postcode);
        this.city = new JTextField();
        this.addLine(panel, "messages.user.city", this.city);
        this.email = new JTextField();
        this.addLine(panel, "messages.user.email", this.email);
        this.phone = new JTextField();
        this.addLine(panel, "messages.user.phone", this.phone);
        this.fax = new JTextField();
        this.addLine(panel, "messages.user.fax", this.fax);
        this.customerNumber = new JTextField();
        this.addLine(panel, "messages.user.customerNumber", this.customerNumber);
        this.logoUrl = new JTextField();
        this.addLine(panel, "messages.user.logoUrl", this.logoUrl);
        this.active = new JCheckBox();
        this.addLine(panel, "messages.user.active", this.active);
        SpringUtilities.makeCompactGrid(panel, 13, 2, 5, 5, 5, 5);
        return panel;
    }

    private void addLine(JPanel panel, String messageKey, Component comp) {
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(messageKey, new Serializable[0])));
        panel.add(comp);
    }

    public Webportal.User getUser() {
        return this.user;
    }

    protected abstract void doAfterOk();
}

