/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.util.comparator.ComparatorBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SpecialHolidayTableModel
implements TableModel {
    private List<SpecialWageHolidayModel> specialHolidays;
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

    @Override
    public int getRowCount() {
        return this.specialHolidays == null ? 0 : this.specialHolidays.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]);
            }
            case 1: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.month", new Serializable[0]);
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.day", new Serializable[0]);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.specialHolidays != null) {
            SpecialWageHolidayModel specialWageHolidayModel = this.specialHolidays.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return specialWageHolidayModel.getName();
                }
                case 1: {
                    return specialWageHolidayModel.getMonth();
                }
                case 2: {
                    return specialWageHolidayModel.getDay();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.specialHolidays != null) {
            SpecialWageHolidayModel specialWageHolidayModel = this.specialHolidays.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    specialWageHolidayModel.setName((String)aValue);
                    break;
                }
                case 1: {
                    specialWageHolidayModel.setMonth((Integer)aValue);
                    break;
                }
                case 2: {
                    specialWageHolidayModel.setDay((Integer)aValue);
                }
            }
        }
        this.fireTableModelChanged(new TableModelEvent(this, rowIndex));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableModelChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public void setWageHolidaySet(WageHolidaySetModel wageHolidaySet) {
        if (wageHolidaySet == null) {
            this.specialHolidays = null;
        } else {
            this.specialHolidays = new ArrayList<SpecialWageHolidayModel>(wageHolidaySet.countSpecialWageHolidays());
            for (SpecialWageHolidayModel s : wageHolidaySet.iterableSpecialWageHolidays()) {
                this.specialHolidays.add(s);
            }
            Collections.sort(this.specialHolidays, new SpecialHolidayComparator());
        }
        this.fireTableModelChanged(new TableModelEvent(this));
    }

    public SpecialWageHolidayModel getSpecialWageHolidayAt(int i) {
        return this.specialHolidays.get(i);
    }

    private static class SpecialHolidayComparator
    implements Comparator<SpecialWageHolidayModel> {
        private SpecialHolidayComparator() {
        }

        @Override
        public int compare(SpecialWageHolidayModel o1, SpecialWageHolidayModel o2) {
            return new ComparatorBuilder().append(o1.getMonth(), o2.getMonth()).append(o1.getDay(), o2.getDay()).append(o1.getName(), o2.getName()).compare();
        }
    }
}

