/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModelImpl;
import de.datomino.peppergis.wage.gui.holiday.HolidayAreaPane;
import de.datomino.peppergis.wage.gui.holiday.HolidaySetPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HolidaySetOverviewPane
extends JPanel {
    private static final long serialVersionUID = -4718270826139839022L;
    private ModelEnviroment modelEnviroment;
    private JList holidaySetList;
    private HolidaySetPane holidaySetPane;
    private HolidayAreaPane holidayAreaPane;
    private Action removeAction;

    public HolidaySetOverviewPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        Collection<WageHolidaySetModel> wageHolidaySets = this.modelEnviroment.getAllCaller().getWageCaller().fetchAllWageHolidaySets();
        DefaultListModel dlm = (DefaultListModel)this.holidaySetList.getModel();
        for (WageHolidaySetModel wageHolidaySet : wageHolidaySets) {
            dlm.addElement(wageHolidaySet);
        }
    }

    private void buildLayout() {
        JSplitPane split = new JSplitPane(1);
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.holidaySetList = new JList(new DefaultListModel());
        this.holidaySetList.setSelectionMode(0);
        final ListCellRenderer renderer = this.holidaySetList.getCellRenderer();
        this.holidaySetList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object nValue = value;
                if (value instanceof WageHolidaySetModel) {
                    WageHolidaySetModel wageHolidaySetModel = (WageHolidaySetModel)value;
                    nValue = wageHolidaySetModel.getName();
                }
                return renderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
            }
        });
        this.holidaySetList.addListSelectionListener(new HolidaySetListSelectionListener());
        leftPanel.add((Component)new JScrollPane(this.holidaySetList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        buttonPanel.add((Component)new JButton(this.removeAction), "East");
        buttonPanel.add(new JButton(new AddAction()));
        leftPanel.add((Component)buttonPanel, "South");
        split.setLeftComponent(leftPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.holidaySetPane = new HolidaySetPane();
        this.holidayAreaPane = new HolidayAreaPane(this.modelEnviroment);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.common", new Serializable[0]), this.holidaySetPane);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.relation", new Serializable[0]), this.holidayAreaPane);
        split.setRightComponent(tabbedPane);
        this.add((Component)split, "Center");
    }

    private WageHolidaySetModel createWageHolidaySetModel() {
        WageHolidaySetModelImpl selectedValue = new WageHolidaySetModelImpl();
        selectedValue.setAllSaintsDay(false);
        selectedValue.setAscensionDay(true);
        selectedValue.setAssumptionDay(false);
        selectedValue.setCorpusChristi(false);
        selectedValue.setEasterMonday(true);
        selectedValue.setFirstChristmasDay(true);
        selectedValue.setFriday(false);
        selectedValue.setGermanUnityDay(true);
        selectedValue.setGoodFriday(true);
        selectedValue.setLaborDay(true);
        selectedValue.setMonday(false);
        selectedValue.setName("Neues Set");
        selectedValue.setNewYear(true);
        selectedValue.setPeacePartyDay(false);
        selectedValue.setPenanceDay(false);
        selectedValue.setReformationDay(false);
        selectedValue.setSaturday(true);
        selectedValue.setSecondChristmasDay(true);
        selectedValue.setSunday(true);
        selectedValue.setThreeHolyKings(false);
        selectedValue.setThursday(false);
        selectedValue.setTuesday(false);
        selectedValue.setWednesday(false);
        selectedValue.setWhitMonday(true);
        return selectedValue;
    }

    public void adaptValuesToModel() {
        this.holidaySetPane.adaptValuesToModel();
    }

    public void refreshAreas() {
        this.modelEnviroment.getModelCache().refresh(AreaObjectModel.class);
        this.holidayAreaPane.refreshAreas();
    }

    private class HolidaySetListSelectionListener
    implements ListSelectionListener {
        private HolidaySetListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            HolidaySetOverviewPane.this.holidaySetPane.adaptValuesToModel();
            WageHolidaySetModel selectedValue = (WageHolidaySetModel)HolidaySetOverviewPane.this.holidaySetList.getSelectedValue();
            HolidaySetOverviewPane.this.holidaySetPane.setWageHolidaySetModel(selectedValue);
            HolidaySetOverviewPane.this.holidayAreaPane.setWageHolidaySetModel(selectedValue);
            HolidaySetOverviewPane.this.removeAction.setEnabled(selectedValue != null);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int s = HolidaySetOverviewPane.this.holidaySetList.getSelectedIndex();
            DefaultListModel dlm = (DefaultListModel)HolidaySetOverviewPane.this.holidaySetList.getModel();
            WageHolidaySetModel selectedValue = (WageHolidaySetModel)dlm.remove(s);
            for (SpecialWageHolidayModel specialWageHolidayModel : selectedValue.iterableSpecialWageHolidays()) {
                specialWageHolidayModel.delete();
            }
            selectedValue.delete();
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WageHolidaySetModel selectedValue = HolidaySetOverviewPane.this.createWageHolidaySetModel();
            DefaultListModel dlm = (DefaultListModel)HolidaySetOverviewPane.this.holidaySetList.getModel();
            dlm.addElement(selectedValue);
        }
    }
}

