/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.Importer;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.action.AbstractImportAction;
import de.datomino.peppergis.wage.gui.holiday.HolidaySetOverviewPane;
import de.datomino.peppergis.wage.gui.holiday.importer.HolidaySetImporter;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class HolidaySetDialog
extends CommonDialog {
    private static final long serialVersionUID = 8118094977623886721L;
    private HolidaySetOverviewPane holidaySetOverviewPane;
    private ModelEnviroment modelEnviroment;

    public HolidaySetDialog(Component parent, ModelEnviroment modelEnviroment) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.holiday.set", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.pack();
        SwingUtils.center((Window)this, parent);
        this.modelEnviroment.getUndoManager().startTransaction();
        this.setVisible(true);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -8423963547420688702L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HolidaySetDialog.this.close()) {
                    HolidaySetDialog.this.dispose();
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -8423963547420688702L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HolidaySetDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                HolidaySetDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.holidaySetOverviewPane = new HolidaySetOverviewPane(this.modelEnviroment);
        return this.holidaySetOverviewPane;
    }

    @Override
    protected boolean close() {
        this.holidaySetOverviewPane.adaptValuesToModel();
        if (this.modelEnviroment.getUndoManager().canUndo() || this.modelEnviroment.getUndoManager().hasCurrentTransactionChanges()) {
            int d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.save", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
            switch (d) {
                case 0: {
                    this.modelEnviroment.getUndoManager().finishTransaction("");
                    try {
                        this.modelEnviroment.getUndoManager().storeTransactions();
                    }
                    catch (ValidateException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
                case 1: {
                    this.modelEnviroment.getUndoManager().rollbackTransaction();
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        } else {
            this.modelEnviroment.getUndoManager().finishTransaction("");
            return true;
        }
        return true;
    }

    @Override
    protected Action[] getAdditionalWestActions() {
        Action[] setAdditionalWestActions = super.getAdditionalWestActions();
        Action[] additionalWestActions = new Action[setAdditionalWestActions.length + 1];
        System.arraycopy(setAdditionalWestActions, 0, additionalWestActions, 0, setAdditionalWestActions.length);
        additionalWestActions[setAdditionalWestActions.length] = new ImportHolidaySetAction(this);
        return additionalWestActions;
    }

    private void refreshAreas() {
        this.holidaySetOverviewPane.refreshAreas();
    }

    private class ImportHolidaySetAction
    extends AbstractImportAction {
        private static final long serialVersionUID = -561626464912204194L;

        public ImportHolidaySetAction(Window parent) {
            super(parent, true);
        }

        @Override
        protected String getImporterTitle() {
            return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.import", new Serializable[0]);
        }

        @Override
        protected Importer createImporter() {
            return new HolidaySetImporter(HolidaySetDialog.this.modelEnviroment);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            HolidaySetDialog.this.refreshAreas();
        }
    }
}

