/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday;

import de.datomino.peppergis.client.gui.common.table.CheckBoxHeaderRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.wage.gui.holiday.area.HolidaySetAreaObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.builder.EqualsBuilder;

public class HolidayAreaPane
extends JPanel {
    private static final long serialVersionUID = -2605631037467382259L;
    private WageHolidaySetModel wageHolidaySetModel;
    private JList layerList;
    private JTable areaTable;
    private Action setAction;
    private Action unsetAction;

    public HolidayAreaPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.buildLayout(modelEnviroment);
        this.fillValues(modelEnviroment);
    }

    private void fillValues(ModelEnviroment modelEnviroment) {
        Collection<AreaLayerModel> areaLayers = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        DefaultListModel dlm = (DefaultListModel)this.layerList.getModel();
        for (AreaLayerModel layer : areaLayers) {
            dlm.addElement(layer);
        }
    }

    private void buildLayout(ModelEnviroment modelEnviroment) {
        JSplitPane split = new JSplitPane();
        JPanel panel = new JPanel(new BorderLayout());
        this.layerList = new JList(new DefaultListModel());
        this.layerList.setSelectionMode(0);
        final ListCellRenderer cellRenderer = this.layerList.getCellRenderer();
        this.layerList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof AreaLayerModel) {
                    AreaLayerModel layer = (AreaLayerModel)value;
                    Component comp = cellRenderer.getListCellRendererComponent(list, layer.getDisplayname(), index, isSelected, cellHasFocus);
                    if (new EqualsBuilder().append(layer.getWageHolidaySet(), HolidayAreaPane.this.wageHolidaySetModel).isEquals()) {
                        comp.setForeground(Color.GREEN);
                    }
                    return comp;
                }
                return cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.layerList.addListSelectionListener(new AreaLayerListSelectionListener());
        panel.add((Component)new JScrollPane(this.layerList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.unsetAction = new SetHolidayAction(true);
        buttonPanel.add((Component)new JButton(this.unsetAction), "West");
        this.setAction = new SetHolidayAction(false);
        buttonPanel.add((Component)new JButton(this.setAction), "East");
        this.unsetAction.setEnabled(false);
        this.setAction.setEnabled(false);
        panel.add((Component)buttonPanel, "South");
        split.setLeftComponent(panel);
        this.areaTable = new JTable(new HolidaySetAreaObjectTableModel());
        this.areaTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tc = this.areaTable.getColumnModel().getColumn(0);
        tc.setHeaderRenderer(new CheckBoxHeaderRenderer(""));
        split.setRightComponent(new JScrollPane(this.areaTable));
        this.add((Component)split, "Center");
    }

    public void setWageHolidaySetModel(WageHolidaySetModel wageHolidaySetModel) {
        this.wageHolidaySetModel = wageHolidaySetModel;
        this.layerList.repaint(10L);
        HolidaySetAreaObjectTableModel model = (HolidaySetAreaObjectTableModel)this.areaTable.getModel();
        model.setWageHolidaySetModel(wageHolidaySetModel);
        this.setEnabled(wageHolidaySetModel != null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.layerList.setEnabled(enabled);
        this.areaTable.setEnabled(enabled);
        if (!enabled) {
            this.setAction.setEnabled(false);
            this.unsetAction.setEnabled(false);
        } else {
            AreaLayerModel layer = (AreaLayerModel)this.layerList.getSelectedValue();
            boolean equals = layer != null && new EqualsBuilder().append(layer.getWageHolidaySet(), this.wageHolidaySetModel).isEquals();
            this.setAction.setEnabled(!equals);
            this.unsetAction.setEnabled(equals);
        }
    }

    public void refreshAreas() {
        this.setWageHolidaySetModel(this.wageHolidaySetModel);
    }

    private class SetHolidayAction
    extends AbstractAction {
        private static final long serialVersionUID = 4028753131116909826L;
        private boolean unset;

        public SetHolidayAction(boolean unset) {
            super(ModelEnviroment.getMessageResolver().resolveMessage(unset ? "messages.default.unset" : "messages.default.set", new Serializable[0]));
            this.unset = unset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerModel layer = (AreaLayerModel)HolidayAreaPane.this.layerList.getSelectedValue();
            layer.setWageHolidaySet(this.unset ? null : HolidayAreaPane.this.wageHolidaySetModel);
        }
    }

    private class AreaLayerListSelectionListener
    implements ListSelectionListener {
        private AreaLayerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AreaLayerModel layer = (AreaLayerModel)HolidayAreaPane.this.layerList.getSelectedValue();
            HolidaySetAreaObjectTableModel model = (HolidaySetAreaObjectTableModel)HolidayAreaPane.this.areaTable.getModel();
            model.setAreaLayerModel(layer);
            boolean equals = new EqualsBuilder().append(layer.getWageHolidaySet(), HolidayAreaPane.this.wageHolidaySetModel).isEquals();
            HolidayAreaPane.this.setAction.setEnabled(!equals);
            HolidayAreaPane.this.unsetAction.setEnabled(equals);
        }
    }
}

