/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history.search;

import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.common.FilteredListSelectorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.wage.HistoryAreaTourSearchDto;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public abstract class AbstractWageSearchPane
extends JPanel {
    private static final long serialVersionUID = -5112580042697273634L;
    private ModelEnviroment modelEnviroment;
    private JComboBox layer;
    private FilteredListSelectorPane<String> area;
    private JSpinner startDate;
    private JSpinner endDate;
    private FilteredListSelectorPane<AreaDelivererModel> deliverers;
    private Map<String, List<String>> layerMap;

    public AbstractWageSearchPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.layerMap = new HashMap<String, List<String>>();
        this.layerMap.put(null, Collections.emptyList());
        WageCaller wageCaller = modelEnviroment.getAllCaller().getWageCaller();
        Collection<String> layerNames = wageCaller.fetchAreaLayersFromHistoryAreaTour();
        for (String layerName : layerNames) {
            this.layerMap.put(layerName, null);
        }
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel sPanel = new JPanel(new SpringLayout());
        sPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        this.layer = new JComboBox<String>(new Vector<String>(this.layerMap.keySet()));
        this.layer.setRenderer(new AbstractListCellRenderer<String>(){

            @Override
            protected String getStringFromValue(String object) {
                return object == null ? "" : object;
            }
        });
        this.layer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AbstractWageSearchPane.this.fillAreaName((String)e.getItem());
                }
            }
        });
        sPanel.add(this.layer);
        sPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0])));
        this.area = new FilteredListSelectorPane<String>(new ArrayList(), true, 10){
            private static final long serialVersionUID = -5837262086589639843L;

            @Override
            protected String getString(String t) {
                return t == null ? "" : t;
            }
        };
        sPanel.add(this.area);
        sPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.startDate", new Serializable[0])));
        this.startDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        JSpinner.DateEditor startDateEditor = new JSpinner.DateEditor(this.startDate, FormUtil.DATEFORMAT);
        this.startDate.setEditor(startDateEditor);
        sPanel.add(this.startDate);
        sPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.endDate", new Serializable[0])));
        this.endDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        JSpinner.DateEditor endDateEditor = new JSpinner.DateEditor(this.endDate, FormUtil.DATEFORMAT);
        this.endDate.setEditor(endDateEditor);
        sPanel.add(this.endDate);
        sPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.personNumber", new Serializable[0])));
        List<AreaDelivererModel> attachedDeliverers = this.modelEnviroment.getAllCaller().getTourCaller().getDeliverersAttachedToHistoyAreaTour();
        this.deliverers = new FilteredListSelectorPane<AreaDelivererModel>(attachedDeliverers, true, 10){
            private static final long serialVersionUID = -867172516085938850L;

            @Override
            protected String getString(AreaDelivererModel t) {
                return StringUtil.getNotNull(t.getDelivererNumber());
            }
        };
        sPanel.add(this.deliverers);
        sPanel.add(new JLabel(""));
        JPanel bPanel = new JPanel(new BorderLayout());
        JButton button = new JButton(new SearchAction());
        button.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        bPanel.add((Component)button, "East");
        sPanel.add(bPanel);
        SpringUtilities.makeCompactGrid(sPanel, 6, 2, 5, 5, 5, 5);
        this.add((Component)sPanel, "North");
    }

    private void fillAreaName(String layerName) {
        List<String> areaNames = this.layerMap.get(layerName);
        if (areaNames == null) {
            WageCaller wageCaller = this.modelEnviroment.getAllCaller().getWageCaller();
            areaNames = new ArrayList<String>(wageCaller.fetchAreaShortcutsFromHistoryAreaTour(layerName));
            Collections.sort(areaNames);
        }
        this.area.setValues(areaNames);
    }

    protected abstract void doSearchResult(List<HistoryAreaTourModel> var1);

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 5074138350822686562L;

        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedDelivererModels = AbstractWageSearchPane.this.deliverers.getSelectedValues(true);
            ArrayList<AreaDelivererDto> selectedDelivererDtos = new ArrayList<AreaDelivererDto>(selectedDelivererModels.size());
            for (AreaDelivererModel model : selectedDelivererModels) {
                if (model == null) continue;
                selectedDelivererDtos.add((AreaDelivererDto)((Object)model.createProxy()));
            }
            Date start = TimeUtil.normalize((Date)AbstractWageSearchPane.this.startDate.getValue());
            Date end = TimeUtil.setTime((Date)AbstractWageSearchPane.this.endDate.getValue(), 23, 59, 59);
            String selectedlayerName = (String)AbstractWageSearchPane.this.layer.getSelectedItem();
            List<String> selectedAreaNames = AbstractWageSearchPane.this.area.getSelectedValues(true);
            HistoryAreaTourSearchDto historyAreaTourSearchDto = new HistoryAreaTourSearchDto(selectedlayerName, selectedAreaNames, start, end, selectedDelivererDtos);
            List<HistoryAreaTourModel> hTours = AbstractWageSearchPane.this.modelEnviroment.getAllCaller().getWageCaller().searchHistoryAreaTours(historyAreaTourSearchDto);
            if (hTours.isEmpty()) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(AbstractWageSearchPane.this), ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.foundNoTour", new Serializable[0]));
            }
            AbstractWageSearchPane.this.doSearchResult(hTours);
        }
    }
}

