/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history.create;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.dto.wage.WageExportDto;
import de.datomino.peppergis.exception.TourCalculationBlockException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.wage.HistoryAreaTourSearchDto;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractHistoryAreaToursDialog
extends JDialog {
    private static final long serialVersionUID = -1253474537654088087L;
    private ModelEnviroment modelEnviroment;
    private List<HistoryAreaTourModel> result = new ArrayList<HistoryAreaTourModel>();
    private boolean showGroupButton;

    public AbstractHistoryAreaToursDialog(ModelEnviroment modelEnviroment, Window owner, String title) {
        this(modelEnviroment, owner, title, false);
    }

    public AbstractHistoryAreaToursDialog(ModelEnviroment modelEnviroment, Window owner, String title, boolean showGroupButton) {
        super(owner);
        this.modelEnviroment = modelEnviroment;
        this.showGroupButton = showGroupButton;
        this.setTitle(title);
        this.initialize();
    }

    private void initialize() {
        try {
            this.setIconImage(ImageIO.read(AbstractHistoryAreaToursDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JPanel centerPane = new JPanel(new SpringLayout());
        JLabel areaLayerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]) + ":");
        centerPane.add(areaLayerLabel);
        AreaObjectGenInfoDiscriminator[] discriminators = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT};
        final AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, false, discriminators, false, true);
        centerPane.add(areaLayerComboBox);
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0]) + ":"));
        final DefaultAreaObjectChooserPane areaObjectChooserPane = new DefaultAreaObjectChooserPane((AreaLayerModel)areaLayerComboBox.getItemAt(0), this.modelEnviroment, false){
            private static final long serialVersionUID = -9039583096395474830L;

            @Override
            protected String getShowAllMessageKey() {
                return "messages.area.selectAll";
            }
        };
        centerPane.add(areaObjectChooserPane);
        areaLayerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    areaObjectChooserPane.setAreaLayerModel((AreaLayerModel)areaLayerComboBox.getSelectedItem());
                    areaObjectChooserPane.clearSelection();
                }
            }
        });
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.startDate", new Serializable[0])));
        final JSpinner startDateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        startDateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JSpinner.DateEditor startEditor = new JSpinner.DateEditor(startDateSpinner, FormUtil.DATEFORMAT);
        startDateSpinner.setEditor(startEditor);
        centerPane.add(startDateSpinner);
        int rowSize = 3;
        JCheckBox groupCheckBox = new JCheckBox();
        if (this.showGroupButton) {
            centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.optimise.group", new Serializable[0])));
            centerPane.add(groupCheckBox);
            ++rowSize;
        }
        SpringUtilities.makeCompactGrid(centerPane, rowSize, 2, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.run", new Serializable[0])){
            private static final long serialVersionUID = 1782051459727529295L;

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    AbstractHistoryAreaToursDialog.this.dispose();
                    AreaLayerModel selectedItem = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
                    if (selectedItem != null) {
                        String title = AbstractHistoryAreaToursDialog.this.getRunDialogTitle();
                        String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]);
                        AbstractAsynchronousDialog<WageExportDto> asynchronousDialog = new AbstractAsynchronousDialog<WageExportDto>(AbstractHistoryAreaToursDialog.this.getOwner(), title, message, AbstractHistoryAreaToursDialog.this.getProgressBarCount(AbstractHistoryAreaToursDialog.this.modelEnviroment), true, AbstractHistoryAreaToursDialog.this.modelEnviroment){
                            private static final long serialVersionUID = 1084151788252987922L;

                            @Override
                            protected AsynchronousDto<WageExportDto> getAsynchronousDto(String token) {
                                ModelEnviroment modelEnviroment = super.getModelEnviroment();
                                return AbstractHistoryAreaToursDialog.this.getResult(token, modelEnviroment);
                            }

                            @Override
                            protected String startAsynchronous() {
                                HistoryAreaTourSearchDto searchDto = new HistoryAreaTourSearchDto(((AreaLayerModel)areaLayerComboBox.getSelectedItem()).getDisplayname(), areaObjectChooserPane.getSelectedShortcuts(), (Date)startDateSpinner.getValue(), null, null);
                                ModelEnviroment modelEnviroment = super.getModelEnviroment();
                                return AbstractHistoryAreaToursDialog.this.start(searchDto, modelEnviroment);
                            }
                        };
                        try {
                            Tupel tourExportDto = asynchronousDialog.run();
                            if (tourExportDto.getElement1() == null) {
                                return;
                            }
                            if (((WageExportDto)tourExportDto.getElement1()).getErrorMessages() != null && ((WageExportDto)tourExportDto.getElement1()).getErrorMessages().hasErrors()) {
                                BufferedImage image;
                                try {
                                    image = ImageIO.read(AbstractHistoryAreaToursDialog.class.getResourceAsStream("/images/pepper.png"));
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(AbstractHistoryAreaToursDialog.this.getOwner(), ModelEnviroment.getMessageResolver(), ((WageExportDto)tourExportDto.getElement1()).getErrorMessages(), image);
                                errorMessageDialog.setVisible(true);
                                break block12;
                            }
                            AbstractHistoryAreaToursDialog.this.result.clear();
                            for (HistoryAreaTourDto historyAreaTourDto : ((WageExportDto)tourExportDto.getElement1()).getDtos()) {
                                if (historyAreaTourDto == null) continue;
                                AbstractHistoryAreaToursDialog.this.result.add((HistoryAreaTourModel)AbstractHistoryAreaToursDialog.this.modelEnviroment.getModelCache().getModel(historyAreaTourDto));
                            }
                            StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.successful", new Serializable[0]) + ":\n");
                            for (String shortcut : ((WageExportDto)tourExportDto.getElement1()).getSuccessFullShortcuts()) {
                                sb.append("\n").append(shortcut);
                            }
                            sb.append("\n\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.area.failed", new Serializable[0]) + ":\n");
                            for (String shortcut : ((WageExportDto)tourExportDto.getElement1()).getFailedShortcuts()) {
                                sb.append("\n").append(shortcut);
                            }
                            JTextArea jTextArea = new JTextArea(sb.toString(), 20, 100);
                            jTextArea.setEditable(false);
                            JOptionPane.showMessageDialog(AbstractHistoryAreaToursDialog.this.getOwner(), new JScrollPane(jTextArea), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.protocol", new Serializable[0]), 1);
                        }
                        catch (TourCalculationBlockException ex) {
                            JOptionPane.showMessageDialog(AbstractHistoryAreaToursDialog.this.getOwner(), ModelEnviroment.getMessageResolver().resolveMessage("messages.tourCalculation.blocked", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
                        }
                        catch (RuntimeException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5138769151459307689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractHistoryAreaToursDialog.this.dispose();
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)centerPane, "Center");
        pane.add((Component)buttonPane, "South");
        super.getContentPane().add((Component)pane, "Center");
    }

    protected List<HistoryAreaTourModel> getResult() {
        return this.result;
    }

    protected abstract String getRunDialogTitle();

    protected abstract AsynchronousDto<WageExportDto> getResult(String var1, ModelEnviroment var2);

    protected abstract String start(HistoryAreaTourSearchDto var1, ModelEnviroment var2);

    protected abstract int getProgressBarCount(ModelEnviroment var1);

    public void setShowGroupButton(boolean showGroupButton) {
        this.showGroupButton = showGroupButton;
    }
}

