/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.wage.WageModifierDto;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.wage.action.ShowDeliveryRoundConfigrationDialogAction;
import de.datomino.peppergis.wage.gui.history.WageDeltaManagerGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class WageDeltaControlPane
extends JPanel {
    private static final long serialVersionUID = -1620577970235616276L;
    private WageDeltaManagerGui wageDeltaManager;

    public WageDeltaControlPane(WageDeltaManagerGui wageDeltaManager) {
        super(new BorderLayout());
        this.wageDeltaManager = wageDeltaManager;
        this.initialize();
    }

    private void initialize() {
        JMenu createSettleMenu;
        JMenu createParameterMenu;
        JMenuBar menuBar = new JMenuBar();
        JMenu createEditMenu = this.createEditMenu();
        if (createEditMenu != null) {
            menuBar.add(createEditMenu);
        }
        if ((createParameterMenu = this.createParameterMenu()) != null) {
            menuBar.add(createParameterMenu);
        }
        if ((createSettleMenu = this.createSettleMenu()) != null) {
            menuBar.add(createSettleMenu);
        }
        this.add((Component)menuBar, "Center");
    }

    private JMenu createSettleMenu() {
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        JMenu wage = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.export", new Serializable[0]));
        boolean added = false;
        if (userInformation.isAdmin() || userInformation.isSuperUser() || userInformation.hasAtLeastOneRole(UserRole.WAGE_ACTIVE)) {
            wage.add(this.wageDeltaManager.getCalculateTimeWageAction());
            added = true;
        }
        if (userInformation.isAdmin() || userInformation.isSuperUser() || userInformation.hasAtLeastOneRole(UserRole.WAGE_ACTIVE)) {
            wage.add(this.wageDeltaManager.getExportTimeWageOnServerAction());
            added = true;
        }
        return added ? wage : null;
    }

    private JMenu createParameterMenu() {
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        if (userInformation.isAdmin() || userInformation.isSuperUser() || userInformation.hasAtLeastOneRole(UserRole.WAGE_ACTIVE)) {
            JMenu parameter = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0]));
            parameter.add(new ShowDeliveryRoundConfigrationDialogAction(this.wageDeltaManager));
            parameter.add(this.wageDeltaManager.getParameterSettingAction());
            parameter.add(this.wageDeltaManager.getShowHolidaySetAction());
            return parameter;
        }
        return null;
    }

    private JMenu createEditMenu() {
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        if (userInformation.isAdmin() || userInformation.isSuperUser() || userInformation.hasAtLeastOneRole(UserRole.WAGE_ACTIVE)) {
            JMenu calc = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.calculate", new Serializable[0]));
            calc.add(this.wageDeltaManager.getCreateHistoryAreaToursAction());
            List<WageModifierDto> wageModifierDtos = this.wageDeltaManager.getModelEnviroment().getAllCaller().getWageCaller().getHistoryAreaTourModifiers();
            for (WageModifierDto dto : wageModifierDtos) {
                calc.add(this.wageDeltaManager.createHistoryAreaTourModfierAction(dto));
            }
            calc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return calc;
        }
        return null;
    }
}

