/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.deliveryRound;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.deliveryRound.DeliveryRoundPane;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModelImpl;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModelImpl;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.WageParameterStatus;
import de.datomino.peppergis.type.WeekDay;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.peppergis.wage.gui.deliveryRound.DeliveryRoundWeekdayPlanPane;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class DeliveryRoundConfigrationDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = -369335284957268597L;
    private static final String DEFAULT_NEW_NAME = ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.newName", new Serializable[0]);
    private JList<DeliveryRoundModel> roundList;
    private DefaultListModel<DeliveryRoundModel> roundListModel;
    private DeliveryRoundPane editPane;
    private AddAction addAction;
    private DeleteAction deleteAction;
    private DuplicateAction duplicateAction;
    private DefaultAreaObjectChooserPane areaObjectChooserPane;
    private Map<AreaLayerModel, List<AreaObjectModel>> layerMap = new HashMap<AreaLayerModel, List<AreaObjectModel>>();
    private Map<AreaObjectModel, DeliveryRoundEntity> deliveryRoundMap = new HashMap<AreaObjectModel, DeliveryRoundEntity>();
    private Set<AreaObjectModel> selectedAreas = new HashSet<AreaObjectModel>();
    private List<WageParameterModel> wageParameters;

    public DeliveryRoundConfigrationDialog(Window parent, ModelEnviroment modelEnviroment) {
        super(modelEnviroment, parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.configuration", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        WageCaller wageCaller = modelEnviroment.getAllCaller().getWageCaller();
        WageParameterStatus[] statuses = new WageParameterStatus[]{WageParameterStatus.ACTIVE, WageParameterStatus.DEFAULT};
        this.wageParameters = new ArrayList<WageParameterModel>(wageCaller.fetchWageParameterWithStatus(statuses));
        Collections.sort(this.wageParameters, new StringComparator<WageParameterModel>(true){

            @Override
            protected String getString(WageParameterModel o) {
                return o.getName();
            }
        });
    }

    @Override
    protected Component getMainComponent() {
        JSplitPane panel = new JSplitPane(1);
        panel.setLeftComponent(this.createListPane());
        panel.setRightComponent(this.createEditPane());
        return panel;
    }

    private Component createEditPane() {
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(900, 600));
        this.editPane = new DeliveryRoundPane(null, true);
        this.editPane.setEnabled(false);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]), ClientSwingUtil.createScrollPane(this.editPane));
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]), this.createAreaPane());
        final DeliveryRoundWeekdayPlanPane planPane = new DeliveryRoundWeekdayPlanPane(this);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.weekPlan", new Serializable[0]), planPane);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (tabbedPane.getSelectedComponent().equals(planPane)) {
                    planPane.repaint(10L);
                }
            }
        });
        return tabbedPane;
    }

    private JPanel createAreaPane() {
        AreaObjectGenInfoDiscriminator[] ds = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND};
        final AreaLayerComboBox layerComboBox = new AreaLayerComboBox(this.modelEnviroment, true, ds, false, false);
        layerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DeliveryRoundConfigrationDialog.this.fireAreaPaneLayerChange((AreaLayerModel)layerComboBox.getSelectedItem(), false);
                }
            }
        });
        layerComboBox.setEnabled(false);
        JPanel areaObjectPane = new JPanel(new BorderLayout());
        this.areaObjectChooserPane = new DefaultAreaObjectChooserPane(null, this.modelEnviroment, false){
            private static final long serialVersionUID = -5269281459721221853L;

            @Override
            protected void fireMarkAreaCell(String shortCut, boolean selected) {
                List areas = (List)DeliveryRoundConfigrationDialog.this.layerMap.get(this.areaLayerModel);
                for (AreaObjectModel areaObject : areas) {
                    if (!areaObject.getShortcut().equals(shortCut)) continue;
                    if (selected) {
                        DeliveryRoundConfigrationDialog.this.selectedAreas.add(areaObject);
                        break;
                    }
                    DeliveryRoundConfigrationDialog.this.selectedAreas.remove(areaObject);
                    break;
                }
            }

            @Override
            protected void fireShowAll(boolean selected) {
                List areas = (List)DeliveryRoundConfigrationDialog.this.layerMap.get(this.areaLayerModel);
                if (areas == null) {
                    return;
                }
                if (selected) {
                    DeliveryRoundConfigrationDialog.this.selectedAreas.addAll(areas);
                } else {
                    DeliveryRoundConfigrationDialog.this.selectedAreas.removeAll(areas);
                }
            }

            @Override
            protected MouseListener createAreaTabelMouseListener() {
                return new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            if (areaList.getSelectedColumn() == 0) {
                                return;
                            }
                            String shortcut = (String)areaList.getModel().getValueAt(areaList.getSelectedRow(), 1);
                            DeliveryRoundConfigrationDialog.this.showWeekDayChooserDialog(shortcut);
                        }
                    }
                };
            }

            @Override
            protected String getShowAllMessageKey() {
                return "messages.area.selectAll";
            }
        };
        this.areaObjectChooserPane.clearSelection();
        areaObjectPane.add((Component)layerComboBox, "North");
        areaObjectPane.add((Component)this.areaObjectChooserPane, "Center");
        this.roundList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeliveryRoundModel selectedValue = (DeliveryRoundModel)DeliveryRoundConfigrationDialog.this.roundList.getSelectedValue();
                if (selectedValue == null) {
                    DeliveryRoundConfigrationDialog.this.editPane.setDeliveryRound(null);
                    DeliveryRoundConfigrationDialog.this.editPane.setEnabled(false);
                    layerComboBox.setEnabled(false);
                } else if (!selectedValue.equals(DeliveryRoundConfigrationDialog.this.editPane.getDeliveryRound())) {
                    DeliveryRoundConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
                    DeliveryRoundConfigrationDialog.this.editPane.setDeliveryRound(selectedValue);
                    layerComboBox.setEnabled(true);
                    DeliveryRoundConfigrationDialog.this.pack();
                    DeliveryRoundConfigrationDialog.this.editPane.setEnabled(true);
                    DeliveryRoundConfigrationDialog.this.fireAreaPaneLayerChange(DeliveryRoundConfigrationDialog.this.areaObjectChooserPane.getAreaLayerModel(), true);
                    layerComboBox.setSelectedItem(null);
                    DeliveryRoundConfigrationDialog.this.areaObjectChooserPane.setAreaLayerModel(null);
                }
            }
        });
        return areaObjectPane;
    }

    private void showWeekDayChooserDialog(String shortcut) {
        for (AreaObjectModel areaObject : this.layerMap.get(this.areaObjectChooserPane.getAreaLayerModel())) {
            DeliveryRoundEntity entity = this.deliveryRoundMap.get(areaObject);
            if (!areaObject.getShortcut().equals(shortcut)) continue;
            WeekDayDialog dialog = new WeekDayDialog(entity);
            dialog.setVisible(true);
            break;
        }
    }

    private JPanel createListPane() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.roundListModel = new DefaultListModel();
        this.roundList = new JList<DeliveryRoundModel>(this.roundListModel);
        this.roundList.setCellRenderer((ListCellRenderer<DeliveryRoundModel>)new AbstractListCellRenderer<DeliveryRoundModel>(){

            @Override
            protected String getStringFromValue(DeliveryRoundModel object) {
                return object.getName();
            }
        });
        JScrollPane scroll = new JScrollPane(this.roundList);
        listPanel.add((Component)scroll, "Center");
        this.roundList.setSelectionMode(0);
        JPanel listButtonPanel = new JPanel(new FlowLayout());
        this.addAction = new AddAction();
        listButtonPanel.add(new JButton(this.addAction));
        this.deleteAction = new DeleteAction();
        listButtonPanel.add(new JButton(this.deleteAction));
        this.duplicateAction = new DuplicateAction();
        listButtonPanel.add(new JButton(this.duplicateAction));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)listButtonPanel, "East");
        listPanel.add((Component)buttonPanel, "South");
        listPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0])));
        return listPanel;
    }

    @Override
    protected void fillData() {
        Collection<DeliveryRoundModel> models = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllDeliveryRounds();
        this.roundListModel.clear();
        for (DeliveryRoundModel model : models) {
            this.roundListModel.addElement(model);
        }
    }

    private void fireAreaPaneLayerChange(AreaLayerModel areaLayer, boolean clear) {
        DeliveryRoundModel round = this.editPane.getDeliveryRound();
        if (areaLayer == null || round == null) {
            return;
        }
        List<AreaObjectModel> areas = this.layerMap.get(areaLayer);
        if (areas == null) {
            AreaCaller areaCaller = this.modelEnviroment.getAllCaller().getAreaCaller();
            areas = areaCaller.fetchAreaObjectsByAreaLayer(areaLayer, true);
            this.layerMap.put(areaLayer, areas);
            for (AreaObjectModel area : areas) {
                DeliveryRoundEntity entity = new DeliveryRoundEntity();
                for (AreaDeliveryRoundModel areaRound : area.iterableAreaDeliveryRounds()) {
                    entity.putValue(areaRound);
                }
                this.deliveryRoundMap.put(area, entity);
            }
        }
        this.areaObjectChooserPane.setAreaLayerModel(areaLayer);
        if (clear) {
            this.selectedAreas.clear();
            this.areaObjectChooserPane.clearSelection();
        } else {
            this.areaObjectChooserPane.setShowAllSelected(false);
            HashSet<Long> areaIds = new HashSet<Long>();
            for (AreaObjectModel area : this.selectedAreas) {
                if (!area.getAreaLayer().equals(areaLayer)) continue;
                areaIds.add(area.getId());
            }
            this.areaObjectChooserPane.setSelectionIds(areaIds);
        }
        this.editPane.repaint(10L);
        this.pack();
    }

    @Override
    protected boolean close() {
        if (!this.isSelectionValid()) {
            return false;
        }
        if (!this.isAtLeastOneProductSet()) {
            return false;
        }
        HashMap<Tupel<DeliveryRoundModel, WageParameterModel>, DeliveryRoundRelationModel> relationCache = new HashMap<Tupel<DeliveryRoundModel, WageParameterModel>, DeliveryRoundRelationModel>();
        for (AreaObjectModel areaObject : this.deliveryRoundMap.keySet()) {
            this.removeOldRounds(areaObject);
            this.setAreaDeliveryRounds(areaObject, this.deliveryRoundMap.get(areaObject), relationCache);
        }
        return true;
    }

    private boolean isAtLeastOneProductSet() {
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < this.roundListModel.size(); ++i) {
            DeliveryRoundModel round = this.roundListModel.getElementAt(i);
            if (!round.isDeliveryProductsEmpty()) continue;
            names.add(round.getName());
        }
        if (!names.isEmpty()) {
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.error.noProducts", new Serializable[]{StringUtil.implode(names, ", ")}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            return false;
        }
        return true;
    }

    private boolean isSelectionValid() {
        ArrayList<String> errors = new ArrayList<String>();
        for (AreaObjectModel areaObject : this.deliveryRoundMap.keySet()) {
            if (!areaObject.getShortcut().equals("BMZ3639101")) continue;
            ArrayList<String> ss = new ArrayList<String>();
            DeliveryRoundEntity entity = this.deliveryRoundMap.get(areaObject);
            this.checkValid(this.getValidedRounds(entity.monday), WeekdayName.D1, ss);
            this.checkValid(this.getValidedRounds(entity.tuesday), WeekdayName.D2, ss);
            this.checkValid(this.getValidedRounds(entity.wednesday), WeekdayName.D3, ss);
            this.checkValid(this.getValidedRounds(entity.thursday), WeekdayName.D4, ss);
            this.checkValid(this.getValidedRounds(entity.friday), WeekdayName.D5, ss);
            this.checkValid(this.getValidedRounds(entity.saturday), WeekdayName.D6, ss);
            this.checkValid(this.getValidedRounds(entity.sunday), WeekdayName.D7, ss);
            if (ss.isEmpty()) continue;
            ss.add(0, AreaObjectModelUtil.getShortcutAndDisplayname(areaObject));
            errors.add(StringUtil.implode(ss, "/n"));
        }
        if (errors.isEmpty()) {
            return true;
        }
        ErrorMessagesDialog.creatAndShow(StringUtil.implode(errors, "/n"), this);
        return false;
    }

    private void checkValid(Set<DeliveryRoundModel> rounds, WeekdayName weekday, List<String> errors) {
        rounds.remove(null);
        HashSet<Product> productSet = new HashSet<Product>();
        HashSet multiple = new HashSet();
        for (DeliveryRoundModel round : rounds) {
            HashSet<Product> ps = new HashSet<Product>();
            for (DeliveryProductModel productModel : round.iterableDeliveryProducts()) {
                ps.add(productModel.getProduct());
            }
            ps.remove(null);
            for (Product p : ps) {
                if (productSet.contains((Object)p)) continue;
                productSet.add(p);
            }
        }
        if (!multiple.isEmpty()) {
            String s = StringUtil.implode(multiple, ", ", new NameGenerator<Product>(){

                @Override
                public String getName(Product t) {
                    return ModelEnviroment.getMessageResolver().resolveMessageForEnum(t);
                }
            });
            errors.add(" - " + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.error.multipleProducts", new Serializable[]{s, weekday.getName()}));
        }
    }

    private Set<DeliveryRoundModel> getValidedRounds(Map<DeliveryRoundModel, WageParameterModel> map) {
        HashSet<DeliveryRoundModel> rs = new HashSet<DeliveryRoundModel>();
        for (DeliveryRoundModel r : map.keySet()) {
            if (map.get(r) == null) continue;
            rs.add(r);
        }
        return rs;
    }

    private void setAreaDeliveryRounds(AreaObjectModel areaObject, DeliveryRoundEntity entity, Map<Tupel<DeliveryRoundModel, WageParameterModel>, DeliveryRoundRelationModel> relationCache) {
        for (WeekDay weekDay : WeekDay.values()) {
            Map map = entity.getValue(weekDay);
            for (DeliveryRoundModel round : map.keySet()) {
                WageParameterModel parameter = (WageParameterModel)map.get(round);
                if (round == null || parameter == null) continue;
                Tupel<DeliveryRoundModel, WageParameterModel> key = new Tupel<DeliveryRoundModel, WageParameterModel>(round, parameter);
                DeliveryRoundRelationModel rel = relationCache.get(key);
                if (rel == null) {
                    DeliveryRoundRelationModel deliveryRoundRelationModel = rel = round.getId() == null ? null : this.modelEnviroment.getAllCaller().getAreaCaller().fetchRoundRelation(round, parameter);
                    if (rel == null) {
                        rel = new DeliveryRoundRelationModelImpl();
                        rel.setDeliveryRound(round);
                        rel.setParameter(parameter);
                    }
                    relationCache.put(key, rel);
                }
                this.setAreaDeliveryRound(areaObject, rel, weekDay);
            }
        }
    }

    private void removeOldRounds(AreaObjectModel areaObject) {
        for (AreaDeliveryRoundModel ar : areaObject.iterableAreaDeliveryRounds()) {
            ar.setMonday(null);
            ar.setTuesday(null);
            ar.setWednesday(null);
            ar.setThursday(null);
            ar.setFriday(null);
            ar.setSaturday(null);
            ar.setSunday(null);
        }
    }

    private void setAreaDeliveryRound(AreaObjectModel areaObject, DeliveryRoundRelationModel roundRelation, WeekDay weekDay) {
        AreaDeliveryRoundModel empty = null;
        for (AreaDeliveryRoundModel ar : areaObject.iterableAreaDeliveryRounds()) {
            switch (weekDay) {
                case MONDAY: {
                    if (ar.getMonday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getMonday().equals(roundRelation)) break;
                    return;
                }
                case TUESDAY: {
                    if (ar.getTuesday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getTuesday().equals(roundRelation)) break;
                    return;
                }
                case WEDNESDAY: {
                    if (ar.getWednesday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getWednesday().equals(roundRelation)) break;
                    return;
                }
                case THURSDAY: {
                    if (ar.getThursday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getThursday().equals(roundRelation)) break;
                    return;
                }
                case FRIDAY: {
                    if (ar.getFriday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getFriday().equals(roundRelation)) break;
                    return;
                }
                case SATURDAY: {
                    if (ar.getSaturday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getSaturday().equals(roundRelation)) break;
                    return;
                }
                case SUNDAY: {
                    if (ar.getSunday() == null) {
                        empty = ar;
                        break;
                    }
                    if (!ar.getSunday().equals(roundRelation)) break;
                    return;
                }
            }
        }
        if (empty == null) {
            empty = new AreaDeliveryRoundModelImpl();
        }
        switch (weekDay) {
            case MONDAY: {
                empty.setMonday(roundRelation);
                break;
            }
            case TUESDAY: {
                empty.setTuesday(roundRelation);
                break;
            }
            case WEDNESDAY: {
                empty.setWednesday(roundRelation);
                break;
            }
            case THURSDAY: {
                empty.setThursday(roundRelation);
                break;
            }
            case FRIDAY: {
                empty.setFriday(roundRelation);
                break;
            }
            case SATURDAY: {
                empty.setSaturday(roundRelation);
                break;
            }
            case SUNDAY: {
                empty.setSunday(roundRelation);
            }
        }
        empty.setAreaObject(areaObject);
    }

    private String getNewName(String defaultName) {
        boolean found;
        String newName = defaultName;
        int suffixCount = 1;
        int size = this.roundListModel.getSize();
        block0: do {
            found = true;
            for (int i = 0; i < size; ++i) {
                DeliveryRoundModel element = this.roundListModel.getElementAt(i);
                if (!element.getName().equals(newName)) continue;
                newName = defaultName + "_" + suffixCount;
                ++suffixCount;
                found = false;
                continue block0;
            }
        } while (!found);
        return newName;
    }

    private DeliveryRoundModel cloneRound(DeliveryRoundModel round) {
        DeliveryRoundModelImpl clone = new DeliveryRoundModelImpl();
        clone.setName(round.getName());
        clone.setInformation(round.getInformation());
        return clone;
    }

    protected DeliveryRoundPane getEditPane() {
        return this.editPane;
    }

    protected JList<DeliveryRoundModel> getRoundList() {
        return this.roundList;
    }

    protected Map<AreaObjectModel, DeliveryRoundEntity> getDeliveryRoundMap() {
        return this.deliveryRoundMap;
    }

    protected Set<AreaObjectModel> getSelectedAreas() {
        return this.selectedAreas;
    }

    protected class DeliveryRoundEntity {
        protected Map<DeliveryRoundModel, WageParameterModel> monday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> tuesday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> wednesday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> thursday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> friday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> saturday = new HashMap<DeliveryRoundModel, WageParameterModel>();
        protected Map<DeliveryRoundModel, WageParameterModel> sunday = new HashMap<DeliveryRoundModel, WageParameterModel>();

        protected DeliveryRoundEntity() {
        }

        private void putValue(AreaDeliveryRoundModel areaRound) {
            if (areaRound.getMonday() != null && areaRound.getMonday().getDeliveryRound() != null && areaRound.getMonday().getParameter() != null) {
                this.monday.put(areaRound.getMonday().getDeliveryRound(), areaRound.getMonday().getParameter());
            }
            if (areaRound.getTuesday() != null && areaRound.getTuesday().getDeliveryRound() != null && areaRound.getTuesday().getParameter() != null) {
                this.tuesday.put(areaRound.getTuesday().getDeliveryRound(), areaRound.getTuesday().getParameter());
            }
            if (areaRound.getWednesday() != null && areaRound.getWednesday().getDeliveryRound() != null && areaRound.getWednesday().getParameter() != null) {
                this.wednesday.put(areaRound.getWednesday().getDeliveryRound(), areaRound.getWednesday().getParameter());
            }
            if (areaRound.getThursday() != null && areaRound.getThursday().getDeliveryRound() != null && areaRound.getThursday().getParameter() != null) {
                this.thursday.put(areaRound.getThursday().getDeliveryRound(), areaRound.getThursday().getParameter());
            }
            if (areaRound.getFriday() != null && areaRound.getFriday().getDeliveryRound() != null && areaRound.getFriday().getParameter() != null) {
                this.friday.put(areaRound.getFriday().getDeliveryRound(), areaRound.getFriday().getParameter());
            }
            if (areaRound.getSaturday() != null && areaRound.getSaturday().getDeliveryRound() != null && areaRound.getSaturday().getParameter() != null) {
                this.saturday.put(areaRound.getSaturday().getDeliveryRound(), areaRound.getSaturday().getParameter());
            }
            if (areaRound.getSunday() != null && areaRound.getSunday().getDeliveryRound() != null && areaRound.getSunday().getParameter() != null) {
                this.sunday.put(areaRound.getSunday().getDeliveryRound(), areaRound.getSunday().getParameter());
            }
        }

        private Map<DeliveryRoundModel, WageParameterModel> getValue(WeekDay weekDay) {
            switch (weekDay) {
                case MONDAY: {
                    return this.monday;
                }
                case TUESDAY: {
                    return this.tuesday;
                }
                case WEDNESDAY: {
                    return this.wednesday;
                }
                case THURSDAY: {
                    return this.thursday;
                }
                case FRIDAY: {
                    return this.friday;
                }
                case SATURDAY: {
                    return this.saturday;
                }
                case SUNDAY: {
                    return this.sunday;
                }
            }
            return null;
        }
    }

    private class WeekDayDialog
    extends AbstractCommonDialog {
        private static final long serialVersionUID = -5089441551343031378L;
        private DeliveryRoundEntity entity;

        public WeekDayDialog(DeliveryRoundEntity entity) {
            super(DeliveryRoundConfigrationDialog.this.modelEnviroment, DeliveryRoundConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.weekDaySelection", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL, false);
            this.entity = entity;
            this.buildLayout();
            this.pack();
            this.center();
        }

        @Override
        protected Component getMainComponent() {
            JPanel weekDayPane = new JPanel(new SpringLayout());
            int row = 8;
            weekDayPane.add(new JLabel(""));
            weekDayPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0])));
            weekDayPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.MONDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.TUESDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.WEDNESDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.THURSDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.FRIDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.SATURDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday", new Serializable[0])));
            row = this.addWeekDayRounds(WeekDay.SUNDAY, weekDayPane, row, new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday", new Serializable[0])));
            SpringUtilities.makeCompactGrid(weekDayPane, row, 3, 5, 5, 5, 5);
            return weekDayPane;
        }

        private int addWeekDayRounds(WeekDay weekDay, JPanel pane, int row, JLabel label) {
            Map value = this.entity.getValue(weekDay);
            if (value.isEmpty()) {
                pane.add(label);
                pane.add(new JLabel(""));
                pane.add(new JLabel(""));
            } else {
                for (DeliveryRoundModel round : value.keySet()) {
                    WageParameterModel parameter = (WageParameterModel)value.get(round);
                    pane.add(label);
                    pane.add(new JLabel(round == null ? "" : round.getName()));
                    pane.add(new JLabel(parameter == null ? "" : parameter.getName()));
                    label = new JLabel("");
                }
                row += value.size() - 1;
            }
            return row;
        }
    }

    private class DuplicateAction
    extends AbstractAction {
        private static final long serialVersionUID = 4080260673389270000L;

        public DuplicateAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeliveryRoundModel round = DeliveryRoundConfigrationDialog.this.editPane.getDeliveryRound();
            if (round != null) {
                int size = DeliveryRoundConfigrationDialog.this.roundListModel.getSize();
                DeliveryRoundModel newRound = DeliveryRoundConfigrationDialog.this.cloneRound(round);
                newRound.setName(DeliveryRoundConfigrationDialog.this.getNewName(round.getName()));
                DeliveryRoundConfigrationDialog.this.roundListModel.addElement(newRound);
                DeliveryRoundConfigrationDialog.this.roundList.setSelectedIndex(size);
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 5326031995073736407L;

        public DeleteAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeliveryRoundModel round = DeliveryRoundConfigrationDialog.this.editPane.getDeliveryRound();
            if (round != null) {
                TourCaller tourCaller = DeliveryRoundConfigrationDialog.this.modelEnviroment.getAllCaller().getTourCaller();
                if (tourCaller.isUsedDeliverRound(round)) {
                    ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.error.isUsed", new Serializable[0]), DeliveryRoundConfigrationDialog.this);
                    return;
                }
                int d = JOptionPane.showConfirmDialog(DeliveryRoundConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.delete.confirmDeleteAlert", new Serializable[]{round.getName()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]), 2, 2);
                if (d == 0) {
                    for (DeliveryProductModel product : round.iterableDeliveryProducts()) {
                        product.delete();
                    }
                    round.delete();
                    DeliveryRoundConfigrationDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]) + " - " + round.getName());
                    DeliveryRoundConfigrationDialog.this.modelEnviroment.getUndoManager().startTransaction();
                    DeliveryRoundConfigrationDialog.this.roundListModel.removeElement(round);
                    DeliveryRoundConfigrationDialog.this.editPane.setDeliveryRound(null);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -2927549482943326863L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int size = DeliveryRoundConfigrationDialog.this.roundListModel.getSize();
            DeliveryRoundModelImpl newRound = new DeliveryRoundModelImpl();
            newRound.setName(DeliveryRoundConfigrationDialog.this.getNewName(DEFAULT_NEW_NAME));
            DeliveryRoundConfigrationDialog.this.roundListModel.addElement(newRound);
            DeliveryRoundConfigrationDialog.this.roundList.setSelectedIndex(size);
        }
    }
}

