/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.action;

import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.wage.WageExportDto;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;

public class ExportTimeWageAction
extends AbstractAction {
    private static final long serialVersionUID = -3453671621376910124L;
    protected ModelEnviroment modelEnviroment;
    protected Component parent;

    public ExportTimeWageAction(String titel, ModelEnviroment modelEnviroment, Component parent) {
        super(titel);
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JDialog dialog = new JDialog();
        try {
            dialog.setIconImage(ImageIO.read(ExportTimeWageAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.server", new Serializable[0]));
        JPanel centerPane = new JPanel(new SpringLayout());
        JLabel areaLayerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]) + ":");
        centerPane.add(areaLayerLabel);
        final DefaultComboBoxModel areaLayerComboBoxModel = this.createAreaLayerComboBoxModel();
        areaLayerComboBoxModel.setSelectedItem(null);
        centerPane.add(new JComboBox(areaLayerComboBoxModel));
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.startDate", new Serializable[0])));
        final JSpinner startDateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        startDateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JSpinner.DateEditor startEditor = new JSpinner.DateEditor(startDateSpinner, FormUtil.DATEFORMAT);
        startDateSpinner.setEditor(startEditor);
        centerPane.add(startDateSpinner);
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.endDate", new Serializable[0])));
        final JSpinner endDateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        endDateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JSpinner.DateEditor endEditor = new JSpinner.DateEditor(endDateSpinner, FormUtil.DATEFORMAT);
        endDateSpinner.setEditor(endEditor);
        centerPane.add(endDateSpinner);
        SpringUtilities.makeCompactGrid(centerPane, 3, 2, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = -6566029355912572239L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                String selectedLayer = (String)areaLayerComboBoxModel.getSelectedItem();
                Date start = (Date)startDateSpinner.getValue();
                start = TimeUtil.normalize(start);
                Date end = (Date)endDateSpinner.getValue();
                end = TimeUtil.setTime(end, 23, 59, 59);
                HashSet<Date> dates = new HashSet<Date>();
                do {
                    dates.add(start);
                } while ((start = TimeUtil.add(start, 5, 1)).before(end));
                WageCaller wageCaller = ExportTimeWageAction.this.modelEnviroment.getAllCaller().getWageCaller();
                WageExportDto result = wageCaller.exportTimeWageOnServer(CollectionUtil.buildHashSet(selectedLayer), dates);
                Window owner = SwingUtils.findWindowParent(ExportTimeWageAction.this.parent);
                if (result.getErrorMessages() != null && result.getErrorMessages().hasErrors()) {
                    BufferedImage image;
                    try {
                        image = ImageIO.read(ExportTimeWageAction.class.getResourceAsStream("/images/pepper.png"));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    ErrorMessageDialog error = new ErrorMessageDialog(owner, ModelEnviroment.getMessageResolver(), result.getErrorMessages(), image);
                    error.setVisible(true);
                } else {
                    StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.export.successful", new Serializable[0]) + ":\n");
                    for (String shortcut : result.getSuccessFullShortcuts()) {
                        sb.append("\n").append(shortcut);
                    }
                    sb.append("\n\n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.error.timeWageFile.exists", new Serializable[0]) + ":\n");
                    for (String shortcut : result.getFailedShortcuts()) {
                        sb.append("\n").append(shortcut);
                    }
                    JTextArea prot = new JTextArea(sb.toString(), 20, 100);
                    prot.setEditable(false);
                    JOptionPane.showMessageDialog(owner, new JScrollPane(prot), "Protokoll", 1);
                }
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5138769151459307689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)centerPane, "Center");
        pane.add((Component)buttonPane, "South");
        dialog.getContentPane().add((Component)pane, "Center");
        dialog.pack();
        SwingUtils.center((Window)dialog, this.parent);
        dialog.setVisible(true);
    }

    private DefaultComboBoxModel createAreaLayerComboBoxModel() {
        WageCaller wageCaller = this.modelEnviroment.getAllCaller().getWageCaller();
        Collection<String> areaLayers = wageCaller.fetchAreaLayersFromHistoryAreaTour();
        return new DefaultComboBoxModel<Object>(areaLayers.toArray());
    }
}

