/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.action;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.wage.WageExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.wage.CalculateTimeWageParameter;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public class CalculateTimeWageAction
extends AbstractAction {
    private static final long serialVersionUID = -3453671621376910124L;
    protected ModelEnviroment modelEnviroment;
    protected Component parent;

    public CalculateTimeWageAction(String titel, ModelEnviroment modelEnviroment, Component parent) {
        super(titel);
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window window = SwingUtils.findWindowParent(this.parent);
        final JDialog dialog = new JDialog();
        dialog.setIconImage(PeppergisConstants.ICON_IMAGE);
        dialog.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.list", new Serializable[0]));
        JPanel optionsPane = new JPanel(new FlowLayout());
        final JCheckBox areaType = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]));
        areaType.setSelected(true);
        optionsPane.add(areaType);
        final JCheckBox deliverersInMoreTable = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer1", new Serializable[0]));
        deliverersInMoreTable.setSelected(true);
        optionsPane.add(deliverersInMoreTable);
        JPanel centerPane = new JPanel(new SpringLayout());
        JLabel areaLayerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]) + ":");
        centerPane.add(areaLayerLabel);
        final DefaultComboBoxModel areaLayerComboBoxModel = this.createAreaLayerComboBoxModel();
        areaLayerComboBoxModel.setSelectedItem(null);
        centerPane.add(new JComboBox(areaLayerComboBoxModel));
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.startDate", new Serializable[0])));
        final JSpinner startDateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        startDateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JSpinner.DateEditor startEditor = new JSpinner.DateEditor(startDateSpinner, FormUtil.DATEFORMAT);
        startDateSpinner.setEditor(startEditor);
        centerPane.add(startDateSpinner);
        centerPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.endDate", new Serializable[0])));
        final JSpinner endDateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        endDateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JSpinner.DateEditor endEditor = new JSpinner.DateEditor(endDateSpinner, FormUtil.DATEFORMAT);
        endDateSpinner.setEditor(endEditor);
        centerPane.add(endDateSpinner);
        SpringUtilities.makeCompactGrid(centerPane, 3, 2, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractExportFileAction<Object>(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]), window, "csv"){
            private static final long serialVersionUID = -3966880369136216930L;

            @Override
            protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
                dialog.dispose();
                AbstractAsynchronousDialog<WageExportDto> asynchronousDialog = new AbstractAsynchronousDialog<WageExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.settle", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, CalculateTimeWageAction.this.modelEnviroment){
                    private static final long serialVersionUID = -9010756475037313167L;

                    @Override
                    protected AsynchronousDto<WageExportDto> getAsynchronousDto(String token) {
                        return CalculateTimeWageAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().getCalculateTimeWageResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        CalculateTimeWageParameter parameter = new CalculateTimeWageParameter();
                        parameter.setAreaTimeWage(areaType.isSelected());
                        parameter.setDelivererTimeWage(deliverersInMoreTable.isSelected());
                        parameter.setStartDate((Date)startDateSpinner.getValue());
                        parameter.setEndDate((Date)endDateSpinner.getValue());
                        return CalculateTimeWageAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().calculateTimeWage((String)areaLayerComboBoxModel.getSelectedItem(), null, parameter);
                    }
                };
                Tupel<Object, Object> tupel = new Tupel<Object, Object>(null, null);
                try {
                    Tupel exportDto = asynchronousDialog.run();
                    tupel.setElement1(((WageExportDto)exportDto.getElement1()).getContent());
                    tupel.setElement2(((WageExportDto)exportDto.getElement1()).getErrorMessages());
                }
                catch (Exception ex) {
                    if (ex instanceof ClientExportException) {
                        throw (ClientExportException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
                return tupel;
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5138769151459307689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)optionsPane, "North");
        pane.add((Component)centerPane, "Center");
        pane.add((Component)buttonPane, "South");
        dialog.getContentPane().add((Component)pane, "Center");
        dialog.pack();
        SwingUtils.center((Window)dialog, this.parent);
        dialog.setVisible(true);
    }

    private DefaultComboBoxModel createAreaLayerComboBoxModel() {
        WageCaller wageCaller = this.modelEnviroment.getAllCaller().getWageCaller();
        Collection<String> areaLayers = wageCaller.fetchAreaLayersFromHistoryAreaTour();
        return new DefaultComboBoxModel<Object>(areaLayers.toArray());
    }
}

