/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage;

import de.datomino.peppergis.type.Product;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductWeightParameter
implements Serializable {
    private static final long serialVersionUID = 3622620615848314912L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductWeightParameter.class);
    private Map<Product, Integer> productMaxWeight;
    private Double reloadFlatTime;

    public Map<Product, Integer> getProductMaxWeight() {
        return this.productMaxWeight == null ? Collections.emptyMap() : this.productMaxWeight;
    }

    public void setProductMaxWeight(Map<String, String> productMaxWeight) {
        this.productMaxWeight = new HashMap<Product, Integer>();
        for (String key : productMaxWeight.keySet()) {
            String value = productMaxWeight.get(key);
            Product product = Product.valueOf(key);
            if (product == null || !StringUtil.isBlank(value) && !NumberUtils.isNumber(value)) {
                LOGGER.error("Invalid product weight - " + key + " - " + value);
                continue;
            }
            Integer weight = StringUtil.isBlank(value) ? null : NumberUtils.createInteger(value);
            this.productMaxWeight.put(product, weight);
        }
    }

    public Double getReloadFlatTime() {
        return this.reloadFlatTime == null ? 0.0 : this.reloadFlatTime;
    }

    public void setReloadFlatTime(Double reloadFlatTime) {
        this.reloadFlatTime = reloadFlatTime;
    }
}

