/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import de.datomino.logistic.type.RouteVehicleType;
import java.io.Serializable;
import java.util.Properties;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewardEntity
implements Serializable {
    private static final long serialVersionUID = -6845061348911453562L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RewardEntity.class);
    private Double kmRewardMotor;
    private Double kmRewardBike;
    private Double kmRewardFoot;
    private Double hourReward;
    private Double nightSurcharge;
    private Integer nightSurchargeMinMinutes;
    private Double extraCharge;

    public RewardEntity(Double kmRewardMotor, Double kmRewardBike, Double kmRewardFoot, Double hourReward, Double nightSurcharge, Integer nightSurchargeMinSeconds, Double extraCharge) {
        this.kmRewardMotor = kmRewardMotor;
        this.kmRewardBike = kmRewardBike;
        this.kmRewardFoot = kmRewardFoot;
        this.hourReward = hourReward;
        this.nightSurcharge = nightSurcharge;
        this.nightSurchargeMinMinutes = nightSurchargeMinSeconds;
        this.extraCharge = extraCharge;
    }

    public RewardEntity(Properties properties) {
        this.kmRewardMotor = this.getValue("areatour.cost.kmRewardMotor", properties);
        this.kmRewardBike = this.getValue("areatour.cost.kmRewardBike", properties);
        this.kmRewardFoot = this.getValue("areatour.cost.kmRewardFoot", properties);
        this.hourReward = this.getValue("areatour.cost.hourReward", properties);
        this.nightSurcharge = this.getValue("areatour.cost.nightSurcharge", properties);
        this.nightSurchargeMinMinutes = (int)Math.round(this.getValue("areatour.cost.nightSurchargeMinMinutes", properties));
        this.extraCharge = this.getValue("areatour.cost.extraCharge", properties);
    }

    private Double getValue(String key, Properties properties) {
        Double value = 0.0;
        String property = properties.getProperty(key);
        try {
            value = Double.valueOf(property);
        }
        catch (Exception e) {
            LOGGER.error("Invalid reward - key: " + key + " value:" + property);
        }
        return value;
    }

    public Tupel<Double, Double> getRewardForVehicle(RouteVehicleType vehicle) {
        Tupel<Double, Double> tupel = new Tupel<Double, Double>(0.0, 0.0);
        switch (vehicle == null ? RouteVehicleType.FOOT : vehicle) {
            case BIKE: {
                tupel.setElement1(this.getKmRewardBike());
                tupel.setElement2(this.getHourReward());
                break;
            }
            case FOOT: {
                tupel.setElement1(this.getKmRewardFoot());
                tupel.setElement2(this.getHourReward());
                break;
            }
            case MOTORCAR: {
                tupel.setElement1(this.getKmRewardMotor());
                tupel.setElement2(this.getHourReward());
            }
        }
        return tupel;
    }

    public Double getKmRewardMotor() {
        return this.kmRewardMotor;
    }

    public void setKmRewardMotor(Double kmRewardMotor) {
        this.kmRewardMotor = kmRewardMotor;
    }

    public Double getKmRewardBike() {
        return this.kmRewardBike;
    }

    public void setKmRewardBike(Double kmRewardBike) {
        this.kmRewardBike = kmRewardBike;
    }

    public Double getKmRewardFoot() {
        return this.kmRewardFoot;
    }

    public void setKmRewardFoot(Double kmRewardFoot) {
        this.kmRewardFoot = kmRewardFoot;
    }

    public Double getHourReward() {
        return this.hourReward;
    }

    public void setHourReward(Double hourRewardMotor) {
        this.hourReward = hourRewardMotor;
    }

    public Double getNightSurcharge() {
        return this.nightSurcharge;
    }

    public void setNightSurcharge(Double nightSurcharge) {
        this.nightSurcharge = nightSurcharge;
    }

    public Integer getNightSurchargeMinMinutes() {
        return this.nightSurchargeMinMinutes;
    }

    public void setNightSurchargeMinMinutes(Integer nightSurchargeMinMinutes) {
        this.nightSurchargeMinMinutes = nightSurchargeMinMinutes;
    }

    public Double getExtraCharge() {
        return this.extraCharge;
    }

    public void setExtraCharge(Double extraCharge) {
        this.extraCharge = extraCharge;
    }
}

