/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import de.datomino.peppergis.util.DistanceComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.math.MathHelper;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoUtil
extends GeoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoUtil.class);
    public static final List<Color> COLORLIST = CollectionUtil.buildArrayList(new Color(0, 0, 255), new Color(255, 0, 0), new Color(0, 94, 0), new Color(0, 0, 0), new Color(255, 215, 0), new Color(100, 149, 237), new Color(255, 140, 0), new Color(126, 252, 0), new Color(128, 128, 128), new Color(75, 0, 130), new Color(255, 105, 180), new Color(0, 139, 139), new Color(139, 69, 19), new Color(127, 255, 212), new Color(153, 50, 204));

    public static AbstractImmutableGeoObject createLineString(ImmutablePoint point1, ImmutablePoint point2) {
        point1 = (ImmutablePoint)point1.getTransformed(point2.getCoordinateFactory());
        AbstractImmutableValidGeoObject lineStringOrPoint = null;
        if (point1 == null || point2 == null) {
            lineStringOrPoint = null;
        } else if (point1.getCoordinate().equals(point2.getCoordinate())) {
            lineStringOrPoint = point1;
        } else {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>(2);
            coords.add(point1.getCoordinate());
            coords.add(point2.getCoordinate());
            lineStringOrPoint = ImmutableGeoObjectFactory.createImmutableLineString(coords);
        }
        return lineStringOrPoint;
    }

    public static Tupel<Double, ImmutablePoint> getShortestPerpendicular(ImmutablePoint point, ImmutableLineString lineString) {
        Tupel<Object, Object> shortestPerpendicular = new Tupel<Object, Object>(null, null);
        List<ImmutablePoint> pointsOfLine = lineString.getCoordinates();
        for (int i = 0; i < pointsOfLine.size() - 1; ++i) {
            Tupel<Double, ImmutablePoint> perpendicular = GeoUtil.getFoot(point, pointsOfLine.get(i), pointsOfLine.get(i + 1), true);
            if (shortestPerpendicular.getElement1() != null && !(perpendicular.getElement1() < (Double)shortestPerpendicular.getElement1())) continue;
            shortestPerpendicular.setElement1(perpendicular.getElement1());
            shortestPerpendicular.setElement2(perpendicular.getElement2());
        }
        return shortestPerpendicular;
    }

    public static Tupel<Double, ImmutablePoint> getFoot(ImmutablePoint topPoint, ImmutablePoint startPoint, ImmutablePoint endPoint, boolean online) {
        CoordinateFactory factory = topPoint.getCoordinateFactory();
        Coordinate top = ((ImmutablePoint)topPoint.getTransformed(OpenStreetmapViewFactory.INSTANCE)).getCoordinate();
        Coordinate start = ((ImmutablePoint)startPoint.getTransformed(OpenStreetmapViewFactory.INSTANCE)).getCoordinate();
        Coordinate end = ((ImmutablePoint)endPoint.getTransformed(OpenStreetmapViewFactory.INSTANCE)).getCoordinate();
        Coordinate perpendicularFoot = GeoUtil.getPerpendicularFoot(top, start, end);
        Tupel<Object, Object> foot = new Tupel<Object, Object>(null, null);
        foot.setElement1(Math.sqrt(Math.pow(top.getX() - perpendicularFoot.getX(), 2.0) + Math.pow(top.getY() - perpendicularFoot.getY(), 2.0)));
        foot.setElement2(ImmutableGeoObjectFactory.createImmutablePoint(perpendicularFoot));
        if (online && !GeoUtil.isBetween(perpendicularFoot, start, end, 1.0)) {
            Double distanceToStart = Math.sqrt(Math.pow(top.getX() - start.getX(), 2.0) + Math.pow(top.getY() - start.getY(), 2.0));
            Double distanceToEnd = Math.sqrt(Math.pow(top.getX() - end.getX(), 2.0) + Math.pow(top.getY() - end.getY(), 2.0));
            if (distanceToStart < distanceToEnd) {
                foot.setElement1(distanceToStart);
                foot.setElement2(ImmutableGeoObjectFactory.createImmutablePoint(start));
            } else {
                foot.setElement1(distanceToEnd);
                foot.setElement2(ImmutableGeoObjectFactory.createImmutablePoint(end));
            }
        }
        foot.setElement2(((ImmutablePoint)foot.getElement2()).getTransformed(factory));
        return foot;
    }

    public static boolean isBetween(Coordinate coordinate, Coordinate start, Coordinate end, double tolerance) {
        OpenStreetmapViewFactory factory = OpenStreetmapViewFactory.INSTANCE;
        Coordinate perpendicularFootConv = factory.createCoordinate(coordinate);
        Coordinate startConv = factory.createCoordinate(start);
        Coordinate endConv = factory.createCoordinate(end);
        Line2D.Double line = new Line2D.Double(startConv.getX(), startConv.getY(), endConv.getX(), endConv.getY());
        double dist = line.ptSegDist(perpendicularFootConv.getX(), perpendicularFootConv.getY());
        return dist <= tolerance;
    }

    public static Coordinate getPerpendicularFoot(Coordinate top, Coordinate start, Coordinate end) {
        OpenStreetmapViewFactory factory = OpenStreetmapViewFactory.INSTANCE;
        Coordinate topConv = factory.createCoordinate(top);
        Coordinate startConv = factory.createCoordinate(start);
        Coordinate endConv = factory.createCoordinate(end);
        if (endConv.getX() == startConv.getX()) {
            return factory.createCoordinate(endConv.getX(), topConv.getY());
        }
        double k = (endConv.getY() - startConv.getY()) / (endConv.getX() - startConv.getX());
        double x = (k * k * startConv.getX() + k * (topConv.getY() - startConv.getY()) + topConv.getX()) / (k * k + 1.0);
        double y = k * (x - startConv.getX()) + startConv.getY();
        return factory.createCoordinate(x, y);
    }

    public static Set<Coordinate> getAreaRectangle(Collection<ImmutablePoint> points) {
        if (points == null || points.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Coordinate> areaRectangle = new HashSet<Coordinate>(2);
        Coordinate startPoint = points.iterator().next().getCoordinate();
        CoordinateFactory coordinateFactory = startPoint.getFactory();
        double maxX = startPoint.getX();
        double maxY = startPoint.getY();
        double minX = startPoint.getX();
        double minY = startPoint.getY();
        for (ImmutablePoint coord : points) {
            if ((coord = (ImmutablePoint)coord.getTransformed(coordinateFactory)).getX() < minX) {
                minX = coord.getX();
            } else if (coord.getX() > maxX) {
                maxX = coord.getX();
            }
            if (coord.getY() < minY) {
                minY = coord.getY();
                continue;
            }
            if (!(coord.getY() > maxY)) continue;
            maxY = coord.getY();
        }
        areaRectangle.add(coordinateFactory.createCoordinate(minX, minY));
        areaRectangle.add(coordinateFactory.createCoordinate(maxX, maxY));
        return areaRectangle;
    }

    public static Coordinate getCenter(Collection<Coordinate> coords) {
        if (coords == null || coords.isEmpty()) {
            return null;
        }
        Coordinate startPoint = coords.iterator().next();
        CoordinateFactory coordinateFactory = startPoint.getFactory();
        double maxX = startPoint.getX();
        double maxY = startPoint.getY();
        double minX = startPoint.getX();
        double minY = startPoint.getY();
        for (Coordinate coord : coords) {
            if ((coord = coordinateFactory.createCoordinate(coord)).getX() < minX) {
                minX = coord.getX();
            } else if (coord.getX() > maxX) {
                maxX = coord.getX();
            }
            if (coord.getY() < minY) {
                minY = coord.getY();
                continue;
            }
            if (!(coord.getY() > maxY)) continue;
            maxY = coord.getY();
        }
        return coordinateFactory.createCoordinate((minX + maxX) / 2.0, (minY + maxY) / 2.0);
    }

    public static Coordinate getCentre(Collection<ImmutablePoint> points) {
        if (points == null) {
            return null;
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(points.size());
        for (ImmutablePoint point : points) {
            coords.add(point.getCoordinate());
        }
        return GeoUtil.getCenter(coords);
    }

    public static Tupel<ImmutablePoint, ImmutablePoint> getBoundaryOfNavigatorPanel(NavigatorPanel navigatorPanel) {
        Point2D.Double topRight = navigatorPanel.getRealBoundaryTopRight();
        Point2D.Double bottomLeft = navigatorPanel.getRealBoundaryBottomLeft();
        if (topRight == null || bottomLeft == null || navigatorPanel.getCoordinateFactory() == null) {
            return null;
        }
        Coordinate topLeftCoordinate = navigatorPanel.getCoordinateFactory().createCoordinate(bottomLeft.x, topRight.y);
        Coordinate bottomRightCoordinate = navigatorPanel.getCoordinateFactory().createCoordinate(topRight.x, bottomLeft.y);
        ImmutablePoint topLeft = ImmutableGeoObjectFactory.createImmutablePoint(topLeftCoordinate);
        ImmutablePoint bottomRight = ImmutableGeoObjectFactory.createImmutablePoint(bottomRightCoordinate);
        return new Tupel<ImmutablePoint, ImmutablePoint>(topLeft, bottomRight);
    }

    public static Color getNextColor(Color color) {
        int currentIndex;
        int alpha = color == null ? 255 : color.getAlpha();
        int n = currentIndex = color == null ? -1 : COLORLIST.indexOf(color);
        if (currentIndex == COLORLIST.size() - 1) {
            return new Color(COLORLIST.get(0).getRed(), COLORLIST.get(0).getGreen(), COLORLIST.get(0).getBlue(), alpha);
        }
        return new Color(COLORLIST.get(currentIndex + 1).getRed(), COLORLIST.get(currentIndex + 1).getGreen(), COLORLIST.get(currentIndex + 1).getBlue(), alpha);
    }

    public static ImmutableEnvelope getEnvelope(ImmutablePoint point, double distance) {
        Coordinate c = Wgs84Factory.INSTANCE.createCoordinate(point.getCoordinate());
        double dx = GeoUtil.getLngDrift(c.getX(), c.getY(), distance);
        double dy = GeoUtil.getLatDrift(c.getX(), c.getY(), distance);
        return new ImmutableEnvelope(c.getX() - dx, c.getX() + dx, c.getY() - dy, c.getY() + dy, c.getFactory());
    }

    public static double calculateDistance(ImmutableLineString lineString) {
        double distance = 0.0;
        if (lineString == null || lineString.getCoordinates().isEmpty()) {
            return distance;
        }
        Iterator<ImmutablePoint> iter = lineString.getCoordinates().iterator();
        ImmutablePoint prev = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            distance += GeoUtils.getDistanceInMeter(prev.getCoordinate(), succ.getCoordinate());
            prev = succ;
        }
        return distance;
    }

    public static double calculateDistance(List<ImmutablePointDto> points) {
        double distance = 0.0;
        if (points == null || points.isEmpty()) {
            return distance;
        }
        Iterator<ImmutablePointDto> iter = points.iterator();
        ImmutablePointDto prev = iter.next();
        while (iter.hasNext()) {
            ImmutablePointDto succ = iter.next();
            if (prev.getGeoObject() != null && succ.getGeoObject() != null) {
                distance += GeoUtils.getDistanceInMeter(((ImmutablePoint)prev.getGeoObject()).getCoordinate(), ((ImmutablePoint)succ.getGeoObject()).getCoordinate());
            }
            prev = succ;
        }
        return distance;
    }

    public static ImmutableLineString getSubLineString(ImmutablePoint start, ImmutablePoint end, ImmutableLineString lineString) {
        if (lineString == null || lineString.getCoordinates().isEmpty()) {
            return ImmutableGeoObjectFactory.createImmutableLineStringFromPoints(Arrays.asList(start, end));
        }
        ImmutableLineString rLineString = lineString;
        ImmutablePoint foot1 = GeoUtil.getShortestPerpendicular(start, rLineString).getElement2();
        ImmutablePoint foot2 = GeoUtil.getShortestPerpendicular(end, rLineString).getElement2();
        ArrayList<ImmutablePoint> list = new ArrayList<ImmutablePoint>();
        list.add(foot1);
        Iterator<ImmutablePoint> iter = rLineString.getCoordinates().iterator();
        ImmutablePoint prev = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            if (list.size() == 1) {
                if (GeoUtil.isBetween(foot1.getCoordinate(), prev.getCoordinate(), succ.getCoordinate(), 1.0)) {
                    list.add(succ);
                }
            } else {
                if (GeoUtil.isBetween(foot2.getCoordinate(), prev.getCoordinate(), succ.getCoordinate(), 1.0)) break;
                list.add(succ);
            }
            prev = succ;
        }
        list.add(foot2);
        return ImmutableGeoObjectFactory.createImmutableLineStringFromPoints(list);
    }

    private static double getLngDrift(double lng1, double lat1, double distance) {
        double r = Math.pow(Math.sin(distance / 6371000.0 / 2.0), 2.0);
        double radLat1 = GeoUtil.deg2rad(lat1);
        double lngDrift = Math.asin(Math.sqrt(r / Math.cos(radLat1))) * 2.0;
        return GeoUtil.rad2deg(lngDrift);
    }

    private static double getLatDrift(double lng1, double lat1, double distance) {
        double r = Math.pow(Math.sin(distance / 6371000.0 / 2.0), 2.0);
        double latDrift = Math.asin(Math.sqrt(r)) * 2.0;
        return GeoUtil.rad2deg(latDrift);
    }

    public static Coordinate roundCoordinate(Coordinate coordinate) {
        Coordinate coordConv = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
        double x = coordConv.getX() * 100000.0;
        x = (double)Math.round(x) / 100000.0;
        double y = coordConv.getY() * 100000.0;
        y = (double)Math.round(y) / 100000.0;
        return Wgs84Factory.INSTANCE.createCoordinate(x, y);
    }

    public static List<ImmutableLineString> cutLinestringWithCrossing(ImmutableLineString lineString, Collection<ImmutableLineString> ls, Collection<ImmutablePoint> ps) {
        return GeoUtil.cutLinestringWithCrossing(lineString, ls, ps, true);
    }

    public static List<ImmutableLineString> cutLinestringWithCrossing(ImmutableLineString lineString, Collection<ImmutableLineString> ls, Collection<ImmutablePoint> ps, boolean killSelfIntersecting) {
        List<ImmutableLineString> olds = killSelfIntersecting ? GeoUtil.killSelfIntersecting(lineString) : CollectionUtil.buildArrayList(lineString);
        ArrayList<ImmutableLineString> news = new ArrayList<ImmutableLineString>();
        for (ImmutableLineString old : olds) {
            news.addAll(GeoUtil.cutLinestring(old, ls, ps));
        }
        return news;
    }

    private static List<ImmutableLineString> killSelfIntersecting(ImmutableLineString lineString) {
        ArrayList<ImmutableLineString> result = new ArrayList<ImmutableLineString>();
        List<ImmutablePoint> points = lineString.getCoordinates();
        ArrayList<ImmutablePoint> intersecting = new ArrayList<ImmutablePoint>();
        block0: for (int i = 0; i < points.size(); ++i) {
            ImmutablePoint point = points.get(i);
            for (int j = i + 2; j < points.size(); ++j) {
                ImmutablePoint next = points.get(j);
                if (!GeoUtil.areSamedPoints(point, next, (Double)0.1)) continue;
                intersecting.add(next);
                continue block0;
            }
        }
        for (ImmutablePoint point : intersecting) {
            Tupel<ImmutableLineString, ImmutableLineString> tupel = lineString.cutAtPoint(point);
            if (!GeoUtil.isValidLineString(tupel.getElement1()) || !GeoUtil.isValidLineString(tupel.getElement2())) continue;
            result.add(tupel.getElement1());
            lineString = tupel.getElement2();
        }
        result.add(lineString);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ImmutableLineString> cutLinestring(ImmutableLineString lineString, Collection<ImmutableLineString> ls, Collection<ImmutablePoint> ps) {
        HashSet<ImmutablePoint> crossings = new HashSet<ImmutablePoint>();
        if (ls != null) {
            for (ImmutableLineString immutableLineString : ls) {
                ImmutableGeoObject immutableGeoObject;
                if (immutableLineString == null || GeoUtil.areSamedPoints(lineString.getStartPoint(), immutableLineString.getStartPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getStartPoint(), immutableLineString.getEndPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getEndPoint(), immutableLineString.getStartPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getEndPoint(), immutableLineString.getEndPoint(), (Double)1.0) || (immutableGeoObject = immutableLineString.intersection(lineString)) == null) continue;
                crossings.addAll(immutableGeoObject.getCoordinates());
            }
            HashSet removed = new HashSet();
            for (ImmutablePoint immutablePoint : crossings) {
                if (!GeoUtil.areSamedPoints(lineString.getStartPoint(), immutablePoint, (Double)0.1) && !GeoUtil.areSamedPoints(lineString.getEndPoint(), immutablePoint, (Double)0.1)) continue;
                removed.add(immutablePoint);
            }
            crossings.removeAll(removed);
        }
        if (ps != null) {
            for (ImmutablePoint immutablePoint : ps) {
                if (immutablePoint == null || GeoUtil.areSamedPoints(immutablePoint, lineString.getStartPoint(), (Double)0.1) || GeoUtil.areSamedPoints(immutablePoint, lineString.getEndPoint(), (Double)0.1) || !GeoUtil.isOnLineString(immutablePoint, lineString)) continue;
                crossings.add(immutablePoint);
            }
        }
        ArrayList<ImmutableLineString> newLineStrings = new ArrayList<ImmutableLineString>(crossings.size() + 1);
        if (crossings.isEmpty()) {
            newLineStrings.add(lineString);
        } else {
            void var6_15;
            LinkedList<Tupel<ImmutablePoint, Double>> linkedList = new LinkedList<Tupel<ImmutablePoint, Double>>();
            for (ImmutablePoint crossing : crossings) {
                linkedList.add(new Tupel<ImmutablePoint, Double>(crossing, GeoUtil.getDistanceFromStart(lineString, crossing)));
            }
            Collections.sort(linkedList, new DistanceComparator());
            ImmutableLineString immutableLineString = lineString;
            Double lastDistance = null;
            for (Tupel tupel : linkedList) {
                if (lastDistance != null && lastDistance.equals(tupel.getElement2())) continue;
                lastDistance = (Double)tupel.getElement2();
                Tupel<ImmutableLineString, ImmutableLineString> tupel2 = var6_15.cutAtPoint((ImmutablePoint)tupel.getElement1());
                if (!GeoUtil.isValidLineString(tupel2.getElement1()) || !GeoUtil.isValidLineString(tupel2.getElement2())) continue;
                newLineStrings.add(tupel2.getElement1());
                ImmutableLineString immutableLineString2 = tupel2.getElement2();
            }
            newLineStrings.add((ImmutableLineString)var6_15);
        }
        return newLineStrings;
    }

    public static List<ImmutablePoint> findCrossings(ImmutableLineString lineString, Collection<ImmutableLineString> ls) {
        ArrayList<ImmutablePoint> crossings = new ArrayList<ImmutablePoint>();
        if (ls != null) {
            for (ImmutableLineString l : ls) {
                if (l == null || GeoUtil.areSamedPoints(lineString.getStartPoint(), l.getStartPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getStartPoint(), l.getEndPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getEndPoint(), l.getStartPoint(), (Double)1.0) || GeoUtil.areSamedPoints(lineString.getEndPoint(), l.getEndPoint(), (Double)1.0)) continue;
                try {
                    ImmutableGeoObject intersection = l.intersection(lineString);
                    if (intersection == null) continue;
                    crossings.addAll(intersection.getCoordinates());
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
        }
        return crossings;
    }

    private static boolean isValidLineString(ImmutableLineString lineString) {
        if (lineString == null) {
            return false;
        }
        HashSet<ImmutablePoint> points = new HashSet<ImmutablePoint>(lineString.getCoordinates());
        return points.size() > 1;
    }

    private static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    private static double rad2deg(double angle) {
        return angle * 180.0 / Math.PI;
    }

    public static boolean isNullPoint(ImmutablePoint point) {
        GeoDecimal100Factory factory;
        ImmutablePoint transformed;
        boolean b = true;
        if (point != null && MathHelper.between((transformed = (ImmutablePoint)point.getTransformed(factory = GeoDecimal100Factory.INSTANCE)).getX(), -180.0 * factory.getFactor(), 180.0 * factory.getFactor()) && MathHelper.between(transformed.getY(), -90.0 * factory.getFactor(), 90.0 * factory.getFactor()) && !MathHelper.between(transformed.getX(), -1.0, 1.0) && !MathHelper.between(transformed.getY(), -1.0, 1.0)) {
            b = false;
        }
        return b;
    }

    public static ImmutableLineString connectLineString(ImmutableLineString l1, ImmutableLineString l2, ImmutablePoint cross) {
        ArrayList points2;
        ArrayList<ImmutablePoint> points1 = l1 == null ? new ArrayList<ImmutablePoint>() : new ArrayList<ImmutablePoint>(((ImmutableLineString)l1.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinates());
        ArrayList<Object> arrayList = points2 = l2 == null ? new ArrayList() : new ArrayList<ImmutablePoint>(((ImmutableLineString)l2.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinates());
        if (cross != null) {
            ImmutablePoint newCross = (ImmutablePoint)cross.getTransformed(GeoDecimal100Factory.INSTANCE);
            if (l1.getStartPoint().equals(newCross)) {
                Collections.reverse(points1);
            }
            if (l2.getEndPoint().equals(newCross)) {
                Collections.reverse(points2);
            }
        }
        if (points1.size() > 0 && points2.size() > 0 && ((ImmutablePoint)points1.get(points1.size() - 1)).equals(points2.get(0))) {
            points2.remove(0);
        }
        points1.addAll(points2);
        return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points1);
    }

    public static boolean isOnLineString(ImmutablePoint point, ImmutableLineString lineString) {
        Coordinate coordinate = point.getCoordinate();
        Iterator<ImmutablePoint> iter = ((ImmutableLineString)lineString.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinates().iterator();
        ImmutablePoint prev = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            if (GeoUtil.isBetween(coordinate, prev.getCoordinate(), succ.getCoordinate(), 1.0)) {
                return true;
            }
            prev = succ;
        }
        return false;
    }

    public static ImmutableLineString reverse(ImmutableLineString lineString) {
        if (lineString == null) {
            return null;
        }
        ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(lineString.getCoordinates());
        Collections.reverse(points);
        return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points);
    }

    public static boolean isPointOnRight(ImmutablePoint point, ImmutablePoint pointOnLine, ImmutableLineString lineString) {
        if (point == null || lineString == null) {
            return false;
        }
        if (pointOnLine == null) {
            pointOnLine = GeoUtil.getShortestPerpendicular(point, lineString).getElement2();
        }
        Coordinate coordinate = ((ImmutablePoint)point.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinate();
        Coordinate onLine = ((ImmutablePoint)pointOnLine.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinate();
        Iterator<ImmutablePoint> iter = ((ImmutableLineString)lineString.getTransformed(GeoDecimal100Factory.INSTANCE)).getCoordinates().iterator();
        Coordinate pred = iter.next().getCoordinate();
        Coordinate succ = null;
        while (iter.hasNext() && !GeoUtil.isBetween(onLine, pred, succ = iter.next().getCoordinate(), 1.0)) {
            pred = succ;
        }
        double angleBase = Math.atan2(pred.getY() - succ.getY(), pred.getX() - succ.getX());
        double anglePoint = Math.atan2(onLine.getY() - coordinate.getY(), onLine.getX() - coordinate.getX());
        double angle = anglePoint - angleBase;
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        angle = ComputeTrigonometrics.normalizeAngle(angle);
        return angle >= Math.PI;
    }

    public static List<ImmutableLineString> adaptLineStringCollection(List<ImmutableLineString> lineStrings, Collection<ImmutablePoint> points) {
        if (points != null && !points.isEmpty() && lineStrings != null && !lineStrings.isEmpty()) {
            ArrayList<ImmutableLineString> newLinestrings = new ArrayList<ImmutableLineString>();
            for (ImmutableLineString lineString : lineStrings) {
                if (lineString == null) continue;
                newLinestrings.add(GeoUtil.adaptLineString(lineString, points));
            }
            return newLinestrings;
        }
        return lineStrings;
    }

    public static ImmutableLineString adaptLineString(ImmutableLineString lineString, Collection<ImmutablePoint> points) {
        boolean maxTolerance = true;
        for (ImmutablePoint point : points) {
            Tupel<Double, ImmutablePoint> shortest = GeoUtil.getShortestPerpendicular(point, lineString);
            Coordinate foot = shortest.getElement2().getCoordinate();
            double distance = GeoUtils.getDistanceInMeter(point.getCoordinate(), foot);
            if (!(distance < (double)maxTolerance)) continue;
            try {
                ArrayList<ImmutablePoint> newLinePoints = new ArrayList<ImmutablePoint>();
                Iterator<ImmutablePoint> iter = lineString.getCoordinates().iterator();
                ImmutablePoint start = iter.next();
                newLinePoints.add((ImmutablePoint)start.getTransformed(GeoDecimal100Factory.INSTANCE));
                while (iter.hasNext()) {
                    ImmutablePoint end = iter.next();
                    if (GeoUtil.isBetween(foot, start.getCoordinate(), end.getCoordinate(), 0.0) && !GeoUtil.areSamedPoints(foot, start.getCoordinate(), (Double)0.0) && !GeoUtil.areSamedPoints(foot, end.getCoordinate(), (Double)0.0)) {
                        newLinePoints.add((ImmutablePoint)point.getTransformed(GeoDecimal100Factory.INSTANCE));
                    }
                    newLinePoints.add((ImmutablePoint)end.getTransformed(GeoDecimal100Factory.INSTANCE));
                    start = end;
                }
                lineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(newLinePoints);
            }
            catch (Exception exception) {}
        }
        return lineString;
    }

    public static double calculateMatching(Coordinate c1, Coordinate c2) {
        Coordinate newC1 = Wgs84Factory.INSTANCE.createCoordinate(c1);
        Coordinate newC2 = Wgs84Factory.INSTANCE.createCoordinate(c2);
        double dx = Math.abs(newC1.getX() - newC2.getX());
        double dy = Math.abs(newC1.getY() - newC2.getY());
        return 100L - Math.round((dx / 18.0 + dy / 18.0) * 100.0);
    }

    public static double getDistanceInMeter(ImmutableLineString lineString, ImmutableLineString nLineString) {
        if (lineString.touches(nLineString) || lineString.crosses(nLineString)) {
            return 0.0;
        }
        double minDist = Double.MAX_VALUE;
        Iterator<ImmutablePoint> iter = lineString.getCoordinates().iterator();
        ImmutablePoint pred = iter.next();
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            ImmutableLineString subLineString = (ImmutableLineString)GeoUtil.createLineString(pred, succ);
            for (ImmutablePoint point : nLineString.getCoordinates()) {
                double dist = GeoUtil.getDistanceInMeter(subLineString, point);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
            pred = succ;
        }
        return minDist;
    }

    public static ImmutableEnvelope enlargeEnvelope(ImmutableEnvelope envelope, double dist) {
        CoordinateFactory coordinateFactory = envelope.getCoordinateFactory();
        double leftX = envelope.getMinX();
        double topY = envelope.getMaxY();
        double rightX = envelope.getMaxX();
        double bottomY = envelope.getMinY();
        double oX = leftX - 1.0;
        double nDist = GeoUtil.getDistanceInMeter(coordinateFactory.createCoordinate(leftX, topY), coordinateFactory.createCoordinate(oX, topY));
        double gap = 1.0 / nDist * dist;
        double newLeftX = leftX - gap;
        double oY = topY + 1.0;
        nDist = GeoUtil.getDistanceInMeter(coordinateFactory.createCoordinate(leftX, topY), coordinateFactory.createCoordinate(leftX, oY));
        gap = 1.0 / nDist * dist;
        double newTopY = topY + gap;
        oX = rightX + 1.0;
        nDist = GeoUtil.getDistanceInMeter(coordinateFactory.createCoordinate(rightX, bottomY), coordinateFactory.createCoordinate(oX, bottomY));
        gap = 1.0 / nDist * dist;
        double newRightX = rightX + gap;
        oY = bottomY - 1.0;
        nDist = GeoUtil.getDistanceInMeter(coordinateFactory.createCoordinate(rightX, bottomY), coordinateFactory.createCoordinate(rightX, oY));
        gap = 1.0 / nDist * dist;
        double newBottomY = bottomY - gap;
        return new ImmutableEnvelope(coordinateFactory.createCoordinate(newLeftX, newTopY), coordinateFactory.createCoordinate(newRightX, newBottomY));
    }
}

