/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import de.datomino.peppergis.dto.lucene.SearchType;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.StringUtil;

public class FormUtil {
    public static String TIMEFORMAT = "dd.MM.yyyy HH:mm";
    public static String DATEFORMAT = "dd.MM.yyyy";
    public static String CLOCKFORMAT = "HH:mm";
    public static String CLOCKSECONDFORMAT = "HH:mm:ss";
    public static String MONTHFORMAT = "MM.yyyy";
    public static final String DELIMITEROFDATE = " - ";
    public static final Dimension SIZEOFCALENDAR = new Dimension(250, 300);
    public static final Dimension SIZEOFPLANTABLE = new Dimension(1200, 600);
    public static final Dimension SIZEOFLISTANDTREE = new Dimension(200, 100);

    public static String timeToString(Date date) {
        if (date == null) {
            return "keine";
        }
        String timeFormat = "HH:mm:ss";
        return new SimpleDateFormat(timeFormat).format(date);
    }

    public static String secToMin(Integer sec) {
        if (sec == null) {
            return "";
        }
        return FormUtil.secToMin((double)sec);
    }

    public static String secToMin(Double sec) {
        if (sec == null) {
            return "";
        }
        double minute = FormUtil.roundWithDecimal(sec / 60.0, 2);
        DecimalFormat decimalFormat = new DecimalFormat("##0.00", new DecimalFormatSymbols(Locale.GERMANY));
        return decimalFormat.format(minute);
    }

    public static String dateToString(Date date, String format, String nullString) {
        if (date == null) {
            return nullString;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String getStringDisplay(String string) {
        if (string == null) {
            return "";
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return string;
    }

    public static String getStringDisplay(String string, String delim) {
        return string == null ? "" : FormUtil.getStringDisplay(string) + delim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInteger(String string, boolean canMinus) {
        if (canMinus && string.substring(0, 1).equals("-")) {
            string = string.substring(1, string.length());
        }
        try (Scanner scanner = new Scanner(string);){
            while (scanner.hasNext()) {
                scanner.nextInt();
            }
        }
        return true;
    }

    public static int getMaxWordCount(Collection<String> strings) {
        int max = 0;
        for (String string : strings) {
            max = Math.max(max, string == null ? 0 : string.length());
        }
        return max;
    }

    public static String getSubString(Object object, int endIndex) {
        String string = String.valueOf(object);
        if (string.length() > endIndex + 1) {
            string = string.substring(0, endIndex);
            return string;
        }
        return string;
    }

    public static String getStringWithLength(String s, int length) {
        if ((s = s == null ? "" : s.trim()).length() > length && length > 2) {
            s = s.substring(0, length - 2) + ". ";
        } else if (s.length() < length) {
            int lengthForAppend = length - s.length();
            for (int i = 0; i < lengthForAppend; ++i) {
                s = s + " ";
            }
        }
        return s;
    }

    public static String getSecondTimeString(Double duration) {
        if (duration == null) {
            return "00:00:00";
        }
        duration = Math.round(duration);
        int hours = (int)(duration / 60.0 / 60.0);
        int minutes = (int)((duration - (double)(hours * 3600)) / 60.0);
        double second = duration - (double)(hours * 3600) - (double)(minutes * 60);
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad(String.valueOf(hours), 2, '0'));
        sb.append(":").append(StringUtils.leftPad(String.valueOf(minutes), 2, '0'));
        sb.append(":").append(StringUtils.leftPad(String.valueOf((int)Math.round(second)), 2, '0'));
        return sb.toString();
    }

    public static String getSecondTimeString(Integer duration) {
        return FormUtil.getSecondTimeString(duration == null ? null : Double.valueOf(duration.doubleValue()));
    }

    public static double roundWithDecimal(double d, int decimal) {
        long i = Math.round(d * Math.pow(10.0, decimal));
        return (double)i / Math.pow(10.0, decimal);
    }

    public static Date stringToDate(String string) {
        try {
            return new SimpleDateFormat(TIMEFORMAT).parse(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getAddressStringForLegend(String street, String housenumber, String extension) {
        return FormUtil.getAddressString(null, null, street, housenumber, extension);
    }

    public static String getAddressStringForLegend(String street, Integer housenumber, String extension) {
        return FormUtil.getAddressString(null, null, street, housenumber == null ? null : String.valueOf(housenumber), extension);
    }

    public static String getCityString(String city, String postcode) {
        return FormUtil.getStringDisplay(postcode) + " " + FormUtil.getStringDisplay(city);
    }

    public static String getAddressString(String city, String postcode, String street, String housenumber, String extension) {
        String address = street == null ? "" : FormUtil.getStringDisplay(street);
        address = address + " " + FormUtil.getStringDisplay(housenumber);
        address = address + (extension == null || extension.isEmpty() ? "" : "/" + FormUtil.getStringDisplay(extension));
        address = address + (city == null || city.isEmpty() ? "" : ", " + FormUtil.getCityString(city, postcode));
        address = address.replaceAll("//", "/");
        return address;
    }

    public static String getAddressString(String city, String postcode, String street, Integer housenumber, String extension) {
        return FormUtil.getAddressString(city, postcode, street, housenumber == null ? null : String.valueOf(housenumber), extension);
    }

    public static String numberToString(Double d, int decimal) {
        return FormUtil.numberToString(d, decimal, Locale.GERMANY);
    }

    public static String numberToString(Double d, int decimal, Locale locale) {
        if (d == null) {
            return "0";
        }
        double round = FormUtil.roundWithDecimal(d, decimal);
        String pattern = decimal < 1 ? "0" : "0.";
        for (int i = 0; i < decimal; ++i) {
            pattern = pattern + "0";
        }
        DecimalFormat df = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        return df.format(round);
    }

    public static String numberToString(Integer i, int decimal) {
        return FormUtil.numberToString(i == null ? null : Double.valueOf(i.doubleValue()), decimal);
    }

    public static boolean matchs(String s, String pattern, SearchType searchType) {
        if (StringUtil.isBlank(s)) {
            return false;
        }
        if (StringUtil.isBlank(pattern)) {
            return true;
        }
        switch (searchType) {
            case EXACT: {
                break;
            }
            case MATCH_START: {
                pattern = pattern + "*";
                break;
            }
            case FUZZY: 
            case WILD_CARD: {
                pattern = "*" + pattern + "*";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                sb.append("\\").append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        Pattern p = Pattern.compile(sb.toString());
        return p.matcher(s.toLowerCase()).matches();
    }
}

