/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.dto.TourPartType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.time.TimeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.util.datatypes.Tree;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogisticTourUtil
extends LogisticServicesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogisticTourUtil.class);
    protected static CoordinateFactory factory = GeoDecimal100Factory.INSTANCE;
    public static double LOCATION_TOLERANCE = 5.0;

    public static LogisticTourDto<PointEntityId> createLogisticTourDto(List<PointEntity> points, RoutingType routingType, RouteVehicleType routeVehicleType, RouteType routeType, int startBlock, int endBlock) {
        LogisticTourDto<PointEntityId> logisticTourDto = new LogisticTourDto<PointEntityId>(1L);
        logisticTourDto.setStartTime(new Date());
        LogisticTourPartDto logisticTourPartDto = new LogisticTourPartDto(1L);
        logisticTourPartDto.setRouteType(routeType);
        logisticTourPartDto.setRouteVehicleType(routeVehicleType);
        List stopDtos = logisticTourPartDto.getStopDtos();
        for (PointEntity point : points) {
            ImmutablePoint geom = point.getGeom();
            ImmutablePoint accessGeom = point.getAccessGeom();
            if (accessGeom == null) {
                throw new NullPointerException("a null point");
            }
            LogisticLocationDto<PointEntityId> logisticLocationDto = new LogisticLocationDto<PointEntityId>(point.getId());
            logisticLocationDto.setTempId(String.valueOf(point.getId()));
            logisticLocationDto.setGeom(ImmutablePointDto.create((ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(geom.getCoordinate()).getTransformed(factory)));
            logisticLocationDto.setAccesGeom(ImmutablePointDto.create((ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(accessGeom.getCoordinate()).getTransformed(factory)));
            ImmutablePoint otherAccessGeom = point.getOtherAccessGeom();
            ImmutablePoint otherTransformed = otherAccessGeom == null ? null : (ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(otherAccessGeom.getCoordinate()).getTransformed(factory);
            logisticLocationDto.setOtherAccessGeom(ImmutablePointDto.create(otherTransformed));
            logisticLocationDto.setStreet(point.getStreet());
            logisticLocationDto.setHousenumber(point.getHousenumber());
            logisticLocationDto.setExtension(point.getExtension());
            logisticLocationDto.setPostcode(point.getPostcode());
            logisticLocationDto.setCity(point.getCity());
            logisticLocationDto.setDistrict(point.getDistrict());
            logisticLocationDto.setRouteSegmentId(point.getRouteSegmentId());
            logisticLocationDto.setOtherRouteSegmentId(point.getOtherRouteSegmentId());
            logisticLocationDto.setParcelLocation(point.getParcelLocation());
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.add(2, -1);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.add(2, 1);
            LogisticStopDto<PointEntityId> logisticStopDto = new LogisticStopDto<PointEntityId>(point.getId(), logisticLocationDto);
            LogisticTimeWindowDto timeWindowDto = new LogisticTimeWindowDto(startCalendar.getTime(), endCalendar.getTime());
            logisticStopDto.setTimeWindows(Arrays.asList(timeWindowDto));
            logisticStopDto.setStopType(point.getStopType());
            stopDtos.add(logisticStopDto);
        }
        if (routingType != null && routingType.isStartFix() && !stopDtos.isEmpty()) {
            if (!stopDtos.get(0).getStopType().isPoi()) {
                stopDtos.get(0).setStopType(StopType.FIX_START);
            }
            stopDtos.get(0).getLocation().setRouteSegmentId(null);
        }
        if (routingType != null && routingType.isEndFix() && !stopDtos.isEmpty()) {
            if (!stopDtos.get(stopDtos.size() - 1).getStopType().isPoi()) {
                stopDtos.get(stopDtos.size() - 1).setStopType(StopType.FIX_END);
            }
            stopDtos.get(stopDtos.size() - 1).getLocation().setRouteSegmentId(null);
        }
        logisticTourPartDto.setRoutingType(routingType);
        logisticTourPartDto.setSizeOfStartBlock(startBlock);
        logisticTourPartDto.setSizeOfEndBlock(endBlock);
        logisticTourDto.getTourParts().add(logisticTourPartDto);
        return logisticTourDto;
    }

    public static boolean needCalc(LogisticTourDto<?> logisticTourDto) {
        return true;
    }

    public static boolean containsAll(List<PointEntity> points1, List<PointEntity> points2) {
        return DefaultLogisticTourUtil.containsAll(points1, points2, false);
    }

    public static boolean containsAll(List<PointEntity> points1, List<PointEntity> points2, boolean exact) {
        if (points1.size() != points2.size()) {
            return false;
        }
        ArrayList<PointEntity> clone1 = new ArrayList<PointEntity>(points1);
        ArrayList<PointEntity> clone2 = new ArrayList<PointEntity>(points2);
        if (!exact) {
            Comparator<PointEntity> c = new Comparator<PointEntity>(){

                @Override
                public int compare(PointEntity o1, PointEntity o2) {
                    return o1.getId().getId().compareTo(o2.getId().getId());
                }
            };
            Collections.sort(clone1, c);
            Collections.sort(clone2, c);
        }
        ArrayList list1 = new ArrayList(clone1.size());
        ArrayList list2 = new ArrayList(clone2.size());
        Transformer<PointEntity, ImmutablePoint> transformer = new Transformer<PointEntity, ImmutablePoint>(){

            @Override
            public ImmutablePoint transform(PointEntity t) {
                return (ImmutablePoint)t.getAccessGeom().getTransformed(GeoDecimal100Factory.INSTANCE);
            }
        };
        CollectionUtil.transform(clone1, list1, transformer);
        CollectionUtil.transform(clone2, list2, transformer);
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i) == null || list2.get(i) == null) {
                return false;
            }
            if (((PointEntity)clone1.get(i)).getId().getId() == ((PointEntity)clone2.get(i)).getId().getId() && GeoUtil.areSamedPoints((ImmutablePoint)list1.get(i), (ImmutablePoint)list2.get(i), (Double)1.0)) continue;
            return false;
        }
        return true;
    }

    public static Double getSpeed(RouteVehicleType routeVehicleType) {
        Double speed = null;
        switch (routeVehicleType) {
            case BIKE: {
                speed = 2.0833333333333335;
                break;
            }
            case FOOT: {
                speed = 1.3888888888888888;
                break;
            }
            case MOTORCAR: {
                speed = 13.88888888888889;
            }
        }
        return speed;
    }

    public static SegmentType[] getAllowedSegmentTypes(RouteVehicleType routeVehicleType) {
        ArrayList<SegmentType> segmentTypes = CollectionUtil.buildArrayList(SegmentType.STREET);
        switch (routeVehicleType) {
            case MOTORCAR: {
                segmentTypes.add(SegmentType.MOTORWAY);
                segmentTypes.add(SegmentType.MOTOR_BIKE);
                segmentTypes.add(SegmentType.MOTOR_FOOT);
                break;
            }
            case BIKE: {
                segmentTypes.add(SegmentType.BIKEWAY);
                segmentTypes.add(SegmentType.MOTOR_BIKE);
                segmentTypes.add(SegmentType.FOOT_BIKE);
                break;
            }
            case FOOT: {
                segmentTypes.add(SegmentType.FOOTWAY);
                segmentTypes.add(SegmentType.FOOT_BIKE);
                segmentTypes.add(SegmentType.MOTOR_FOOT);
            }
        }
        SegmentType[] segmentTypesArray = new SegmentType[segmentTypes.size()];
        segmentTypes.toArray(segmentTypesArray);
        return segmentTypesArray;
    }

    public static SegmentStatus[] getBadSegmentStatuses(RouteVehicleType routeVehicleType) {
        ArrayList<SegmentStatus> segmentStatues = CollectionUtil.buildArrayList(SegmentStatus.BAD_FOR_ALL);
        switch (routeVehicleType) {
            case MOTORCAR: {
                segmentStatues.add(SegmentStatus.BAD_FOR_MOTOR);
                segmentStatues.add(SegmentStatus.BAD_FOR_MOTOR_FOOT);
                segmentStatues.add(SegmentStatus.BAD_FOR_MOTOR_BIKE);
                break;
            }
            case BIKE: {
                segmentStatues.add(SegmentStatus.BAD_FOR_BIKE);
                segmentStatues.add(SegmentStatus.BAD_FOR_MOTOR_BIKE);
                segmentStatues.add(SegmentStatus.BAD_FOR_FOOT_BIKE);
                break;
            }
            case FOOT: {
                segmentStatues.add(SegmentStatus.BAD_FOR_FOOT);
                segmentStatues.add(SegmentStatus.BAD_FOR_MOTOR_FOOT);
                segmentStatues.add(SegmentStatus.BAD_FOR_FOOT_BIKE);
            }
        }
        SegmentStatus[] segmentStatuesArray = new SegmentStatus[segmentStatues.size()];
        segmentStatues.toArray(segmentStatuesArray);
        return segmentStatuesArray;
    }

    public static LogisticTourDto<PointEntityId> createLogisticTourDtoWith5Parts(List<PointEntity> points, AreaTourParameter parameter) {
        int i;
        LogisticTourDto<PointEntityId> logisticTourDto = new LogisticTourDto<PointEntityId>(1L);
        logisticTourDto.setStartTime(new Date());
        LogisticTourPartDto startPoiPart = new LogisticTourPartDto(1L);
        startPoiPart.setRouteType(parameter.getRouteTypeFromPoi());
        startPoiPart.setRouteVehicleType(parameter.getRouteVehicleTypeFromPoi());
        startPoiPart.setRoutingType(OptimizationType.ALLFIX);
        startPoiPart.setTourPartType(TourPartType.LINK_NEXT);
        logisticTourDto.getTourParts().add(startPoiPart);
        LogisticTourPartDto startPickPointPart = new LogisticTourPartDto(2L);
        startPickPointPart.setRouteType(parameter.getRouteTypeFromPickPoint());
        startPickPointPart.setRouteVehicleType(parameter.getRouteVehicleTypeFromPickPoint());
        startPickPointPart.setRoutingType(OptimizationType.ALLFIX);
        startPickPointPart.setTourPartType(TourPartType.LINK_NEXT);
        logisticTourDto.getTourParts().add(startPickPointPart);
        LogisticTourPartDto areaPart = new LogisticTourPartDto(3L);
        areaPart.setRouteType(parameter.getRouteTypeInArea());
        areaPart.setRouteVehicleType(parameter.getRouteVehicleTypeInArea());
        OptimizationType areaRoutingType = OptimizationType.createOptimizationType(false, parameter.getSizeOfStartBlock() > 0, parameter.getSizeOfEndBlock() > 0);
        areaPart.setRoutingType(areaRoutingType);
        areaPart.setTourPartType(TourPartType.NO_LINK);
        areaPart.setSizeOfStartBlock(parameter.getSizeOfStartBlock());
        areaPart.setSizeOfEndBlock(parameter.getSizeOfEndBlock());
        logisticTourDto.getTourParts().add(areaPart);
        LogisticTourPartDto endPickPointPart = new LogisticTourPartDto(4L);
        endPickPointPart.setRouteType(parameter.getRouteTypeFromPickPoint());
        endPickPointPart.setRouteVehicleType(parameter.getRouteVehicleTypeFromPickPoint());
        endPickPointPart.setRoutingType(OptimizationType.ALLFIX);
        endPickPointPart.setTourPartType(TourPartType.LINK_PRED);
        logisticTourDto.getTourParts().add(endPickPointPart);
        LogisticTourPartDto endPoiPart = new LogisticTourPartDto(5L);
        endPoiPart.setRouteType(parameter.getRouteTypeFromPoi());
        endPoiPart.setRouteVehicleType(parameter.getRouteVehicleTypeFromPoi());
        endPoiPart.setRoutingType(OptimizationType.ALLFIX);
        endPoiPart.setTourPartType(TourPartType.LINK_PRED);
        logisticTourDto.getTourParts().add(endPoiPart);
        for (PointEntity point : points) {
            ImmutablePoint geom = point.getGeom();
            ImmutablePoint accessGeom = point.getAccessGeom();
            if (accessGeom == null) {
                throw new NullPointerException("a null point");
            }
            LogisticLocationDto<PointEntityId> logisticLocationDto = new LogisticLocationDto<PointEntityId>(point.getId());
            logisticLocationDto.setTempId(String.valueOf(point.getId()));
            logisticLocationDto.setGeom(ImmutablePointDto.create((ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(geom.getCoordinate()).getTransformed(factory)));
            logisticLocationDto.setAccesGeom(ImmutablePointDto.create((ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(accessGeom.getCoordinate()).getTransformed(factory)));
            ImmutablePoint otherAccessGeom = point.getOtherAccessGeom();
            ImmutablePoint otherTransformed = otherAccessGeom == null ? null : (ImmutablePoint)ImmutableGeoObjectFactory.createImmutablePoint(otherAccessGeom.getCoordinate()).getTransformed(factory);
            logisticLocationDto.setOtherAccessGeom(ImmutablePointDto.create(otherTransformed));
            logisticLocationDto.setStreet(point.getStreet());
            logisticLocationDto.setHousenumber(point.getHousenumber());
            logisticLocationDto.setExtension(point.getExtension());
            logisticLocationDto.setPostcode(point.getPostcode());
            logisticLocationDto.setCity(point.getCity());
            logisticLocationDto.setDistrict(point.getDistrict());
            logisticLocationDto.setRouteSegmentId(point.getRouteSegmentId());
            logisticLocationDto.setOtherRouteSegmentId(point.getOtherRouteSegmentId());
            logisticLocationDto.setParcelLocation(point.getParcelLocation());
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.add(2, -1);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.add(2, 1);
            LogisticStopDto<PointEntityId> logisticStopDto = new LogisticStopDto<PointEntityId>(point.getId(), logisticLocationDto);
            LogisticTimeWindowDto timeWindowDto = new LogisticTimeWindowDto(startCalendar.getTime(), endCalendar.getTime());
            logisticStopDto.setTimeWindows(Arrays.asList(timeWindowDto));
            logisticStopDto.setStopType(point.getStopType());
            switch (logisticStopDto.getStopType()) {
                case NORMAL: {
                    areaPart.getStopDtos().add(logisticStopDto);
                    break;
                }
                case PICK_POINT_END: {
                    endPickPointPart.getStopDtos().add(logisticStopDto);
                    logisticStopDto.setOtherRouteVehicleType(endPickPointPart.getRouteVehicleType());
                    logisticStopDto.setOtherRouteType(endPickPointPart.getRouteType());
                    break;
                }
                case PICK_POINT_START: {
                    startPickPointPart.getStopDtos().add(logisticStopDto);
                    logisticStopDto.setOtherRouteVehicleType(startPickPointPart.getRouteVehicleType());
                    logisticStopDto.setOtherRouteType(startPickPointPart.getRouteType());
                    break;
                }
                case POI_END: {
                    endPoiPart.getStopDtos().add(logisticStopDto);
                    logisticStopDto.setOtherRouteVehicleType(endPoiPart.getRouteVehicleType());
                    logisticStopDto.setOtherRouteType(endPoiPart.getRouteType());
                    break;
                }
                case POI_START: {
                    startPoiPart.getStopDtos().add(logisticStopDto);
                    logisticStopDto.setOtherRouteVehicleType(startPoiPart.getRouteVehicleType());
                    logisticStopDto.setOtherRouteType(startPoiPart.getRouteType());
                    break;
                }
            }
        }
        List areaStops = areaPart.getStopDtos();
        for (i = 0; i < parameter.getSizeOfStartBlock(); ++i) {
            areaStops.get(i).setStopType(StopType.FIX_START);
            areaStops.get(i).getLocation().setRouteSegmentId(null);
        }
        for (i = areaStops.size() - 1; i > areaStops.size() - 1 - parameter.getSizeOfEndBlock(); --i) {
            areaStops.get(i).setStopType(StopType.FIX_END);
            areaStops.get(i).getLocation().setRouteSegmentId(null);
        }
        return logisticTourDto;
    }

    public static String getAddress(LogisticLocationDto<?> location) {
        return FormUtil.getAddressString(location.getCity(), location.getPostcode(), location.getStreet(), location.getHousenumber(), location.getExtension());
    }

    public static List<List<LogisticStopDto<PointEntityId>>> getOptimizedAccessLists(List<LogisticStopDto<PointEntityId>> stops, Map<LogisticStopDto<PointEntityId>, ImmutableLineString> segmentMap) {
        ArrayList<List<LogisticStopDto<PointEntityId>>> lists = new ArrayList<List<LogisticStopDto<PointEntityId>>>();
        if (stops.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArrayList<LogisticStopDto>> starts = new ArrayList<ArrayList<LogisticStopDto>>();
        ArrayList<ArrayList<LogisticStopDto>> ends = new ArrayList<ArrayList<LogisticStopDto>>();
        for (LogisticStopDto<PointEntityId> stop : stops) {
            if (stop.getStopType() != null && stop.getStopType().isStartFix()) {
                starts.add(CollectionUtil.buildArrayList(stop));
                continue;
            }
            if (stop.getStopType() != null && stop.getStopType().isEndFix()) {
                ends.add(CollectionUtil.buildArrayList(stop));
                continue;
            }
            Long l = stop.getLocation().getRouteSegmentId();
            if (l == null) {
                lists.add(CollectionUtil.buildArrayList(stop));
                continue;
            }
            List found = null;
            block1: for (List list : lists) {
                for (LogisticStopDto l2 : list) {
                    if (!DefaultLogisticTourUtil.areSameAccess(stop, l2, segmentMap.get(stop))) continue;
                    found = list;
                    break block1;
                }
            }
            if (found == null) {
                lists.add(CollectionUtil.buildArrayList(stop));
                continue;
            }
            found.add(stop);
        }
        final ImmutablePoint predPoint = (ImmutablePoint)stops.get(0).getLocation().getAccessGeom().getGeoObject();
        for (List list : lists) {
            LogisticStopDto nestest = null;
            double min = Double.MAX_VALUE;
            for (LogisticStopDto l2 : list) {
                LogisticLocationDto location = l2.getLocation();
                ImmutablePoint access = (ImmutablePoint)location.getAccessGeom().getGeoObject();
                ImmutablePoint geom = (ImmutablePoint)location.getGeom().getGeoObject();
                double d = GeoUtils.getDistanceInMeter(access, geom);
                if (predPoint != null) {
                    d += GeoUtils.getDistanceInMeter(access, predPoint);
                }
                if (!(min > d) && nestest != null) continue;
                nestest = l2;
                min = d;
            }
            list.remove(nestest);
            list.add(0, nestest);
        }
        Collections.sort(lists, new Comparator<List<LogisticStopDto<PointEntityId>>>(){

            @Override
            public int compare(List<LogisticStopDto<PointEntityId>> l1, List<LogisticStopDto<PointEntityId>> l2) {
                double min1 = this.getAccessDistance(l1);
                double min2 = this.getAccessDistance(l2);
                return Double.compare(min1, min2);
            }

            private double getAccessDistance(List<LogisticStopDto<PointEntityId>> stop) {
                LogisticLocationDto<PointEntityId> location = stop.get(0).getLocation();
                ImmutablePoint access = (ImmutablePoint)location.getAccessGeom().getGeoObject();
                return GeoUtils.getDistanceInMeter(access, predPoint);
            }
        });
        for (List list : lists) {
            DefaultLogisticTourUtil.optimizeAccessList(list);
        }
        lists.addAll(0, starts);
        lists.addAll(ends);
        return lists;
    }

    public static List<LogisticStopDto<PointEntityId>> getOptimizedAccessList(List<LogisticStopDto<PointEntityId>> stops, Map<LogisticStopDto<PointEntityId>, ImmutableLineString> segmentMap) {
        List<List<LogisticStopDto<PointEntityId>>> lists = DefaultLogisticTourUtil.getOptimizedAccessLists(stops, segmentMap);
        ArrayList<LogisticStopDto<PointEntityId>> result = new ArrayList<LogisticStopDto<PointEntityId>>();
        for (List<LogisticStopDto<PointEntityId>> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public static void optimizeAccessList(List<LogisticStopDto<PointEntityId>> stops) {
        if (stops.isEmpty()) {
            return;
        }
        Tree<LogisticStopDto<PointEntityId>> accessTree = new Tree<LogisticStopDto<PointEntityId>>(stops.remove(0));
        Tree.Folder root = accessTree.getRoot();
        while (!stops.isEmpty()) {
            double min = Double.MAX_VALUE;
            LogisticStopDto<PointEntityId> found = null;
            Tree.Folder folder = null;
            Tupel<Object, Double> tupel = new Tupel<Object, Double>(null, (Double)Double.MAX_VALUE);
            for (LogisticStopDto<PointEntityId> s : stops) {
                DefaultLogisticTourUtil.findNestestLocation(s, root, tupel);
                if (!(min > tupel.getElement2())) continue;
                found = s;
                folder = tupel.getElement1();
                min = tupel.getElement2();
            }
            folder.createFolder(found);
            stops.remove(found);
        }
        DefaultLogisticTourUtil.loadAllNodes(root, stops);
    }

    private static void loadAllNodes(Tree.Folder folder, List<LogisticStopDto<PointEntityId>> list) {
        list.add((LogisticStopDto<PointEntityId>)folder.getValue());
        Iterator<Tree.Node> iter = folder.iterateNodes();
        while (iter.hasNext()) {
            DefaultLogisticTourUtil.loadAllNodes((Tree.Folder)iter.next(), list);
        }
    }

    private static void findNestestLocation(LogisticStopDto<PointEntityId> stop, Tree.Folder folder, Tupel<Tree.Folder, Double> tupel) {
        ImmutablePoint geom = (ImmutablePoint)stop.getLocation().getGeom().getGeoObject();
        ImmutablePoint folderGeom = (ImmutablePoint)((LogisticStopDto)folder.getValue()).getLocation().getGeom().getGeoObject();
        double d = GeoUtils.getDistanceInMeter(geom, folderGeom);
        if (tupel.getElement2() > d) {
            tupel.setElement1(folder);
            tupel.setElement2(d);
        }
        Iterator<Tree.Node> iter = folder.iterateNodes();
        while (iter.hasNext()) {
            DefaultLogisticTourUtil.findNestestLocation(stop, (Tree.Folder)iter.next(), tupel);
        }
    }

    private static <T extends Serializable> boolean areSameAccess(LogisticStopDto<T> stop1, LogisticStopDto<T> stop2, ImmutableLineString lineString) {
        LogisticLocationDto<T> location1 = stop1.getLocation();
        LogisticLocationDto<T> location2 = stop2.getLocation();
        return DefaultLogisticTourUtil.areSameAccess(location1, location2, lineString);
    }

    public static <T extends Serializable> boolean areSameAccess(LogisticLocationDto<T> location1, LogisticLocationDto<T> location2, ImmutableLineString lineString) {
        ImmutablePoint geom1 = (ImmutablePoint)location1.getGeom().getGeoObject();
        ImmutablePoint access1 = (ImmutablePoint)location1.getAccessGeom().getGeoObject();
        ImmutablePoint geom2 = (ImmutablePoint)location2.getGeom().getGeoObject();
        ImmutablePoint access2 = (ImmutablePoint)location2.getAccessGeom().getGeoObject();
        boolean b = false;
        if (GeoUtil.areSamedPoints(geom1, geom2, (Double)0.0)) {
            b = true;
        } else if (GeoUtil.areSamedPoints(access1, access2, (Double)LOCATION_TOLERANCE)) {
            if (lineString == null) {
                try {
                    lineString = ImmutableGeoObjectFactory.createImmutableLineString(access1.getCoordinate(), access2.getCoordinate(), new Coordinate[0]);
                }
                catch (Exception e) {
                    ImmutableLineStringDto lineStringDto1 = location1.getLineString();
                    lineString = lineStringDto1 == null ? null : (ImmutableLineString)lineStringDto1.getGeoObject();
                }
            }
            boolean pointOnRight1 = GeoUtil.isPointOnRight(geom1, access1, lineString);
            boolean pointOnRight2 = GeoUtil.isPointOnRight(geom2, access2, lineString);
            double d0 = GeoUtil.getDistanceInMeter(geom1, geom2);
            double d1 = GeoUtil.getDistanceInMeter(geom1, access1);
            double d2 = GeoUtil.getDistanceInMeter(geom2, access2);
            if ((pointOnRight1 && pointOnRight2 || !pointOnRight1 && !pointOnRight2) && d0 <= Math.max(d1, d2)) {
                b = true;
            }
        }
        return b;
    }

    public static <T extends Serializable> void calculateAccessDistance(List<LogisticStopDto<T>> stops) {
        LogisticStopDto<T> pred = null;
        ArrayList<LogisticLocationDto<T>> sameAccess = new ArrayList<LogisticLocationDto<T>>();
        for (LogisticStopDto<T> stop : stops) {
            if (pred == null) {
                stop.setAccessDistanceFromPred(0.0);
                pred = stop;
                continue;
            }
            LogisticLocationDto predLocation = pred.getLocation();
            Coordinate accessPred = ((ImmutablePoint)predLocation.getAccessGeom().getGeoObject()).getCoordinate();
            Coordinate geomPred = ((ImmutablePoint)predLocation.getGeom().getGeoObject()).getCoordinate();
            LogisticLocationDto<T> succLocation = stop.getLocation();
            Coordinate accessSucc = ((ImmutablePoint)succLocation.getAccessGeom().getGeoObject()).getCoordinate();
            Coordinate geomSucc = ((ImmutablePoint)succLocation.getGeom().getGeoObject()).getCoordinate();
            double accessDistance = 0.0;
            if (DefaultLogisticTourUtil.areSameAccess(predLocation, succLocation, null)) {
                accessDistance = GeoUtils.getDistanceInMeter(geomSucc, geomPred);
                sameAccess.remove(predLocation);
                sameAccess.add(predLocation);
                sameAccess.add(succLocation);
            } else {
                if (!sameAccess.isEmpty()) {
                    accessPred = ((ImmutablePoint)((LogisticLocationDto)sameAccess.get(0)).getAccessGeom().getGeoObject()).getCoordinate();
                    geomPred = ((ImmutablePoint)((LogisticLocationDto)sameAccess.get(0)).getGeom().getGeoObject()).getCoordinate();
                    sameAccess.clear();
                }
                accessDistance = GeoUtils.getDistanceInMeter(accessPred, geomPred) + GeoUtils.getDistanceInMeter(accessSucc, geomSucc);
            }
            stop.setAccessDistanceFromPred(accessDistance);
            pred = stop;
        }
    }

    public static <T extends Serializable> boolean isBreakTimeWindow(LogisticTourDto<T> logisticTour) {
        boolean b = false;
        for (LogisticStopDto<T> stop : DefaultLogisticTourUtil.getAllStops(logisticTour)) {
            if (!DefaultLogisticTourUtil.isBreakTimeWindows(stop)) continue;
            b = true;
            break;
        }
        return b;
    }

    private static <T extends Serializable> boolean isBreakTimeWindows(LogisticStopDto<T> stop) {
        Date timeOfArrival = stop.getTimeOfArrival();
        if (timeOfArrival == null) {
            return false;
        }
        Integer duration = stop.getDurationInSecond() == null ? 0 : stop.getDurationInSecond();
        Date leaveTime = DateUtils.addSeconds(timeOfArrival, duration);
        return DefaultLogisticTourUtil.isBreakTimeWindows(stop.getTimeWindows(), timeOfArrival, leaveTime);
    }

    private static boolean isBreakTimeWindows(List<LogisticTimeWindowDto> timeWindows, Date arrivalTime, Date leaveTime) {
        if (timeWindows == null || timeWindows.isEmpty() || arrivalTime == null) {
            return false;
        }
        for (LogisticTimeWindowDto timeWindow : timeWindows) {
            if (timeWindow == null || !TimeUtil.isBetween(arrivalTime, timeWindow.getStartTime(), timeWindow.getEndTime())) continue;
            return false;
        }
        return true;
    }
}

