/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.type.data;

import de.datomino.peppergis.type.DataManagerType;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.ktde.util.datatypes.Tupel;

public class FiltersBody<E extends Enum<E>> {
    private final E[] fieldEnumValues;
    private EnumMap<E, Tupel<JPanel, JCheckBox>> fieldMap;
    private EnumMap<E, Object> appliedDataMap;
    private EnumSet<E> fieldsToShowInResult;
    private EnumMap<E, EnumSet<DataManagerType>> fieldVisibleIn;
    private EnumMap<E, EnumSet<E>> headlines;
    private boolean changed;

    public FiltersBody(Class<E> type) {
        this.fieldMap = new EnumMap(type);
        this.appliedDataMap = new EnumMap(type);
        this.fieldEnumValues = (Enum[])type.getEnumConstants();
        this.fieldsToShowInResult = EnumSet.noneOf(type);
        this.fieldVisibleIn = new EnumMap(type);
        this.headlines = new EnumMap(type);
        this.clearChanged();
    }

    public E[] getAllFields() {
        return this.fieldEnumValues;
    }

    public Collection<E> getVisibleFields(DataManagerType type, boolean withHeadlines) {
        LinkedList<E> visibleFieldList = new LinkedList<E>();
        Object head = null;
        EnumSet<E> body = null;
        EnumMap<E, EnumSet<E>> heads = withHeadlines ? new EnumMap<E, EnumSet<E>>(this.headlines) : null;
        for (E e : this.fieldEnumValues) {
            EnumSet<DataManagerType> visible;
            boolean isVisible;
            if (withHeadlines && heads.get(e) != null) {
                head = e;
                body = EnumSet.copyOf(heads.get(e));
                heads.remove(e);
            }
            if (!(isVisible = (visible = (visible = this.fieldVisibleIn.get(e)) != null ? visible : EnumSet.noneOf(DataManagerType.class)).contains((Object)type))) continue;
            if (body != null && body.contains(e)) {
                body.clear();
                visibleFieldList.add(head);
            }
            visibleFieldList.add(e);
        }
        return visibleFieldList;
    }

    public EnumMap<E, Tupel<JPanel, JCheckBox>> getFieldMap() {
        return this.fieldMap;
    }

    public void put(E key, Object value) {
        if (value != null && (this.changed |= !this.appliedDataMap.containsKey(key) || !this.appliedDataMap.get(key).equals(value))) {
            this.appliedDataMap.put(key, value);
        }
    }

    public void remove(E key) {
        this.changed |= this.appliedDataMap.remove(key) != null;
    }

    public EnumMap<E, Object> getAppliedDataMap() {
        return this.appliedDataMap;
    }

    public EnumSet<E> getFieldsToShowInResult() {
        return this.fieldsToShowInResult;
    }

    public JPanel getFilterField(E field) {
        if (this.headlines.containsKey(field)) {
            throw new RuntimeException("Field must not be a headline!");
        }
        return this.fieldMap.get(field).getElement1();
    }

    public JCheckBox getCheckBox(E field) {
        if (this.headlines.containsKey(field)) {
            throw new RuntimeException("Field must not be a headline!");
        }
        return this.fieldMap.get(field).getElement2();
    }

    public Set<E> getAppliedDataKeys() {
        return this.appliedDataMap.keySet();
    }

    public EnumMap<E, EnumSet<DataManagerType>> getFieldVisibleIn() {
        return this.fieldVisibleIn;
    }

    public EnumMap<E, EnumSet<E>> getHeadlines() {
        return this.headlines;
    }

    public void clear() {
        this.appliedDataMap.clear();
    }

    public void clear(EnumSet<E> fieldsToShowInResult, DataManagerType type) {
        this.clear();
        this.fieldsToShowInResult.clear();
        if (fieldsToShowInResult != null) {
            for (Enum e : fieldsToShowInResult) {
                if (!this.fieldVisibleIn.get(e).contains((Object)type)) continue;
                this.fieldsToShowInResult.add(e);
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }
}

