/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.type.areatourtype;

public enum AreaObjectType {
    PARCEL,
    SUBSCRIPTION,
    PARCEL_WITHOUT_SUBSCRIPTION,
    LETTER,
    PARCEL_WITH_LETTER,
    SUBSCRIPTION_WITH_LETTER,
    PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER,
    PARCEL_SUBSCRIPTION,
    PARCEL_SUBSCRIPTION_LETTER;


    public boolean isForSubscription() {
        switch (this) {
            case SUBSCRIPTION: 
            case SUBSCRIPTION_WITH_LETTER: 
            case PARCEL_SUBSCRIPTION: 
            case PARCEL_SUBSCRIPTION_LETTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isForParcel() {
        switch (this) {
            case PARCEL_SUBSCRIPTION: 
            case PARCEL_SUBSCRIPTION_LETTER: 
            case PARCEL: 
            case PARCEL_WITHOUT_SUBSCRIPTION: 
            case PARCEL_WITH_LETTER: 
            case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isForLetter() {
        switch (this) {
            case SUBSCRIPTION_WITH_LETTER: 
            case PARCEL_SUBSCRIPTION_LETTER: 
            case PARCEL_WITH_LETTER: 
            case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: 
            case LETTER: {
                return true;
            }
        }
        return false;
    }

    public AreaObjectType addNewType(AreaObjectType newType) {
        AreaObjectType type = this;
        if (newType.isForParcel()) {
            switch (this) {
                case SUBSCRIPTION: {
                    type = PARCEL_SUBSCRIPTION;
                    break;
                }
                case SUBSCRIPTION_WITH_LETTER: {
                    type = PARCEL_SUBSCRIPTION_LETTER;
                    break;
                }
                case LETTER: {
                    type = PARCEL_WITH_LETTER;
                    break;
                }
            }
        }
        if (newType.isForSubscription()) {
            switch (this) {
                case PARCEL: 
                case PARCEL_WITHOUT_SUBSCRIPTION: {
                    type = PARCEL_SUBSCRIPTION;
                    break;
                }
                case PARCEL_WITH_LETTER: 
                case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                    type = PARCEL_SUBSCRIPTION_LETTER;
                    break;
                }
                case LETTER: {
                    type = SUBSCRIPTION_WITH_LETTER;
                    break;
                }
            }
        }
        if (newType.isForLetter()) {
            switch (this) {
                case PARCEL: {
                    type = PARCEL_WITH_LETTER;
                    break;
                }
                case PARCEL_WITHOUT_SUBSCRIPTION: {
                    type = PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER;
                    break;
                }
                case PARCEL_SUBSCRIPTION: {
                    type = PARCEL_SUBSCRIPTION_LETTER;
                    break;
                }
                case SUBSCRIPTION: {
                    type = SUBSCRIPTION_WITH_LETTER;
                    break;
                }
            }
        }
        return type;
    }
}

