/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.type;

import de.datomino.osm.OsmUtil;
import java.util.Map;

public enum SegmentType {
    MOTORWAY(100),
    STREET(111),
    FOOTWAY(10),
    BIKEWAY(1),
    MOTOR_FOOT(110),
    MOTOR_BIKE(101),
    FOOT_BIKE(11),
    DUMMY(0);

    private int factor;

    private SegmentType(int factor) {
        this.factor = factor;
    }

    public static SegmentType[] getValidTypes() {
        return new SegmentType[]{MOTORWAY, STREET, FOOTWAY, BIKEWAY, MOTOR_FOOT, MOTOR_BIKE, FOOT_BIKE};
    }

    public static SegmentType getSegmentType(boolean motorsAllowed, boolean footsAllowed, boolean bikesAllowed) {
        int factor = (motorsAllowed ? 100 : 0) + (footsAllowed ? 10 : 0) + (bikesAllowed ? 1 : 0);
        return SegmentType.getSegmentType(factor);
    }

    public static SegmentType getSegmentType(String osmType) {
        int motorsAllowed = 0;
        if (OsmUtil.MOTORWAYS.contains(osmType)) {
            motorsAllowed = 100;
        }
        int footsAllowed = 0;
        if (OsmUtil.FOOTWAYS.contains(osmType)) {
            footsAllowed = 10;
        }
        int bikesAllowed = 0;
        if (OsmUtil.BIKEWAYS.contains(osmType)) {
            bikesAllowed = 1;
        }
        return SegmentType.getSegmentType(motorsAllowed + footsAllowed + bikesAllowed);
    }

    public SegmentType updateSegmentType(Map<String, String> segmentAttributeMap) {
        SegmentType type;
        SegmentType newType = this;
        int motorsAllowed = 100;
        if (!OsmUtil.hasTag(OsmUtil.MOTOR_RESTRICTIONS, OsmUtil.MOTOR_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.MOTOR_RESTRICTIONS, OsmUtil.MOTOR_RESTRICTED_VALUES, segmentAttributeMap)) {
            motorsAllowed = -100;
        }
        if ((type = SegmentType.getSegmentType(newType.factor + motorsAllowed)) != null) {
            newType = type;
        }
        int footsAllowed = 10;
        if (!OsmUtil.hasTag(OsmUtil.FOOT_RESTRICTIONS, OsmUtil.FOOT_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.FOOT_RESTRICTIONS, OsmUtil.FOOT_RESTRICTED_VALUES, segmentAttributeMap)) {
            footsAllowed = -10;
        }
        if ((type = SegmentType.getSegmentType(newType.factor + footsAllowed)) != null) {
            newType = type;
        }
        int bikesAllowed = 1;
        if (!OsmUtil.hasTag(OsmUtil.BIKE_RESTRICTIONS, OsmUtil.BIKE_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.BIKE_RESTRICTIONS, OsmUtil.BIKE_RESTRICTED_VALUES, segmentAttributeMap)) {
            bikesAllowed = -1;
        }
        if ((type = SegmentType.getSegmentType(newType.factor + bikesAllowed)) != null) {
            newType = type;
        }
        return newType;
    }

    private static SegmentType getSegmentType(int factor) {
        switch (factor) {
            case 100: {
                return MOTORWAY;
            }
            case 111: {
                return STREET;
            }
            case 10: {
                return FOOTWAY;
            }
            case 1: {
                return BIKEWAY;
            }
            case 110: {
                return MOTOR_FOOT;
            }
            case 101: {
                return MOTOR_BIKE;
            }
            case 11: {
                return FOOT_BIKE;
            }
            case 0: {
                return DUMMY;
            }
        }
        return null;
    }

    public boolean isForMotor() {
        return this == MOTORWAY || this == MOTOR_FOOT || this == MOTOR_BIKE || this == STREET;
    }

    public boolean isForFoot() {
        return this == FOOTWAY || this == MOTOR_FOOT || this == FOOT_BIKE || this == STREET;
    }

    public boolean isForBike() {
        return this == BIKEWAY || this == MOTOR_BIKE || this == FOOT_BIKE || this == STREET;
    }

    public int compare(SegmentType o) {
        return this.factor - o.factor;
    }
}

