/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.type;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.osm.OsmUtil;
import java.util.Map;

public enum SegmentStatus {
    NORMAL(111),
    BAD_FOR_ALL(0),
    BAD_FOR_MOTOR(11),
    BAD_FOR_FOOT(101),
    BAD_FOR_BIKE(110),
    BAD_FOR_MOTOR_FOOT(1),
    BAD_FOR_MOTOR_BIKE(10),
    BAD_FOR_FOOT_BIKE(100);

    private int factor;

    private SegmentStatus(int factor) {
        this.factor = factor;
    }

    public int getFactor() {
        return this.factor;
    }

    public boolean isBad(RouteVehicleType vehicleType) {
        boolean b = false;
        if (vehicleType == null) {
            b = this.isBadForFoot() || this.isBadForMotor() || this.isBadForBike();
        } else {
            switch (vehicleType) {
                case BIKE: {
                    b = this.isBadForBike();
                    break;
                }
                case FOOT: {
                    b = this.isBadForFoot();
                    break;
                }
                case MOTORCAR: {
                    b = this.isBadForMotor();
                }
            }
        }
        return b;
    }

    public boolean isBadForMotor() {
        return this == BAD_FOR_ALL || this == BAD_FOR_MOTOR || this == BAD_FOR_MOTOR_BIKE || this == BAD_FOR_MOTOR_FOOT;
    }

    public boolean isBadForFoot() {
        return this == BAD_FOR_ALL || this == BAD_FOR_FOOT || this == BAD_FOR_FOOT_BIKE || this == BAD_FOR_MOTOR_FOOT;
    }

    public boolean isBadForBike() {
        return this == BAD_FOR_ALL || this == BAD_FOR_BIKE || this == BAD_FOR_FOOT_BIKE || this == BAD_FOR_MOTOR_BIKE;
    }

    public static SegmentStatus getNewStatus(SegmentStatus oldStatus, boolean normal, RouteVehicleType vehicleType) {
        if (oldStatus == null) {
            oldStatus = NORMAL;
        }
        int oldFactor = oldStatus.factor;
        int changed = normal ? 1 : -1;
        switch (vehicleType) {
            case BIKE: {
                changed *= 1;
                break;
            }
            case FOOT: {
                changed *= 10;
                break;
            }
            case MOTORCAR: {
                changed *= 100;
            }
        }
        SegmentStatus newStatus = SegmentStatus.getSegmentStatus(oldFactor + changed);
        return newStatus == null ? oldStatus : newStatus;
    }

    public static SegmentStatus getSegmentStatus(int factor) {
        switch (factor) {
            case 100: {
                return BAD_FOR_FOOT_BIKE;
            }
            case 111: {
                return NORMAL;
            }
            case 10: {
                return BAD_FOR_MOTOR_BIKE;
            }
            case 1: {
                return BAD_FOR_MOTOR_FOOT;
            }
            case 110: {
                return BAD_FOR_BIKE;
            }
            case 101: {
                return BAD_FOR_FOOT;
            }
            case 11: {
                return BAD_FOR_MOTOR;
            }
            case 0: {
                return BAD_FOR_ALL;
            }
        }
        return null;
    }

    public static SegmentStatus getSegmentStatus(Map<String, String> segmentAttributeMap) {
        int motorsAllowed = 100;
        if (!OsmUtil.hasTag(OsmUtil.MOTOR_RESTRICTIONS, OsmUtil.MOTOR_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.MOTOR_RESTRICTIONS, OsmUtil.MOTOR_RESTRICTED_VALUES, segmentAttributeMap)) {
            motorsAllowed = 0;
        }
        int footsAllowed = 10;
        if (!OsmUtil.hasTag(OsmUtil.FOOT_RESTRICTIONS, OsmUtil.FOOT_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.FOOT_RESTRICTIONS, OsmUtil.FOOT_RESTRICTED_VALUES, segmentAttributeMap)) {
            footsAllowed = 0;
        }
        int bikesAllowed = 1;
        if (!OsmUtil.hasTag(OsmUtil.BIKE_RESTRICTIONS, OsmUtil.BIKE_INTENDED_VALUES, segmentAttributeMap) && OsmUtil.hasTag(OsmUtil.BIKE_RESTRICTIONS, OsmUtil.BIKE_RESTRICTED_VALUES, segmentAttributeMap)) {
            bikesAllowed = 0;
        }
        return SegmentStatus.getSegmentStatus(motorsAllowed + footsAllowed + bikesAllowed);
    }
}

