/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.util;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.model.AbstractTimeObjectBucketModel;
import de.datomino.peppergis.client.manager.model.TimeExtractor;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.blocking.BusyHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class TourTimeBucketModel
extends AbstractTimeObjectBucketModel<TourModel, Integer> {
    private static final Integer KEY = 1;
    private ModelEnviroment modelEnviroment;

    public TourTimeBucketModel(ModelEnviroment modelEnviroment, BusyHandler busyHandler) {
        super(TourTimeBucketModel.createTimeExtractor(), 7, busyHandler);
        this.modelEnviroment = modelEnviroment;
    }

    private static TimeExtractor<TourModel> createTimeExtractor() {
        return new TimeExtractor<TourModel>(){

            @Override
            public Date getTime(TourModel tour) {
                return tour.getPlannedStartTime();
            }
        };
    }

    @Override
    protected Map<Integer, Collection<TourModel>> callback(Collection<Integer> ts, Date startTime, Date endTime) {
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        List<TourModel> toursInTimeWindows = tourCaller.fetchToursInTimeWindows(CollectionUtil.buildHashSet(new Tupel<Date, Date>(startTime, endTime)), null, TourModelUtil.tour_weight_active || TourModelUtil.tour_cost_active);
        HashMap<Integer, Collection<TourModel>> map = new HashMap<Integer, Collection<TourModel>>(1);
        map.put(KEY, toursInTimeWindows);
        return map;
    }

    public Collection<TourModel> findObjects(Date startTime, Date endTime) {
        Map bucketMap = super.findBuckets(CollectionUtil.buildHashSet(KEY), startTime, endTime);
        HashSet<TourModel> objects = new HashSet<TourModel>();
        for (Collection tours : bucketMap.values()) {
            for (TourModel tour : tours) {
                Date plannedTime = tour.getPlannedStartTime();
                if (tour.isDeleted() || plannedTime == null || !plannedTime.equals(startTime) && !plannedTime.after(startTime) || !plannedTime.before(endTime)) continue;
                objects.add(tour);
            }
        }
        return objects;
    }

    public void addObject(TourModel tour) {
        super.addObject(KEY, tour);
    }
}

