/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ktde.math.projection.Wgs84Factory;

public class GeoTrackingModelUtil {
    public static List<String> getInfoBoxString(GeoTrackingModel geoTracking) {
        ArrayList<String> infoBoxString = new ArrayList<String>();
        infoBoxString.add(ClientFormUtil.dateToString(geoTracking.getTime()));
        ImmutablePoint point = (ImmutablePoint)geoTracking.getGeoLocation().getTransformed(Wgs84Factory.INSTANCE);
        infoBoxString.add(FormUtil.roundWithDecimal(point.getX(), 5) + ", " + FormUtil.roundWithDecimal(point.getY(), 5));
        infoBoxString.add(geoTracking.getTour().getName());
        return infoBoxString;
    }

    public static String getTrackingInfo(List<GeoTrackingModel> trackings) {
        Double duration = GeoTrackingModelUtil.calculateDuration(trackings);
        String info = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{ClientFormUtil.getSecondTimeString(duration)});
        Double distance = GeoTrackingModelUtil.calculateDistance(trackings);
        String distanceString = ModelEnviroment.getMessageResolver().getNumberFormat().format((int)Math.round(distance));
        info = info + ", " + ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{distanceString});
        return info;
    }

    public static Double calculateDistance(List<GeoTrackingModel> trackings) {
        Double distance = 0.0;
        if (trackings != null) {
            GeoTrackingModel pred = null;
            for (GeoTrackingModel tracking : trackings) {
                if (tracking != null) {
                    if (pred == null) {
                        pred = tracking;
                    } else if (pred != null && tracking != null && pred.getGeoLocation() != null && tracking.getGeoLocation() != null) {
                        distance = distance + GeoUtils.getDistanceInMeter(pred.getGeoLocation().getCoordinate(), tracking.getGeoLocation().getCoordinate());
                    }
                }
                pred = tracking;
            }
        }
        return distance;
    }

    public static Double calculateDuration(List<GeoTrackingModel> trackings) {
        Date first = null;
        Date last = null;
        for (GeoTrackingModel tracking : trackings) {
            Date time = tracking.getTime();
            if (tracking == null || time == null) continue;
            if (first == null || last == null) {
                first = time;
                last = time;
                continue;
            }
            if (first.after(time)) {
                first = time;
                continue;
            }
            if (!last.before(time)) continue;
            last = time;
        }
        long duration = 0L;
        if (first != null && last != null) {
            duration = (last.getTime() - first.getTime()) / 1000L;
        }
        return duration;
    }
}

