/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.ToursRoutingDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingPanel;
import de.datomino.util.collection.CollectionUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.ktde.util.cache.ChangeSet;

public class TourSettingListener
extends MouseAdapter
implements WindowListener {
    private TourManagerCalendarGui tourManagerCalendarGui;
    private TourSettingDialog tourSettingDialog;

    public TourSettingListener(TourManagerCalendarGui tourManagerCalendarGui, TourSettingDialog tourSettingDialog) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.tourSettingDialog = tourSettingDialog;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (ChangeSet.currentChangeTransaction.get() != null && !ChangeSet.currentChangeTransaction.get().isEmpty()) {
            int d = JOptionPane.showConfirmDialog(this.tourSettingDialog, "Wollen Sie die \u00c4nderungen speichern?", "\u00c4nderungen speichern", 1, 3);
            switch (d) {
                case 0: {
                    this.tourManagerCalendarGui.getActions().getUndoManager().finishTransaction("Die Tour " + this.tourSettingDialog.getTourSettingPanel().getTour().getName() + " wird ge\u00e4ndert.");
                    break;
                }
                case 1: {
                    this.tourManagerCalendarGui.getActions().getUndoManager().rollbackTransaction();
                    break;
                }
                default: {
                    return;
                }
            }
            ((JDialog)this.tourSettingDialog.getParent().getParent().getParent().getParent()).dispose();
            this.tourManagerCalendarGui.getActions().repaint();
        }
        ((JDialog)this.tourSettingDialog.getParent().getParent().getParent().getParent()).dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        final TourSettingPanel tourSettingPanel = this.tourSettingDialog.getTourSettingPanel();
        if (tourSettingPanel.needCalculation()) {
            UndoManager undoManager = this.tourManagerCalendarGui.getActions().getUndoManager();
            undoManager.startTransaction();
            ToursRoutingDialog dialog = new ToursRoutingDialog(this.tourManagerCalendarGui){
                private static final long serialVersionUID = -8540948701733519774L;

                @Override
                protected void repaintGui() {
                    TourSettingListener.this.tourManagerCalendarGui.getTourMapGui().repaintGui(false);
                    TourSettingListener.this.tourManagerCalendarGui.getTimeLineGui().refresh(this.getTours());
                }

                @Override
                protected Collection<TourModel> getTours() {
                    return CollectionUtil.buildHashSet(tourSettingPanel.getTour());
                }
            };
            dialog.setVisible(true);
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.afterRouting", Integer.valueOf(1)));
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

