/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.DelivererTreeGui;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.dto.importer.GeoTrackCsvImportDto;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourListGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourRoutingDialog;
import de.datomino.peppergis.tourmanager.handler.action.tour.TourTransferable;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.collection.CollectionUtil;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.ktde.util.StringUtil;

public class TourListListener
extends MouseAdapter
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private TourManagerCalendarGui tourManagerCalendarGui;
    private TourPlanTableGui planTableGui;
    private TourListGui tourGui;
    private DelivererTreeGui delivererGui;
    private UndoManager undoManager;
    private boolean canChange = false;

    public TourListListener(TourManagerCalendarGui tourManagerCalendarGui) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.planTableGui = tourManagerCalendarGui.getPlanTableGui();
        this.tourGui = tourManagerCalendarGui.getTourListGui();
        this.delivererGui = tourManagerCalendarGui.getDelivererGui();
        this.undoManager = tourManagerCalendarGui.getActions().getUndoManager();
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            this.canChange = true;
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        int selRow = this.planTableGui.getPlanTable().getSelectedRow();
        int selCol = this.planTableGui.getPlanTable().getSelectedColumn();
        int selIndex = this.tourGui.getTourJList().getSelectedIndex();
        this.clearSelection();
        if (!dtde.isDataFlavorSupported(TourTransferable.getDataFlavor()) || !this.isAllowedDrop(selIndex)) {
            dtde.rejectDrop();
            return;
        }
        Object transferObject = null;
        try {
            transferObject = dtde.getTransferable().getTransferData(TourTransferable.getDataFlavor());
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dtde.acceptDrop(3);
        this.updatPlanTable((TourModel)transferObject, selRow, selCol);
        this.updateTourList((TourModel)transferObject);
        dtde.dropComplete(true);
    }

    private void clearSelection() {
        this.tourGui.getTourJList().clearSelection();
        this.delivererGui.getDelivererJTree().clearSelection();
        this.planTableGui.getPlanTable().clearSelection();
    }

    private void updateTourList(TourModel tourModel) {
        this.fireTourObjectUpdate(tourModel);
        this.tourGui.getTourListModel().addElement(tourModel);
        this.tourGui.getTourJList().repaint();
    }

    private void fireTourObjectUpdate(TourModel tourModel) {
        this.undoManager.startTransaction();
        tourModel.setPlannedStartTime(null);
        for (TourModel oldTour : this.tourGui.getAllTours()) {
            if (!tourModel.getTempUUID().equals(oldTour.getTempUUID())) continue;
            this.planTableGui.setTourPosition(oldTour, -1, -1);
        }
        this.undoManager.finishTransaction("Tour " + tourModel.getName() + " wird in der Tourliste verschoben.");
    }

    private void updatPlanTable(TourModel tourModel, int selRow, int selCol) {
        if (selRow > -1 && selCol > 0) {
            this.planTableGui.getPlanTableModel().setObjectAt(new TourModelImpl(new Long(0L), null), selRow, selCol);
            this.planTableGui.removeSelectIfExists(tourModel);
            this.planTableGui.getPlanTableModel().fireTableDataChanged();
        }
    }

    private boolean isAllowedDrop(int selIndex) {
        return selIndex <= -1;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        if (this.planTableGui.isInTable(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultMoveDrop);
        } else {
            context.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.delivererGui.getDelivererJTree().clearSelection();
        this.planTableGui.getPlanTable().clearSelection();
        if (this.tourGui.getTourJList().getSelectedIndex() != -1) {
            dge.startDrag(DragSource.DefaultMoveDrop, new TourTransferable(this.tourGui.getSelTour()), this);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TourModel selTour = this.tourGui.getSelTour();
        if (selTour != null && !e.isConsumed()) {
            e.consume();
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                try {
                    this.undoManager.startTransaction();
                    TourRoutingDialog.createAndShowGUI(this.tourManagerCalendarGui, selTour, true);
                    this.undoManager.finishTransaction("Die Tour " + selTour.getName() + " wurde ge\u00e4ndert.");
                }
                catch (UnsupportedEncodingException | NullPointerException e1) {
                    e1.printStackTrace();
                }
                this.clearSelection();
            } else if (e.getButton() == 3) {
                if (this.canChange) {
                    this.showPopupMenu(e, selTour);
                }
                this.clearSelection();
            }
        }
    }

    private void showPopupMenu(MouseEvent e, final TourModel tour) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.rename", new Serializable[0])){
            private static final long serialVersionUID = 8918386789551397954L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourListListener.this.rename(tour);
            }
        });
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = 4163165392330622119L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourListListener.this.tourManagerCalendarGui.getActions().removeTours(CollectionUtil.buildHashSet(tour));
            }
        });
        popupMenu.show(this.tourGui.getTourJList(), e.getX(), e.getY());
    }

    private void rename(TourModel tour) {
        String newName = JOptionPane.showInputDialog(this.tourGui.getTourJList(), ModelEnviroment.getMessageResolver().resolveMessageForEnum(GeoTrackCsvImportDto.GeoTrackColumns.TOUR_NAME), tour.getName());
        if (!StringUtil.isBlank(newName) && !newName.equals(tour.getName())) {
            this.undoManager.startTransaction();
            tour.setName(newName);
            this.undoManager.finishTransaction("Die Tour " + tour.getName() + " wurde umbenannt.");
            this.tourGui.getTourJList().repaint(10L);
        }
    }
}

