/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.stop;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.tourmanager.gui.stop.UnsortedStopPane;
import de.datomino.peppergis.tourmanager.gui.tour.TourSplitDialog;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.UserRole;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;

public class StopTableListener
extends MouseAdapter
implements MouseMotionListener,
DropTargetListener,
WindowListener {
    private static final UserRole[] ALLOWED_USER_ROLES = new UserRole[]{UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER};
    private TourManagerCalendarGui tourManagerCalendarGui;
    private StopTablePanel stopTablePanel;
    private UnsortedStopPane unsortedStopPanel;
    private boolean editable;

    public StopTableListener(TourManagerCalendarGui tourManagerCalendarGui, StopTablePanel stopTablePanel, UnsortedStopPane unsortedStopPanel, boolean editable) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.stopTablePanel = stopTablePanel;
        this.unsortedStopPanel = unsortedStopPanel;
        this.editable = editable;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(ALLOWED_USER_ROLES)) {
            StopModel selStop = this.stopTablePanel.getSelStopModel();
            if (selStop == null || selStop.getPoi() != null && selStop.getPoi().getPoiType() == PoiType.DELIVERER_LOCATION) {
                return;
            }
            JComponent c = (JComponent)e.getSource();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, e, 2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.stopTablePanel.getStopTable().setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(ALLOWED_USER_ROLES)) {
            int selRow = this.stopTablePanel.getSelectedRow();
            StopModel selStop = this.stopTablePanel.getSelStopModel();
            if (selStop != null && selStop.getPoi() == null) {
                dtde.acceptDrop(3);
                this.unsortedStopPanel.addStop(selStop);
                this.stopTablePanel.removeStopInTable(selRow);
                dtde.dropComplete(true);
                this.stopTablePanel.updateStopTable();
                this.unsortedStopPanel.refreshUnsortedStops();
            }
            this.unsortedStopPanel.getStopTable().clearSelection();
            this.stopTablePanel.getStopTable().clearSelection();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tourManagerCalendarGui.setEnabled(false);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.tourManagerCalendarGui.setEnabled(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            StopModel selStop;
            if (this.unsortedStopPanel == null && e.getClickCount() == 1 && (e.getModifiers() & 2) > 0) {
                int rowAtPoint = this.stopTablePanel.getStopTable().rowAtPoint(e.getPoint());
                StopModel selStop2 = this.stopTablePanel.getStopModelInTableAt(rowAtPoint);
                if (rowAtPoint == 0 || selStop2 == null || selStop2.getPoi() != null) {
                    return;
                }
                Set<StopModel> selectedStops = this.stopTablePanel.getSelectedStops();
                if (selectedStops.contains(selStop2)) {
                    selectedStops.remove(selStop2);
                } else {
                    selectedStops.add(selStop2);
                }
                this.stopTablePanel.getStopTable().repaint(10L);
            } else if (e.getClickCount() == 2 && (selStop = this.stopTablePanel.getSelStopModel()) != null) {
                boolean undoManagerStarted = false;
                if (this.editable) {
                    undoManagerStarted = true;
                }
                AddAndUpdateStopDialog showStopDialog = new AddAndUpdateStopDialog(this.tourManagerCalendarGui.getModelEnviroment(), undoManagerStarted, this.stopTablePanel){
                    private static final long serialVersionUID = 2264735347233926772L;

                    @Override
                    protected void processWindowEvent(WindowEvent e) {
                        super.processWindowEvent(e);
                        if (e.getID() == 202) {
                            StopTableListener.this.stopTablePanel.updateStopTable();
                        }
                    }
                };
                showStopDialog.showDialog(selStop, this.editable, (Component)this.tourManagerCalendarGui);
            }
        } else if (this.unsortedStopPanel == null && e.getButton() == 3) {
            this.createPopupMenu(e);
        }
    }

    private void createPopupMenu(MouseEvent e) {
        if (this.stopTablePanel.getSelectedStops().isEmpty()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.split", new Serializable[0])){
            private static final long serialVersionUID = -4341621273838641899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopTableListener.this.splitTour();
            }
        });
        popupMenu.setLocation(e.getLocationOnScreen());
        popupMenu.show(this.stopTablePanel.getStopTable(), e.getX(), e.getY());
    }

    private void splitTour() {
        TourModel tour = this.stopTablePanel.getTour();
        Set<StopModel> selectedStops = this.stopTablePanel.getSelectedStops();
        TourSplitDialog dialog = new TourSplitDialog(tour, selectedStops, this.tourManagerCalendarGui);
        dialog.setVisible(true);
        this.stopTablePanel.updateStopTable();
    }
}

