/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.stop;

import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.tourmanager.listener.AbstractTextComponentListener;
import de.datomino.peppergis.util.FormUtil;
import javax.swing.text.JTextComponent;
import org.ktde.util.StringUtil;

public class StopInformationListener
extends AbstractTextComponentListener {
    private StopModel stopModel;
    private INFORMATIONTYPE type;

    public StopInformationListener(StopModel stopModel, JTextComponent textField, INFORMATIONTYPE type) {
        super(textField);
        this.stopModel = stopModel;
        this.type = type;
    }

    @Override
    public void focusGainedAction() {
    }

    @Override
    public void validateAndStoreInput() {
        String validatedInput = this.validateInput();
        if (validatedInput == null) {
            this.textComponent.setText(this.getWarnMessage());
            this.textComponent.setEditable(false);
        } else {
            this.storeInput(validatedInput);
            this.textComponent.setEditable(false);
        }
    }

    private String getWarnMessage() {
        if (this.type == INFORMATIONTYPE.EstimatedDurationSeconds) {
            return "Die Eingabe muss eine Zahl sein.";
        }
        return "";
    }

    private String validateInput() {
        String validatedInput = null;
        String text = this.textComponent.getText().trim();
        if (this.type == INFORMATIONTYPE.EstimatedDurationSeconds) {
            try {
                double sec = ClientFormUtil.getNumber(text).doubleValue() * 60.0;
                validatedInput = String.valueOf(Math.round(sec));
                this.textComponent.setText(FormUtil.getSecondTimeString(sec));
            }
            catch (Exception e) {
                validatedInput = null;
            }
        } else {
            validatedInput = text;
        }
        return validatedInput;
    }

    private void storeInput(String validatedInput) {
        switch (this.type) {
            case Information: {
                this.stopModel.setInformation(validatedInput);
                break;
            }
            case DelivererInformation: {
                this.stopModel.setDelivererInformation(validatedInput);
                break;
            }
            case EstimatedDurationSeconds: {
                this.stopModel.setEstimatedDurationSeconds(StringUtil.isBlank(validatedInput) ? 0 : Integer.valueOf(validatedInput));
                break;
            }
            case ParkingInformation: {
                this.stopModel.setParkingInformation(validatedInput);
            }
        }
    }

    public static enum INFORMATIONTYPE {
        Information,
        ParkingInformation,
        DelivererInformation,
        EstimatedDurationSeconds;

    }
}

