/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.map;

import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.tourmanager.gui.filter.StopFilterLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.map.TourLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.map.UnsortedStopLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public class TourMapMouseManipulator
extends DefaultMouseManipulator {
    private TourMapGui tourMapGui;
    private Point2D.Double startPoint;
    private boolean selectionActive;
    private boolean additionActive;
    private Set<StopModel> unteredStops = new HashSet<StopModel>();

    public TourMapMouseManipulator(TourMapGui tourMapGui) {
        this.tourMapGui = tourMapGui;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.additionActive) {
            this.tourMapGui.updateAddStopsCursor(e.getLocationOnScreen());
        } else if (this.selectionActive) {
            Point2D.Double currentPoint = this.tourMapGui.getNavigatorPanel().getReal(e.getX(), e.getY());
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.x = Math.min(this.startPoint.x, currentPoint.x);
            rectangle.y = Math.min(this.startPoint.y, currentPoint.y);
            rectangle.width = Math.abs(currentPoint.x - this.startPoint.x);
            rectangle.height = Math.abs(currentPoint.y - this.startPoint.y);
            Set<StopModel> stops = this.updateSelectedStops(e.getModifiers(), rectangle);
            String weightString = this.getWeightString(stops);
            this.tourMapGui.getTourLayerRenderer().setSelectedRectangle(new Tupel<Rectangle2D.Double, String>(rectangle, weightString));
        }
        this.tourMapGui.getNavigatorPanel().repaint();
    }

    private String getWeightString(Set<StopModel> stops) {
        double sum = 0.0;
        for (StopModel stop : stops) {
            Double weight = StopModelUtil.getAttributeSum(stop, "WEIGHT");
            sum += weight == null ? 0.0 : weight;
        }
        long r = Math.round(sum *= 100.0);
        String weightString = Long.toString(r);
        weightString = StringUtils.leftPad(weightString, 3, '0');
        int length = weightString.length();
        weightString = weightString.substring(0, length - 2) + "," + weightString.substring(length - 2, length);
        return weightString;
    }

    private void selectionFinished(MouseEvent e) {
        this.selectionActive = false;
        this.startPoint = null;
        this.tourMapGui.getTourLayerRenderer().setSelectedRectangle(null);
        this.tourMapGui.getNavigatorPanel().repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point2D.Double real = this.tourMapGui.getNavigatorPanel().getReal(e.getX(), e.getY());
        double upp = this.tourMapGui.getNavigatorPanel().getUpp();
        this.tourMapGui.getTourLayerRenderer().doMouseMoved(real);
        this.tourMapGui.getUnsortedStopLayerRenderer().doMouseMoved(real);
        this.tourMapGui.getStopFilterLayerRenderer().doMouseMoved(real);
        this.tourMapGui.getGeoTrackingRenderer().doMouseMoved(real, upp);
        this.tourMapGui.getTourTrackingRenderer().doMouseMoved(real);
        this.tourMapGui.getNavigatorPanel().repaint();
    }

    @Override
    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Point2D.Double real = this.tourMapGui.getNavigatorPanel().getReal(x, y);
        if (clickCount == 1) {
            if (this.showInfoboxOfSubscription(real)) {
                this.tourMapGui.getNavigatorPanel().repaint();
                return;
            }
            this.updateSelectedStops(modifiers, real);
            this.tourMapGui.getNavigatorPanel().repaint();
        } else if (clickCount > 1) {
            Set<StopModel> stops = this.getStopsOnTourLayer(real, true);
            stops.addAll(this.getStopsOnUnsortedStopLayer(real));
            if (!stops.isEmpty()) {
                AddAndUpdateStopDialog addAndUpdateStopDialog = new AddAndUpdateStopDialog(this.tourMapGui.getModelEnviroment(), true, null);
                addAndUpdateStopDialog.showDialog(stops.iterator().next(), true, (Component)this.tourMapGui);
            }
        }
        for (NavigatorRenderer renderer : this.tourMapGui.getRenderer()) {
            if (!(renderer instanceof DefaultMouseManipulator) || renderer instanceof TourMapMouseManipulator || !renderer.isActive()) continue;
            ((DefaultMouseManipulator)((Object)renderer)).mouseClickFinished(x, y, clickCount, modifiers, mouseButton);
        }
    }

    private Set<StopModel> updateSelectedStops(int modifiers, Object o) {
        Set<StopModel> stops = null;
        if (this.tourMapGui.getSelectedStopsForRemove().isEmpty()) {
            stops = this.getStopsOnUnsortedStopLayer(o);
            if (this.selectionActive) {
                this.tourMapGui.getSelectedStopsForAdd().addAll(stops);
            } else {
                this.tourMapGui.updateSelectedStopsForAdd(stops);
            }
        }
        if (this.tourMapGui.getSelectedStopsForAdd().isEmpty()) {
            stops = this.getStopsOnTourLayer(o, false);
            if (this.selectionActive) {
                this.tourMapGui.getSelectedStopsForRemove().addAll(stops);
            } else {
                this.tourMapGui.updateSelectedStopsForRemove(stops);
            }
        }
        return stops;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.startPoint = this.tourMapGui.getNavigatorPanel().getReal(e.getX(), e.getY());
        if ((e.getModifiers() & 2) > 0) {
            this.selectionActive = true;
            Set<StopModel> sorted = this.getStopsOnTourLayer(this.startPoint, false);
            if (sorted.isEmpty()) {
                this.tourMapGui.clearSelectedStopsForRemove();
            } else {
                this.tourMapGui.clearSelectedStopsForAdd();
                Set<StopModel> remove = this.tourMapGui.getSelectedStopsForRemove();
                for (StopModel stop : sorted) {
                    if (remove.contains(stop)) {
                        remove.remove(stop);
                        continue;
                    }
                    remove.add(stop);
                }
            }
            Set<StopModel> unsorted = this.getStopsOnUnsortedStopLayer(this.startPoint);
            if (unsorted.isEmpty()) {
                this.tourMapGui.clearSelectedStopsForAdd();
            } else {
                this.tourMapGui.clearSelectedStopsForRemove();
                Set<StopModel> add = this.tourMapGui.getSelectedStopsForAdd();
                for (StopModel stop : unsorted) {
                    if (add.contains(stop)) {
                        add.remove(stop);
                        continue;
                    }
                    add.add(stop);
                }
            }
        } else {
            this.unteredStops = this.getStopsOnUnsortedStopLayer(this.startPoint);
            this.unteredStops.addAll(this.getStopsOnTourLayer(this.startPoint, false));
            if (!this.unteredStops.isEmpty()) {
                this.tourMapGui.getNavigatorPanel().setCursor(DragSource.DefaultMoveNoDrop);
                this.additionActive = true;
            }
        }
        this.tourMapGui.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.additionActive) {
            this.additionFinished(e);
        } else if (this.selectionActive) {
            this.selectionFinished(e);
        }
        this.tourMapGui.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (NavigatorPanningAction.performWheelZoom(e, this.tourMapGui.getNavigatorPanel())) {
            this.tourMapGui.getNavigatorPanel().forceCalcTransform();
            this.tourMapGui.updateParcelAndSubscription();
        }
    }

    private void additionFinished(MouseEvent e) {
        if (!this.unteredStops.isEmpty()) {
            if ((this.tourMapGui.getUnsortedStopLayerRenderer().isActive() || this.tourMapGui.getStopFilterLayerRenderer().isActive()) && !this.tourMapGui.getSelectedStopsForAdd().isEmpty()) {
                this.tourMapGui.fireDragAndDrop(e.getLocationOnScreen(), false);
            }
            if (!this.tourMapGui.getSelectedStopsForRemove().isEmpty()) {
                this.tourMapGui.getSelectedStopsForAdd().addAll(this.tourMapGui.getSelectedStopsForRemove());
                this.tourMapGui.fireDragAndDrop(e.getLocationOnScreen(), true);
            }
        }
        this.additionActive = false;
    }

    private Set<StopModel> getStopsOnTourLayer(Object o, boolean withPoi) {
        HashSet<StopModel> selectedStops = new HashSet<StopModel>();
        TourLayerRenderer r = this.tourMapGui.getTourLayerRenderer();
        if (r.isActive()) {
            Set<StopModel> stops = r.getPointsOnMap().keySet();
            for (StopModel stop : stops) {
                Rectangle2D.Double rectangle = r.getPointsOnMap().get(stop);
                if (!this.intersects(rectangle, o) || !withPoi && stop.getPoi() != null) continue;
                selectedStops.add(stop);
            }
        }
        return selectedStops;
    }

    private Set<StopModel> getStopsOnUnsortedStopLayer(Object geom) {
        StopFilterLayerRenderer stopFilterLayerRenderer;
        HashSet<StopModel> stops = new HashSet<StopModel>();
        UnsortedStopLayerRenderer r = this.tourMapGui.getUnsortedStopLayerRenderer();
        if (r.isActive()) {
            r.setMouseMoved(null);
            stops.addAll(r.getDrawedPointsOnMap().keySet());
        }
        if ((stopFilterLayerRenderer = this.tourMapGui.getStopFilterLayerRenderer()).isActive()) {
            stopFilterLayerRenderer.setMouseMoved(null);
            stops.addAll(stopFilterLayerRenderer.getDrawedPointsOnMap().keySet());
        }
        HashSet<StopModel> selectedStops = new HashSet<StopModel>();
        Map<StopModel, Rectangle2D.Double> drawedPointsOnMap = r.getDrawedPointsOnMap();
        for (StopModel stop : stops) {
            Rectangle2D.Double rectangle = stopFilterLayerRenderer.getDrawedPointsOnMap().get(stop);
            if (rectangle != null && this.intersects(rectangle, geom)) {
                selectedStops.add(stop);
            }
            if (drawedPointsOnMap == null || (rectangle = drawedPointsOnMap.get(stop)) == null || !this.intersects(rectangle, geom)) continue;
            selectedStops.add(stop);
        }
        return selectedStops;
    }

    private boolean intersects(Rectangle2D.Double rectangle, Object geom) {
        if (geom instanceof Point2D) {
            return rectangle.contains((Point2D)geom);
        }
        if (geom instanceof Rectangle2D) {
            return ((Rectangle2D)geom).intersects(rectangle) || ((Rectangle2D)geom).contains(rectangle);
        }
        return false;
    }

    private boolean showInfoboxOfSubscription(Point2D.Double real) {
        List<NavigatorRenderer> renderers = this.tourMapGui.getNavigatorPanel().getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof SubscriptionLayerRenderer) || !renderer.isActive()) continue;
            return ((SubscriptionLayerRenderer)renderer).showInfobox(real);
        }
        return false;
    }
}

