/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.filter;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.AreaTourInfoObject;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.TourRoutingActions;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import org.ktde.util.datatypes.Tripel;

public class FilterLegendListListener
extends MouseAdapter
implements KeyListener {
    private TourMapGui tourMapGui;
    private TourRoutingActions routingActions;
    private LegendObject<?> draggedObject;
    private boolean clear = false;

    public FilterLegendListListener(TourMapGui tourMapGui, BusyHandler busyHandler) {
        this.tourMapGui = tourMapGui;
        this.routingActions = new TourRoutingActions(this.tourMapGui.getTourManagerCalendarGui(), this.tourMapGui, busyHandler);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            Object selObject = this.tourMapGui.getSelObjectInList();
            if (selObject != null && selObject instanceof LegendObject) {
                Object o = ((LegendObject)selObject).getM();
                Window parent = SwingUtils.findWindowParent(this.tourMapGui);
                if (o instanceof StopModel) {
                    AddAndUpdateStopDialog addAndUpdateStopDialog = new AddAndUpdateStopDialog(this.tourMapGui.getModelEnviroment(), true, null);
                    addAndUpdateStopDialog.showDialog((StopModel)o, false, (Component)this.tourMapGui);
                } else if (o instanceof SubscriptionModel) {
                    SubscriptionDialog subscriptionDialog = new SubscriptionDialog(parent, Arrays.asList((SubscriptionModel)o), this.tourMapGui.getModelEnviroment());
                    subscriptionDialog.setVisible(true);
                } else if (o instanceof ParcelModel) {
                    ParcelDialog parcelDialog = new ParcelDialog(parent, (ParcelModel)o, Dialog.ModalityType.MODELESS, this.tourMapGui.getModelEnviroment(), false);
                    parcelDialog.setVisible(true);
                }
            }
        } else if (e.getButton() != 3) {
            this.clear = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int i;
        JList filterLegendList = this.tourMapGui.getFilterLegendList();
        if (this.draggedObject != null && (i = filterLegendList.getSelectedIndex()) != -1 && filterLegendList.getCursor().equals(DragSource.DefaultMoveDrop)) {
            DefaultListModel model = (DefaultListModel)filterLegendList.getModel();
            if (model.getElementAt(i) instanceof String) {
                ++i;
            } else if (model.getElementAt(i) instanceof AreaTourInfoObject) {
                ++i;
            }
            model.removeElement(this.draggedObject);
            model.add(i, this.draggedObject);
            filterLegendList.repaint(10L);
        }
        this.draggedObject = null;
        filterLegendList.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object o = this.tourMapGui.getFilterLegendList().getSelectedValue();
        if (o instanceof LegendObject) {
            this.draggedObject = (LegendObject)o;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.draggedObject != null) {
            this.tourMapGui.updateMoveModelsInFilterListCursor(e.getLocationOnScreen());
        }
    }

    @Deprecated
    private void route() throws LogisticException {
        JList legendList = this.tourMapGui.getFilterLegendList();
        if (legendList == null || legendList.getModel().getSize() < 2) {
            return;
        }
        List<Model> models = this.getModels(legendList.getModel());
        if (models == null || models.isEmpty()) {
            return;
        }
        AreaObjectModel areaObject = this.tourMapGui.getFilterAreaObject();
        Tripel<Object, Object, Object> parameter = new Tripel<Object, Object, Object>(null, null, null);
        if (parameter.getElement1() == null) {
            return;
        }
        UndoManager undoManager = this.tourMapGui.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        ArrayList<Model> modelsWithoutPois = new ArrayList<Model>();
        for (Model m : models) {
            if (m instanceof PoiModel) continue;
            modelsWithoutPois.add(m);
        }
        boolean update = false;
        if (parameter.getElement2() != null) {
            AreaAttributeValueDescriptorModel pickPointStartDescriptor = this.routingActions.getPickPointStartDescriptor();
            AreaObjectModelUtil.setAreaAttributeValue(areaObject, pickPointStartDescriptor, ((PoiModel)parameter.getElement2()).getPoiNumber());
            update = true;
        }
        if (parameter.getElement3() != null) {
            AreaAttributeValueDescriptorModel pickPointEndDescriptor = this.routingActions.getPickPointEndDescriptor();
            AreaObjectModelUtil.setAreaAttributeValue(areaObject, pickPointEndDescriptor, ((PoiModel)parameter.getElement3()).getPoiNumber());
            update = true;
        }
        if (update) {
            undoManager.finishTransaction("Neue Abholungsorte f\u00fcr Gebiet");
            try {
                undoManager.storeTransactions();
            }
            catch (ValidateException e) {
                undoManager.rollbackTransaction();
            }
            undoManager.startTransaction();
        }
        this.routingModel(areaObject, modelsWithoutPois, parameter.getElement1());
        undoManager.finishTransaction("Ein neue Zustelltour wurde erstellt.");
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            undoManager.rollbackTransaction();
        }
    }

    private List<Model> getModels(ListModel listModel) {
        ArrayList<Model> models = new ArrayList<Model>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object element = listModel.getElementAt(i);
            if (!(element instanceof LegendObject)) continue;
            models.add((Model)((LegendObject)element).getM());
        }
        return models;
    }

    private void routingModel(AreaObjectModel areaObject, List<? extends Object> models, AreaTourParameter parameter) throws LogisticException {
        AreaCalculationType areaCalculationType;
        if (this.clear && !parameter.isOrigSortOrder()) {
            int d = JOptionPane.showConfirmDialog(this.tourMapGui, "Wird die alte Zustelltour verwendet, falls die vorhanden ist?", "", 0);
            switch (d) {
                case 0: {
                    this.clear = false;
                    break;
                }
                case 1: {
                    this.clear = true;
                    break;
                }
                default: {
                    this.clear = false;
                    return;
                }
            }
        }
        boolean optimised = parameter.getRoutingType() instanceof OptimizationType;
        boolean withSide = parameter.getAlgorithmType().withSide();
        AreaCalculationType areaCalculationType2 = optimised ? (withSide ? AreaCalculationType.SIDE : AreaCalculationType.DEFAULT) : (areaCalculationType = AreaCalculationType.CALCULATION);
        if (models.get(0) instanceof SubscriptionModel) {
            throw new RuntimeException("should not be called");
        }
        if (models.get(0) instanceof ParcelModel) {
            throw new RuntimeException("should not be called");
        }
        if (models.get(0) instanceof LetterModel) {
            AreaObjectType areaObjectType = AreaObjectType.LETTER;
            parameter.setAreaTourType(new AreaTourType(areaObjectType, areaCalculationType));
        }
        this.clear = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.clear = true;
        }
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

