/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.job;

import de.datomino.peppergis.bi.CommonBi;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.AbstractSpecificDto;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.util.swing.SwingUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.ktde.model.ValueChangeEvent;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefreshToursJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshToursJob.class);

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        TourManagerCalendarGui parent = (TourManagerCalendarGui)context.getJobDetail().getJobDataMap().get("parent");
        boolean b = SwingUtils.isModalDialogShowing();
        if (!b) {
            this.refreshTours(parent);
            this.doAfter(parent);
            LOGGER.info("refresh tours");
        }
    }

    protected abstract Set<TourModel> getTours(TourManagerCalendarGui var1);

    protected abstract void doAfter(TourManagerCalendarGui var1);

    protected void refreshTours(TourManagerCalendarGui parent) {
        ModelEnviroment modelEnviroment = parent.getModelEnviroment();
        UndoManager undoManager = modelEnviroment.getUndoManager();
        if (!undoManager.hasCurrentTransactionChanges() && !undoManager.canUndo()) {
            Collection<TourModel> unsavedTours = undoManager.getChangedObjects(TourModel.class);
            Set<TourModel> tours = this.getTours(parent);
            for (TourModel tour : tours) {
                if (unsavedTours.contains(tour) || tour.isDirty()) continue;
                this.refreshModel((TourModelImpl)tour, modelEnviroment);
                this.refreshTourParts(tour, modelEnviroment);
                tour.fireModelValueChangeEvent(new ValueChangeEvent(tour, ValueChangeEvent.Type.UPDATE, null, null, null));
            }
        }
    }

    private void refreshTourParts(TourModel tour, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<TourPartModel> unsavedTourParts = undoManager.getChangedObjects(TourPartModel.class);
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPart = tourPartIter.next();
            if (unsavedTourParts.contains(tourPart) || tourPart.isDirty()) continue;
            this.refreshModel((TourPartModelImpl)tourPart, modelEnviroment);
            this.refreshStops(tourPart, modelEnviroment);
        }
    }

    private void refreshStops(TourPartModel tourPart, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<StopModel> unsavedStops = undoManager.getChangedObjects(StopModel.class);
        Iterator<StopModel> stopIter = tourPart.iterateStops();
        while (stopIter.hasNext()) {
            StopModel stop = stopIter.next();
            if (unsavedStops.contains(stop) || stop.isDirty()) continue;
            this.refreshModel((StopModelImpl)stop, modelEnviroment);
            this.refreshServiceStopRelations(stop, modelEnviroment);
            this.refreshLocationCapturings(stop, modelEnviroment);
        }
    }

    private void refreshLocationCapturings(StopModel stop, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<LocationCapturingModel> unsavedRelations = undoManager.getChangedObjects(LocationCapturingModel.class);
        Iterator<LocationCapturingModel> relationIter = stop.iterateLocationCapturings();
        while (relationIter.hasNext()) {
            LocationCapturingModel relation = relationIter.next();
            if (unsavedRelations.contains(relation) || relation.isDirty()) continue;
            this.refreshModel(relation, modelEnviroment);
        }
    }

    private void refreshTimeWindows(StopModel stop, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<TimeWindowModel> unsavedTimeWindows = undoManager.getChangedObjects(TimeWindowModel.class);
        Iterator<TimeWindowModel> timeWindowIter = stop.iterateTimeWindows();
        while (timeWindowIter.hasNext()) {
            TimeWindowModel timeWindow = timeWindowIter.next();
            if (unsavedTimeWindows.contains(timeWindow) || timeWindow.isDirty()) continue;
            this.refreshModel((TimeWindowModelImpl)timeWindow, modelEnviroment);
        }
    }

    private void refreshServiceStopRelations(StopModel stop, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<ServiceTicketStopRelationModel> unsavedRelations = undoManager.getChangedObjects(ServiceTicketStopRelationModel.class);
        Iterator<ServiceTicketStopRelationModel> relationIter = stop.iterateServiceStopRelations();
        while (relationIter.hasNext()) {
            ServiceTicketStopRelationModel relation = relationIter.next();
            if (unsavedRelations.contains(relation) || relation.isDirty()) continue;
            this.refreshModel(relation, modelEnviroment);
            this.refreshServiceValues(relation, modelEnviroment);
        }
    }

    private void refreshServiceValues(ServiceTicketStopRelationModel relation, ModelEnviroment modelEnviroment) {
        UndoManager undoManager = modelEnviroment.getUndoManager();
        Collection<ServiceValueModel> unsavedValues = undoManager.getChangedObjects(ServiceValueModel.class);
        Iterator<ServiceValueModel> valueIter = relation.iterateServiceValues();
        while (valueIter.hasNext()) {
            ServiceValueModel value = valueIter.next();
            if (unsavedValues.contains(value) || value.isDirty()) continue;
            this.refreshModel((ServiceValueModelImpl)value, modelEnviroment);
        }
    }

    private <M extends Model> void refreshModel(M model, ModelEnviroment modelEnviroment) {
        CommonBi commonBi = modelEnviroment.getGeoServerStub().getCommonBi();
        AbstractProxyDto dto = model.createProxy();
        AbstractSpecificDto dto2 = commonBi.fetchModel(dto);
        model.updateByDto(dto2);
    }
}

