/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.job;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLineGui;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingResult;
import de.datomino.peppergis.tourmanager.handler.job.RefreshToursJob;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTourTimeLineJob
extends RefreshToursJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshTourTimeLineJob.class);

    @Override
    protected Set<TourModel> getTours(TourManagerCalendarGui parent) {
        HashSet<TourModel> tours = new HashSet<TourModel>();
        TourTimeLineGui timeLineGui = parent.getTimeLineGui();
        CollectionUtil.transform(timeLineGui.getTours(), tours, new Transformer<TourTrackingResult, TourModel>(){

            @Override
            public TourModel transform(TourTrackingResult t) {
                return t.getTour();
            }
        });
        return tours;
    }

    @Override
    protected void doAfter(TourManagerCalendarGui parent) {
        LOGGER.info("refresh tracking points");
        Date lastTime = null;
        HashSet<TourModel> updates = new HashSet<TourModel>();
        TourTimeLineGui timeLineGui = parent.getTimeLineGui();
        for (TourTrackingResult tour : timeLineGui.getTours()) {
            for (GeoTrackingModel tracking : tour.getGeoTrackings()) {
                Date time = tracking.getTime();
                if (time == null || lastTime != null && !lastTime.before(time)) continue;
                lastTime = time;
            }
            updates.add(tour.getTour());
        }
        TourCaller tourCaller = parent.getModelEnviroment().getAllCaller().getTourCaller();
        Collection<GeoTrackingModel> trackings = tourCaller.getGeoTrackings(null, updates, CollectionUtil.buildHashSet(GeoTrackingType.values()), 0L, lastTime);
        HashMap<TourModel, List<GeoTrackingModel>> trackingMap = new HashMap<TourModel, List<GeoTrackingModel>>();
        for (GeoTrackingModel tracking : trackings) {
            TourModel tour = tracking.getTour();
            ArrayList<GeoTrackingModel> list = (ArrayList<GeoTrackingModel>)trackingMap.get(tour);
            if (list == null) {
                list = new ArrayList<GeoTrackingModel>();
                trackingMap.put(tour, list);
            }
            if (list.contains(tracking)) continue;
            list.add(tracking);
        }
        timeLineGui.loadGeoTracks(trackingMap);
        timeLineGui.repaintGui(false, null);
    }
}

