/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.tour;

import de.datomino.peppergis.client.gui.common.DatePicker;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class ShowToursOfSelectedDayAction
extends AbstractAction {
    private static final long serialVersionUID = -6159707570819193980L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private ModelEnviroment modelEnvironment;

    public ShowToursOfSelectedDayAction(TourManagerCalendarGui tourManagerCalendarGui, ModelEnviroment modelEnvironment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.day.display", new Serializable[0]));
        this.modelEnvironment = modelEnvironment;
        this.tourManagerCalendarGui = tourManagerCalendarGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DatePicker dateInputDialog = new DatePicker();
        ShowToursOfSelectedDayAction showToursOfSelectedDayAction = this;
        int choice = JOptionPane.showConfirmDialog(this.tourManagerCalendarGui, dateInputDialog, showToursOfSelectedDayAction.modelEnvironment.getMessageResolver().resolveMessage("messages.default.chooseDay", new Serializable[0]), 2);
        if (choice == 0) {
            TourMapGui tourMapGui = this.tourManagerCalendarGui.getTourMapGui();
            Tupel<Date, Object> day = new Tupel<Date, Object>(dateInputDialog.getSelectedItem(), null);
            day.setElement2(TimeUtil.getEndOfDay(day.getElement1()));
            tourMapGui.clearUnsortedStops();
            tourMapGui.setStopSymbolWithStock(true);
            List<TourModel> toursOfSelectedDay = this.modelEnvironment.getAllCaller().getTourCaller().fetchToursInTimeIntervals(CollectionUtil.buildLinkedList(day), true);
            if (toursOfSelectedDay == null || toursOfSelectedDay.isEmpty()) {
                JOptionPane.showMessageDialog(this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.noToursThisDay", new Serializable[0]));
                return;
            }
            this.tourManagerCalendarGui.getTabbedPane().setSelectedComponent(tourMapGui);
            tourMapGui.setSelectedTours(toursOfSelectedDay);
            tourMapGui.center();
        }
    }
}

