/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ShowAllToursAction
extends AbstractAction {
    private static final long serialVersionUID = -1245094703240536661L;
    private TourManagerCalendarGui tourManagerCalendarGui;

    public ShowAllToursAction(TourManagerCalendarGui tourManagerCalendarGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.allTour", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        this.tourManagerCalendarGui = tourManagerCalendarGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showAllTours();
    }

    private void showAllTours() {
        this.tourManagerCalendarGui.getTourMapGui().clearUnsortedStops();
        this.tourManagerCalendarGui.getTourMapGui().setStopSymbolWithStock(true);
        Date currentDate = this.tourManagerCalendarGui.getCalendarGui().getCurrentDate();
        Set<TourModel> plannedTours = this.tourManagerCalendarGui.getTourListGui().getPlannedToursInWeek(currentDate);
        if (plannedTours == null || plannedTours.isEmpty()) {
            return;
        }
        int d = JOptionPane.showConfirmDialog(this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.warnTooMuch", Integer.valueOf(plannedTours.size())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 0);
        if (d == 1) {
            return;
        }
        this.tourManagerCalendarGui.getTourMapGui().setSelectedTours(plannedTours);
        this.tourManagerCalendarGui.getTourMapGui().center();
        this.tourManagerCalendarGui.getTabbedPane().setSelectedComponent(this.tourManagerCalendarGui.getTourMapGui());
    }
}

