/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.stop;

import de.datomino.peppergis.client.gui.attribute.MultipleChoiceListPane;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.client.util.ServiceModelUtil;
import de.datomino.peppergis.tourmanager.gui.stop.ServiceChoiceValueRenderer;
import de.datomino.peppergis.tourmanager.handler.action.service.ServiceValueCheckboxAction;
import de.datomino.peppergis.tourmanager.listener.stop.ServiceValueListener;
import de.datomino.peppergis.tourmanager.listener.stop.StaticComboBoxListener;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.ktde.util.datatypes.Holder;

public class UpdateServiceValueAction {
    private ServiceTicketStopRelationModel relationModel;
    private JPanel serviceValuePanel;

    public UpdateServiceValueAction(ServiceTicketStopRelationModel relationModel) {
        this.relationModel = relationModel;
    }

    public JPanel createServiceValuesPanel(boolean editable) {
        Iterator<ServiceValueDescriptorModel> serviceValueDescriptorIterator;
        try {
            serviceValueDescriptorIterator = this.relationModel.getServiceTicket().getService().iterateServiceValueDescriptors();
        }
        catch (NullPointerException e) {
            return null;
        }
        JScrollPane serviceValuesPanel = this.loadServiceValues(serviceValueDescriptorIterator, editable);
        serviceValuesPanel.getVerticalScrollBar().setUnitIncrement(10);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)serviceValuesPanel, "Center");
        panel.setBounds(105, 145, 475, 340);
        return panel;
    }

    private JScrollPane loadServiceValues(Iterator<ServiceValueDescriptorModel> serviceValueDescriptorIterator, boolean editable) {
        this.serviceValuePanel = new JPanel(null);
        int index = 1;
        Holder<Integer> imageCount = new Holder<Integer>(0);
        Holder<Integer> pdfCount = new Holder<Integer>(0);
        while (serviceValueDescriptorIterator.hasNext()) {
            this.loadServiceValue(serviceValueDescriptorIterator.next(), this.serviceValuePanel, index, editable, imageCount, pdfCount);
            ++index;
        }
        JScrollPane scrollPane = new JScrollPane(this.serviceValuePanel);
        return scrollPane;
    }

    private void loadServiceValue(ServiceValueDescriptorModel serviceValueDescriptorModel, JPanel panel, int index, boolean editable, Holder<Integer> imageCount, Holder<Integer> pdfCount) {
        int leftY = (index - 1) * 35 + 5;
        JTextField valueDescriptorNameLabel = new JTextField(ServiceModelUtil.adapteWidthOfField(serviceValueDescriptorModel.getName(), 195));
        valueDescriptorNameLabel.setBounds(5, leftY, 195, 25);
        valueDescriptorNameLabel.setEditable(false);
        valueDescriptorNameLabel.setBorder(BorderFactory.createEmptyBorder());
        panel.add(valueDescriptorNameLabel);
        ServiceValueModel serviceValueModel = ServiceModelUtil.getServiceValueModel(this.relationModel, serviceValueDescriptorModel);
        AttributeValueType serviceValueType = serviceValueDescriptorModel.getServiceValueType();
        if (serviceValueType == AttributeValueType.BOOLEAN && serviceValueDescriptorModel.getEditable().booleanValue()) {
            this.addServiceValueCheckBox(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable);
        } else if (serviceValueType == AttributeValueType.STATIC_CHOICE && serviceValueDescriptorModel.getEditable().booleanValue()) {
            this.addServiceValueComboBox(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable);
        } else if (serviceValueType == AttributeValueType.MULTIPLE_LIST_CHOICE) {
            this.addServiceValueMultipleListChoicePanel(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable);
        } else if (serviceValueType == AttributeValueType.DATE) {
            this.addServiceValueDate(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable);
        } else if (serviceValueType == AttributeValueType.IMAGE) {
            int imageIndex = imageCount.getElement() + 1;
            this.addServiceValueImage(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable, index, imageIndex);
            imageCount.setElement(imageIndex);
        } else if (serviceValueType == AttributeValueType.PDF_DOWN) {
            int pdfIndex = pdfCount.getElement() + 1;
            this.addServiceValuePdf(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable, index, pdfIndex);
            pdfCount.setElement(pdfIndex);
        } else {
            this.addServiceValueTextField(panel, leftY, serviceValueModel, serviceValueDescriptorModel, editable);
        }
        panel.setPreferredSize(new Dimension(455, leftY + 35));
    }

    private void addServiceValuePdf(final JPanel panel, int leftY, final ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable, int index, int pdfIndex) {
        byte[] b = serviceValueModel == null ? null : serviceValueModel.getPdfValue();
        boolean isPdfSet = b == null || b.length == 0;
        AbstractAction action = new AbstractAction(isPdfSet ? "..." : ModelEnviroment.getMessageResolver().resolveMessage("messages.pdf", new Serializable[0]) + " " + pdfIndex){
            private static final long serialVersionUID = 5197811532313305803L;

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] b = serviceValueModel.getPdfValue();
                try {
                    PdfUtil.showPdf(new ByteArrayInputStream(b));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(panel), ModelEnviroment.getMessageResolver().resolveMessage("messages.pdf.notReadable", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                }
            }
        };
        if (isPdfSet) {
            action.setEnabled(false);
        }
        JButton button = new JButton(action);
        button.setBounds(205, leftY, 250, 25);
        panel.add(button);
    }

    private void addServiceValueImage(final JPanel panel, int leftY, final ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable, int index, int imageIndex) {
        byte[] b = serviceValueModel == null ? null : serviceValueModel.getImageValue();
        boolean isImageSet = b == null || b.length == 0;
        AbstractAction action = new AbstractAction(isImageSet ? "..." : ModelEnviroment.getMessageResolver().resolveMessage("messages.image", new Serializable[0]) + " " + imageIndex){
            private static final long serialVersionUID = 5197811532313305803L;

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] b = serviceValueModel.getImageValue();
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(b));
                    Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
                    String ext = "jpg";
                    if (imageReaders.hasNext()) {
                        ImageReader reader = imageReaders.next();
                        ext = reader.getFormatName();
                    }
                    File file = File.createTempFile("service", "." + ext);
                    FileOutputStream fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)new ByteArrayInputStream(b), (OutputStream)fos);
                    fos.flush();
                    fos.close();
                    file.deleteOnExit();
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(file);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(panel), ModelEnviroment.getMessageResolver().resolveMessage("messages.image.notReadable", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                }
            }
        };
        if (isImageSet) {
            action.setEnabled(false);
        }
        JButton button = new JButton(action);
        button.setBounds(205, leftY, 250, 25);
        panel.add(button);
    }

    private void addServiceValueDate(JPanel panel, int leftY, ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable) {
        Date date;
        JFormattedTextField dateField = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        Long longValue = serviceValueModel == null ? null : serviceValueModel.getLongValue();
        Date date2 = date = longValue == null ? null : new Date(longValue);
        if (date != null) {
            dateField.setValue(date);
        }
        dateField.setFont(UIManager.getDefaults().getFont("TextField.font"));
        dateField.setBounds(205, leftY, 250, 25);
        dateField.setEditable(editable);
        panel.add(dateField);
    }

    private void addServiceValueMultipleListChoicePanel(final JPanel panel, int leftY, final ServiceValueModel serviceValueModel, final ServiceValueDescriptorModel serviceValueDescriptorModel, final boolean editable) {
        JButton button = new JButton(new AbstractAction(serviceValueDescriptorModel.getName()){
            private static final long serialVersionUID = 7686670055790065962L;
            private MultipleChoiceListPane multipleChoiceListPane;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parent = SwingUtils.findWindowParent(panel);
                CommonDialog commonDialog = new CommonDialog(parent, serviceValueDescriptorModel.getName(), Dialog.ModalityType.APPLICATION_MODAL){
                    private static final long serialVersionUID = -6795316775087147975L;

                    @Override
                    protected Action getOkAction() {
                        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                            private static final long serialVersionUID = 3515723619658151217L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (editable) {
                                    serviceValueModel.setSelectedMultipleListChoiceValues(multipleChoiceListPane.getSelectedString());
                                }
                                this.dispose();
                            }
                        };
                    }

                    @Override
                    protected Component getMainComponent() {
                        multipleChoiceListPane = new MultipleChoiceListPane(serviceValueModel.getMultipleListChoiceValues(), serviceValueModel.getSelectedMultipleListChoiceValues(), editable);
                        return new JScrollPane(multipleChoiceListPane);
                    }

                    @Override
                    protected Action getCancelAction() {
                        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
                            private static final long serialVersionUID = -7219708425448250834L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.dispose();
                            }
                        };
                    }
                };
                commonDialog.buildLayout();
                commonDialog.pack();
                SwingUtils.centerDialog(commonDialog, parent);
                commonDialog.setVisible(true);
            }
        });
        button.setBounds(205, leftY, 250, 25);
        panel.add(button);
    }

    private void addServiceValueComboBox(JPanel panel, int leftY, ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable) {
        DefaultComboBoxModel serviceValueComboBoxModel = this.getServiceValueComboBoxModel(serviceValueModel, serviceValueDescriptorModel);
        JComboBox serviceValueComboBox = new JComboBox(serviceValueComboBoxModel);
        serviceValueComboBox.setRenderer(new ServiceChoiceValueRenderer());
        if (editable) {
            StaticComboBoxListener staticComboBoxListener = new StaticComboBoxListener(this.relationModel);
            staticComboBoxListener.setServiceValueDescriptor(serviceValueDescriptorModel);
            staticComboBoxListener.setServiceValue(serviceValueModel);
            serviceValueComboBox.addItemListener(staticComboBoxListener);
        } else {
            serviceValueComboBox.setEnabled(editable);
        }
        serviceValueComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        serviceValueComboBox.setBounds(205, leftY, 250, 25);
        panel.add(serviceValueComboBox);
    }

    private DefaultComboBoxModel getServiceValueComboBoxModel(ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel) {
        StaticChoiceValueModel[] allStaticChoiceValues = new StaticChoiceValueModel[serviceValueDescriptorModel.countStaticChoiceValues()];
        int index = 0;
        StaticChoiceValueModel selectedItem = null;
        Iterator<StaticChoiceValueModel> staticChoiceValueIter = serviceValueDescriptorModel.iterateStaticChoiceValues();
        while (staticChoiceValueIter.hasNext()) {
            StaticChoiceValueModel staticChoiceValue;
            StaticChoiceValueModel staticChoiceValueModel;
            allStaticChoiceValues[index] = staticChoiceValueModel = staticChoiceValueIter.next();
            if (serviceValueModel != null && (staticChoiceValue = serviceValueModel.getStaticChoiceValue()) != null && staticChoiceValueModel.equals(staticChoiceValue)) {
                selectedItem = staticChoiceValueModel;
            }
            ++index;
        }
        DefaultComboBoxModel<StaticChoiceValueModel> serviceValueComboBoxModel = new DefaultComboBoxModel<StaticChoiceValueModel>(allStaticChoiceValues);
        serviceValueComboBoxModel.setSelectedItem(selectedItem);
        return serviceValueComboBoxModel;
    }

    private void addServiceValueCheckBox(JPanel panel, int leftY, ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable) {
        boolean isSelected = false;
        if (serviceValueModel != null && serviceValueModel.getBooleanValue().booleanValue()) {
            isSelected = true;
        }
        ServiceValueCheckboxAction serviceValueCheckboxAction = new ServiceValueCheckboxAction(this.relationModel, serviceValueModel, serviceValueDescriptorModel);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton trueCheckBox = new JRadioButton(serviceValueCheckboxAction);
        trueCheckBox.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]));
        trueCheckBox.setSelected(isSelected);
        trueCheckBox.setBounds(210, leftY, 60, 25);
        trueCheckBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        panel.add(trueCheckBox);
        buttonGroup.add(trueCheckBox);
        JRadioButton falseCheckBox = new JRadioButton(serviceValueCheckboxAction);
        falseCheckBox.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noA", new Serializable[0]));
        falseCheckBox.setSelected(!isSelected);
        falseCheckBox.setBounds(270, leftY, 100, 25);
        falseCheckBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        panel.add(falseCheckBox);
        buttonGroup.add(falseCheckBox);
        if (!editable) {
            trueCheckBox.setEnabled(editable);
            falseCheckBox.setEnabled(editable);
        }
    }

    private void addServiceValueTextField(JPanel panel, int leftY, ServiceValueModel serviceValueModel, ServiceValueDescriptorModel serviceValueDescriptorModel, boolean editable) {
        JTextField valueField = new JTextField(ServiceModelUtil.getServiceValue(serviceValueModel));
        valueField.setBounds(205, leftY, 250, 25);
        valueField.setEditable(false);
        panel.add(valueField);
        if (!serviceValueDescriptorModel.getEditable().booleanValue()) {
            return;
        }
        if (editable) {
            ServiceValueListener serviceValueListener = new ServiceValueListener(this.relationModel, serviceValueDescriptorModel, serviceValueModel, valueField);
            valueField.addMouseListener(serviceValueListener);
            valueField.addActionListener(serviceValueListener);
            valueField.addFocusListener(serviceValueListener);
        }
    }

    public JPanel getServiceValuePanel() {
        return this.serviceValuePanel;
    }
}

