/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.stop;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import java.io.Serializable;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

public class StopLocationActions {
    AddAndUpdateStopDialog addAndUpdateStopDialog;

    public StopLocationActions(AddAndUpdateStopDialog addAndUpdateStopDialog) {
        this.addAndUpdateStopDialog = addAndUpdateStopDialog;
    }

    public void selectLocationModel(String commandString) {
        this.addAndUpdateStopDialog.getLocationSelectMenu().hidemenu();
        if (!commandString.equals(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.newLocation", new Serializable[0]) + " ... ")) {
            this.loadLocationModel(this.getSelectedLocation(commandString));
        } else {
            this.setNullLocationFields();
        }
    }

    public void loadLocationModel(LocationModel location) {
        if (location == null) {
            return;
        }
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        this.addAndUpdateStopDialog.getLocationCountry().setText(locationWrapper.getCountry() == null ? "" : locationWrapper.getCountry().getIso3166_2());
        this.addAndUpdateStopDialog.getLocationStreet().setText(locationWrapper.getStreet());
        this.addAndUpdateStopDialog.getLocationPost().setText(locationWrapper.getPostcode());
        this.addAndUpdateStopDialog.getLocationCity().setText(locationWrapper.getCity());
        this.addAndUpdateStopDialog.getLocationNumber().setText(String.valueOf(locationWrapper.getHousenumber()));
        this.addAndUpdateStopDialog.getLocationNumberEx().setText(locationWrapper.getHousenumberExtension());
        if (locationWrapper.getGeoLocation() != null) {
            Coordinate coordinate = Wgs84Factory.INSTANCE.createCoordinate(locationWrapper.getGeoLocation().getCoordinate());
            this.addAndUpdateStopDialog.getLocationXField().setText(ClientFormUtil.numberToString(coordinate.getX(), 7));
            this.addAndUpdateStopDialog.getLocationYField().setText(ClientFormUtil.numberToString(coordinate.getY(), 7));
        }
    }

    private void setNullLocationFields() {
        this.addAndUpdateStopDialog.getLocationCountry().setText("");
        this.addAndUpdateStopDialog.getLocationStreet().setText("");
        this.addAndUpdateStopDialog.getLocationPost().setText("");
        this.addAndUpdateStopDialog.getLocationCity().setText("");
        this.addAndUpdateStopDialog.getLocationNumber().setText("");
        this.addAndUpdateStopDialog.getLocationNumberEx().setText("");
    }

    private LocationModel getSelectedLocation(String actionCommand) {
        for (LocationModel location : this.addAndUpdateStopDialog.getAllLocations()) {
            if (!LocationModelUtil.getAddressString(location).equals(actionCommand)) continue;
            return location;
        }
        return null;
    }
}

