/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.peppergis.client.communication.tour.TourRoutingContext;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.tour.OptimiseSettingDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.AbstractRoutingWithComboBoxAction;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimiseTourWithComboBoxAction
extends AbstractRoutingWithComboBoxAction<Map<TourModel, Tripel<OptimizationType, Integer, Integer>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimiseTourWithComboBoxAction.class);
    private static final long serialVersionUID = -6007482896321167979L;

    public OptimiseTourWithComboBoxAction(String name, OptimiseSettingDialog dialog, Component parent) {
        super(name, "Optimierte Touren - ", dialog, parent);
    }

    @Override
    protected Map<TourModel, Tripel<OptimizationType, Integer, Integer>> prepare() {
        HashMap<TourModel, Tripel<OptimizationType, Integer, Integer>> typeMap = new HashMap<TourModel, Tripel<OptimizationType, Integer, Integer>>();
        for (TourModel tour : this.dialog.getTours()) {
            typeMap.put(tour, this.dialog.adaptTourForOptimization(tour));
        }
        return typeMap;
    }

    private String getErrorMassage(LogisticException ex) {
        String localizedMessage;
        switch (localizedMessage = ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) {
            case "time windows are invalid": {
                return ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.invalidTimeWindow", new Serializable[0]);
            }
        }
        return localizedMessage;
    }

    @Override
    protected Tupel<String, Boolean> executeRouting(TourModel tour, TourRoutingContext tourRoutingContext, Map<TourModel, Tripel<OptimizationType, Integer, Integer>> t, int index) {
        boolean b;
        String msg = index + "/" + tourRoutingContext.getTotalCount() + " " + tour.getName() + " (" + TourModelUtil.countStopsOfTour(tour, false, false) + " Stopps)";
        LOGGER.info(msg);
        this.setMessage(msg, (int)((double)index * 100.0 / (double)tourRoutingContext.getTotalCount()));
        UndoManager undoManager = this.dialog.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        try {
            b = this.dialog.getTourCaller().optimizeTour(tour, t.get(tour), this.dialog.getRouteVehicleType(), this.dialog.getRouteType(), true, this.dialog.isSaved(), this.dialog.getModelEnviroment(), ((OptimiseSettingDialog)this.dialog).getAlgorithmType(), SwingUtils.findWindowParent(super.getParent()), tourRoutingContext);
        }
        catch (LogisticException ex) {
            String errorMsg = tour.getName() + " " + this.getErrorMassage(ex);
            LOGGER.error(errorMsg);
            return new Tupel<String, Boolean>(errorMsg, false);
        }
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.tourUpdate", new Serializable[]{tour.getName()}));
        return new Tupel<Object, Boolean>(null, b);
    }
}

