/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.CalculateType;
import de.datomino.peppergis.client.communication.tour.TourRoutingContext;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.AbstractRoutingWithComboBoxDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.AbstractRoutingWithComboBoxAction;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Component;
import java.util.Iterator;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateTourWithComboBoxAction
extends AbstractRoutingWithComboBoxAction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateTourWithComboBoxAction.class);
    private static final long serialVersionUID = -5341145554048687812L;

    public CalculateTourWithComboBoxAction(String name, AbstractRoutingWithComboBoxDialog dialog, Component parent) {
        super(name, "Berechnete Touren - ", dialog, parent);
    }

    @Override
    protected String prepare() {
        for (TourModel tour : this.dialog.getTours()) {
            if (this.dialog.isImportOrder()) {
                TourModelUtil.removeStartPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION, PoiType.AREA_DELIVERER_LOCATION));
                TourModelUtil.removeEndPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION, PoiType.AREA_DELIVERER_LOCATION));
                Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
                while (tourPartIter.hasNext()) {
                    TourModelUtil.sortWithImportOrder(tourPartIter.next());
                }
            }
            PoiModel unloadingPoi = null;
            if (this.dialog.getSelectedPoi() != null) {
                unloadingPoi = PoiModelUtil.createUnloadingPoi(this.dialog.getSelectedPoi());
            }
            PoiModel delivererPoi = TourModelUtil.getDelivererPoi(tour, this.dialog.getTourCaller());
            CalculateType type = this.dialog.getCalculateType();
            TourModelUtil.adaptCurrentCalculateType(tour, delivererPoi, unloadingPoi, type);
        }
        return null;
    }

    @Override
    protected Tupel<String, Boolean> executeRouting(TourModel tour, TourRoutingContext tourRoutingContext, String t, int index) {
        String msg = index + "/" + tourRoutingContext.getTotalCount() + " " + tour.getName() + " (" + TourModelUtil.countStopsOfTour(tour, false, false) + " Stopps)";
        LOGGER.info(msg);
        super.setMessage(msg, (int)((double)index * 100.0 / (double)tourRoutingContext.getTotalCount()));
        try {
            this.dialog.getModelEnviroment().getUndoManager().joinTransaction();
            this.dialog.getTourCaller().calculateTour(tour, this.dialog.getRouteVehicleType(), this.dialog.getRouteType(), this.dialog.isSaved(), this.dialog.getModelEnviroment(), OptimizationAlgorithmType.DEFAULT, true, tourRoutingContext);
            this.dialog.getModelEnviroment().getUndoManager().finishTransaction("");
        }
        catch (LogisticException ex) {
            String errorMsg = tour.getName() + " " + ex.getLocalizedMessage();
            LOGGER.error(errorMsg);
            return new Tupel<String, Boolean>(errorMsg, false);
        }
        return new Tupel<Object, Boolean>(null, false);
    }
}

