/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.printer;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.PrintingObject;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.print.DefaultPrintingInformation;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.print.TourInfoPrintType;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tripel;

public class TourPrintingInformation
extends DefaultPrintingInformation<TourModel> {
    public TourPrintingInformation(TourModel tour, String imagePath, Format imageFormat, ModelEnviroment modelEnviroment) {
        this((List<TourModel>)CollectionUtil.buildArrayList(tour), imagePath, imageFormat, modelEnviroment);
    }

    public TourPrintingInformation(List<TourModel> tours, String imagePath, Format imageFormat, ModelEnviroment modelEnviroment) {
        super(tours, imagePath, imageFormat, modelEnviroment);
    }

    public void initialize(PrinterInformation printerInformation) {
        TableRowEntity header = new TableRowEntity();
        Map<PrintPropertyKey, Serializable> tourProperties = this.modelEnviroment.getPrintProperties().getTourProperties();
        super.addTableHeaderForTour(tourProperties, header);
        List<Tripel<Integer, String, Color>> tableHeader = header.getHeader();
        for (TourModel tour : super.getOs()) {
            PrintingObject printingObject = new PrintingObject(null, null);
            String info = TourModelUtil.getTourInformation(tour, printerInformation.getNameRenderingType());
            List<String> lines = this.extractLines(printerInformation.getSpecialMessage());
            if (lines != null) {
                info = info + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0]) + "\n";
                for (String line : lines) {
                    info = info + line + "\n";
                }
                info = info + "\n";
            }
            List<Tripel<List<String>, List<String>, Color>> table = this.getStopsPrintingInformation(tour, Color.BLACK, tourProperties);
            TourInfoPrintType tourInfoPrintType = (TourInfoPrintType)printerInformation.getNamePrintType();
            switch (tourInfoPrintType) {
                case TOP: {
                    this.setTop(true);
                    printingObject.setText(info);
                    printingObject.setHeader(tableHeader);
                    printingObject.setTable(table);
                    break;
                }
                case DOWN: {
                    this.setDown(true);
                    printingObject.setText(info);
                    printingObject.setHeader(tableHeader);
                    printingObject.setTable(table);
                    break;
                }
                case NONE: {
                    printingObject.setHeader(null);
                    printingObject.setTable(null);
                    break;
                }
                case NO_LIST: {
                    this.setTop(true);
                    printingObject.setText(info);
                    printingObject.setHeader(null);
                    printingObject.setTable(null);
                    break;
                }
                case ONLY_LIST: {
                    printingObject.setHeader(tableHeader);
                    printingObject.setTable(table);
                }
            }
            this.printingObjects.add(printingObject);
        }
    }

    private List<Tripel<List<String>, List<String>, Color>> getStopsPrintingInformation(TourModel tour, Color color, Map<PrintPropertyKey, Serializable> tourProperties) {
        ArrayList<Tripel<List<String>, List<String>, Color>> table = new ArrayList<Tripel<List<String>, List<String>, Color>>();
        int index = 1;
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
            while (stopIter.hasNext()) {
                StopModel stop = stopIter.next();
                if (stop == null) continue;
                TableRowEntity rowEntity = new TableRowEntity();
                StopModelUtil.getPrintingInformation(stop, color, rowEntity, tourProperties);
                Tripel<List<String>, List<String>, Color> row = rowEntity.getRow(color);
                row.getElement1().add(0, String.valueOf(index));
                table.add(row);
                ++index;
            }
        }
        return table;
    }
}

