/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.printer;

import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrintAction;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionPane;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TourInfoPrintType;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.print.TourManagerPrinter;
import de.datomino.peppergis.tourmanager.print.TourManagerPrinterImpl;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Color;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.KeyStroke;
import org.ktde.util.datatypes.Tupel;

public class PrintSelectedToursAction
extends AbstractManagerPrintAction<TourModel> {
    private static final long serialVersionUID = -9086953323308238174L;
    private boolean withPoi;
    private ManagerPrintOptionPane printOptionPane;

    public PrintSelectedToursAction(TourMapGui tourMapGui, String title, boolean withPoi) {
        super(title, AbstractManagerPrintAction.PrintActionName.TOUR, new TourManagerPrinterImpl(tourMapGui), tourMapGui);
        this.withPoi = withPoi;
        if (withPoi) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 128));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 128));
        }
    }

    @Override
    protected Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> print() throws Exception {
        TourManagerPrinter tourPrinter = (TourManagerPrinter)this.managerPrinter;
        ErrorMessage errorMessage = null;
        InputStream inputStream = null;
        Map<TourModel, Color> selectedToursWithColor = ((TourMapGui)this.mapGui).getSelectedToursWithColor();
        String tourAndDeliverer = "";
        String printType = ModelEnviroment.getProperties().getProperty("tour.print.type");
        if (selectedToursWithColor.isEmpty()) {
            errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.noTour", new Serializable[0]));
        } else if (printType != null && printType.equals("SAAR")) {
            inputStream = tourPrinter.printSelectedTourSaarbruecken(this.mapGui.getNavigatorPanel(), selectedToursWithColor);
            if (inputStream == null) {
                errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.error.createpdf", new Serializable[0]));
            }
        } else {
            if (this.printOptionPane == null) {
                this.printOptionPane = super.createPrintOptionPane(true, true, false);
            }
            PrinterInformation printerInformation = super.getPrintingInformation(this.printOptionPane);
            printerInformation.setWithPoi(this.withPoi);
            if (printerInformation != null && printerInformation.getPrintType() != null) {
                switch (printerInformation.getPrintType()) {
                    case ONE_PAGE: {
                        inputStream = tourPrinter.printSelectedTours(this.mapGui.getNavigatorPanel(), selectedToursWithColor, printerInformation);
                        break;
                    }
                    case MULTIPLE_PAGES: {
                        inputStream = tourPrinter.printSelectedToursInPages(this.mapGui.getNavigatorPanel(), selectedToursWithColor, printerInformation);
                        break;
                    }
                }
                if (inputStream == null) {
                    errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.error.createpdf", new Serializable[0]));
                }
            }
        }
        if (selectedToursWithColor.size() == 1) {
            TourModel tourModel = selectedToursWithColor.keySet().iterator().next();
            String delivererName = tourModel.getDeliverer() == null ? "" : tourModel.getDeliverer().getName();
            tourAndDeliverer = tourModel.getName() + "_" + delivererName;
        }
        return new Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages>(Collections.singletonList(new Tupel<String, InputStream>(tourAndDeliverer, inputStream)), errorMessage == null ? new ErrorMessages() : new ErrorMessages(errorMessage));
    }

    @Override
    protected Tupel<InfoPrintPosition, String> getTypeTupel() {
        PrintProperties printProperties = this.mapGui.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> properties = printProperties.getTourProperties();
        TourInfoPrintType tourNamePrintType = (TourInfoPrintType)((Object)properties.get(PrintParameterKey.INFO_POSITION));
        String tourNameRenderingType = (String)((Object)properties.get(PrintParameterKey.INFO_PATTERN));
        return new Tupel<InfoPrintPosition, String>(tourNamePrintType, tourNameRenderingType);
    }

    @Override
    protected String[] getButtonItems() {
        return new String[]{ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.onepage", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.multipage", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])};
    }

    @Override
    protected PrinterInformation.PrintType getPrintType(int select) {
        switch (select) {
            case 0: {
                return PrinterInformation.PrintType.MULTIPLE_PAGES;
            }
            case 1: {
                return PrinterInformation.PrintType.ONE_PAGE;
            }
        }
        return null;
    }

    @Override
    protected String getPropertyPrefix() {
        return "tour";
    }
}

