/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.filter;

import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.tourmanager.gui.filter.StopFilterSettingDialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class StopFilterSettingActions {
    private StopFilterSettingDialog filterSettingDialog;
    private StopFilterEntity stopFilterEntity;
    private Action applyFilterActions;
    private Action storeFilterAction;
    private Action deleteFilterAction;

    public StopFilterSettingActions(StopFilterSettingDialog filterSettingDialog, StopFilterEntity filterEntity) {
        this.filterSettingDialog = filterSettingDialog;
        this.stopFilterEntity = filterEntity;
        this.initialized();
    }

    private void initialized() {
        this.applyFilterActions = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.apply", new Serializable[0])){
            private static final long serialVersionUID = 713388733378610012L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopFilterSettingActions.this.applyFilter();
            }
        };
        this.storeFilterAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 3815933491692414618L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopFilterSettingActions.this.storeFilter();
            }
        };
        this.deleteFilterAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -1424261999874349580L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopFilterSettingActions.this.deleteFilter();
            }
        };
    }

    public void applyFilter() {
        boolean result = this.storeFilter();
        if (result) {
            this.filterSettingDialog.getTourManagerCalendarGui().getTabbedPane().setSelectedComponent(this.filterSettingDialog.getTourManagerCalendarGui().getTourMapGui());
            this.filterSettingDialog.getTourManagerCalendarGui().getTourMapGui().applyStopFilterOnMap(this.stopFilterEntity);
        }
    }

    public boolean storeFilter() {
        if (this.qualifyFilter()) {
            if (!this.isFilterExists()) {
                this.filterSettingDialog.getTourManagerCalendarGui().getFilters().add(this.stopFilterEntity);
            }
            this.updateFilterMenu();
            return true;
        }
        return false;
    }

    private boolean qualifyFilter() {
        int b;
        if (this.stopFilterEntity.isNull() && (b = JOptionPane.showConfirmDialog(this.filterSettingDialog, ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.applianceConfirm", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2)) == 2) {
            return false;
        }
        if (this.stopFilterEntity.getPois().size() > 0) {
            this.stopFilterEntity.setStartTime(null);
            this.stopFilterEntity.setEndTime(null);
            this.stopFilterEntity.setDeliverers(null);
            this.stopFilterEntity.setServices(null);
        }
        return true;
    }

    public void deleteFilter() {
        if (this.isFilterExists()) {
            this.filterSettingDialog.getTourManagerCalendarGui().getFilters().remove(this.stopFilterEntity);
        }
        this.updateFilterMenu();
    }

    private boolean isFilterExists() {
        boolean isExists = false;
        for (FilterEntity filter : this.filterSettingDialog.getTourManagerCalendarGui().getFilters()) {
            if (!filter.getKey().equals(this.stopFilterEntity.getKey())) continue;
            isExists = true;
        }
        return isExists;
    }

    private void updateFilterMenu() {
        this.filterSettingDialog.dispose();
        this.filterSettingDialog.getTourManagerCalendarGui().getControlGui().loadFilterSubMenu();
    }

    public Action getApplyFilterActions() {
        return this.applyFilterActions;
    }

    public Action getStoreFilterAction() {
        return this.storeFilterAction;
    }

    public Action getDeleteFilterAction() {
        return this.deleteFilterAction;
    }
}

