/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.filter;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.tourmanager.gui.filter.StopFilterSettingDialog;
import de.datomino.peppergis.tourmanager.gui.filter.UnsortedStopFilterSettingDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class CreateFilterDialogAction
extends AbstractAction {
    private static final long serialVersionUID = 7804085871774735907L;
    private FilterEntity filterEntity;
    private ModelEnviroment modelEnviroment;
    private LegendType type;
    private TourManagerCalendarGui tourManager;

    public CreateFilterDialogAction(FilterEntity filterEntity, String key, LegendType type, ModelEnviroment modelEnviroment, TourManagerCalendarGui tourManager) {
        super(key);
        this.filterEntity = filterEntity;
        this.modelEnviroment = modelEnviroment;
        this.tourManager = tourManager;
        this.type = type;
        switch (this.type) {
            case STOP: 
            case UNSORTEDSTOP: {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 8192));
                break;
            }
            case PARCEL: {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 8192));
                break;
            }
            case SUBSCRIPTION: {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 8192));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AreaCaller areaCaller = this.modelEnviroment.getAllCaller().getAreaCaller();
        switch (this.type) {
            case STOP: {
                StopFilterSettingDialog.createAndShowDialog(this.tourManager, (StopFilterEntity)this.filterEntity);
                break;
            }
            case PARCEL: {
                throw new RuntimeException("should not be called");
            }
            case SUBSCRIPTION: {
                throw new RuntimeException("should not be called");
            }
            case UNSORTEDSTOP: {
                UnsortedStopFilterSettingDialog.createAndShowDialog(this.tourManager, (StopFilterEntity)this.filterEntity);
            }
        }
    }
}

