/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.exporter;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportType;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class ExportTourAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = -3145759747547943865L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private ModelEnviroment modelEnviroment;
    private TourExportType tourExportType;

    public ExportTourAction(TourManagerCalendarGui tourManagerCalendarGui, ModelEnviroment modelEnviroment, String name, TourExportType tourExportType) {
        super(name, SwingUtils.findWindowParent(tourManagerCalendarGui), "csv");
        this.modelEnviroment = modelEnviroment;
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.tourExportType = tourExportType;
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
        Map<TourModel, Tupel<Integer, Integer>> selectedToursInTable = this.tourManagerCalendarGui.getPlanTableGui().getSelectedToursInTable();
        TourExportDto tourExportDto = this.modelEnviroment.getAllCaller().getExportCaller().exportTours(selectedToursInTable.keySet(), this.tourExportType);
        return new Tupel<Map<String, byte[]>, ErrorMessages>(tourExportDto.getContent(), tourExportDto.getErrorMessages());
    }
}

