/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.exporter;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.dto.exporter.TourExportReportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.util.message.Message;
import de.datomino.util.swing.ErrorMessageDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ExportSelectedToursInMapToServerAction
extends AbstractAction {
    private static final long serialVersionUID = -1318856834188385307L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private ModelEnviroment modelEnviroment;

    public ExportSelectedToursInMapToServerAction(TourManagerCalendarGui tourManagerCalendarGui, ModelEnviroment modelEnviroment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.exporter.exportToursOnMapRemote", new Serializable[0]));
        this.modelEnviroment = modelEnviroment;
        this.tourManagerCalendarGui = tourManagerCalendarGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block4: {
            Map<TourModel, Color> selectedToursInMap = this.tourManagerCalendarGui.getTourMapGui().getSelectedToursWithColorMap();
            try {
                BufferedImage image;
                TourExportReportDto tourExportDto = this.modelEnviroment.getAllCaller().getExportCaller().exportToursToServer(selectedToursInMap.keySet());
                if (!tourExportDto.getErrorMessages().hasErrors()) break block4;
                try {
                    image = ImageIO.read(ExportSelectedToursInMapToServerAction.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(null, ModelEnviroment.getMessageResolver(), tourExportDto.getErrorMessages(), new Message("messages.default.error"), new Message("messages.default.ok"), image);
                errorMessageDialog.setVisible(true);
            }
            catch (ClientExportException ex) {
                JOptionPane.showMessageDialog(this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), ex.getMessage(), 0);
            }
        }
    }
}

