/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.exporter;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.ktde.util.datatypes.Tupel;

public class ExportAreaTourAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = 6665374619254031537L;
    private ModelEnviroment modelEnviroment;

    public ExportAreaTourAction(Window parent, ModelEnviroment modelEnviroment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.action.exportAreaTours", new Serializable[0]), parent, "xml");
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o1) throws ClientExportException {
        DefaultListModel<AreaTourModel> dlm = new DefaultListModel<AreaTourModel>();
        Collection<AreaTourModel> areaTours = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllAreaTours();
        for (AreaTourModel areaTour : areaTours) {
            dlm.addElement(areaTour);
        }
        JList list = new JList(dlm);
        list.setSelectionMode(2);
        final ListCellRenderer origRenderer = list.getCellRenderer();
        list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object nValue = value;
                if (value instanceof AreaTourModel) {
                    AreaTourModel areaTour = (AreaTourModel)value;
                    StringBuilder sb = new StringBuilder(areaTour.getAreaObject().getShortcut()).append(" - ");
                    switch (areaTour.getAreaTourType().getAreaObjectType()) {
                        case LETTER: {
                            sb.append("Briefe");
                            break;
                        }
                        case PARCEL: {
                            sb.append("Geb\u00e4ude");
                            break;
                        }
                        case PARCEL_WITH_LETTER: {
                            sb.append("Geb\u00e4ude und Briefe");
                            break;
                        }
                        case PARCEL_WITHOUT_SUBSCRIPTION: {
                            sb.append("Geb\u00e4ude ohne Abonnenten");
                            break;
                        }
                        case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                            sb.append("Geb\u00e4ude ohne Abonnenten mit Briefen");
                            break;
                        }
                        case SUBSCRIPTION: {
                            sb.append("Abonnenten");
                            break;
                        }
                        case SUBSCRIPTION_WITH_LETTER: {
                            sb.append("Abonnenten mit Briefen");
                            break;
                        }
                        case PARCEL_SUBSCRIPTION: {
                            sb.append("Geb\u00e4ude und Abonnenten");
                            break;
                        }
                        case PARCEL_SUBSCRIPTION_LETTER: {
                            sb.append("Geb\u00e4ude und Abonnenten und Briefen");
                        }
                    }
                    nValue = sb.toString();
                }
                return origRenderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
            }
        });
        int d = JOptionPane.showConfirmDialog(this.getParent(), new JScrollPane(list), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
        if (d == 0) {
            Object[] selectedValues = list.getSelectedValues();
            ArrayList<AreaTourModel> selected = new ArrayList<AreaTourModel>(selectedValues.length);
            for (Object o : selectedValues) {
                selected.add((AreaTourModel)o);
            }
            TourExportDto tourExportDto = this.modelEnviroment.getAllCaller().getExportCaller().exportAreaTours(selected, TourExportFormat.XML);
            return new Tupel<Map<String, byte[]>, ErrorMessages>(tourExportDto.getContent(), tourExportDto.getErrorMessages());
        }
        return null;
    }
}

