/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.tourmanager.gui.map.LocationEditorMapPanel;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

public class EditCoordinateOnMapAction
extends AbstractAction {
    private static final long serialVersionUID = 4980490968899989843L;
    private AddAndUpdateStopDialog parent;
    private ModelEnviroment modelEnviroment;

    public EditCoordinateOnMapAction(AddAndUpdateStopDialog parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        this.parent = parent;
        this.modelEnviroment = parent.getModelEnviroment();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.createCoordinateMapDialog();
        }
        catch (IOException e1) {
            new ErrorMessagesDialog("properties error", this.parent);
        }
    }

    private void createCoordinateMapDialog() throws IOException {
        Coordinate startCoordinate = this.getStartCoordinate();
        if (startCoordinate == null) {
            new ErrorMessagesDialog(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.error.noEditable", new Serializable[0]), this.parent);
            return;
        }
        int width = (int)((double)this.parent.getWidth() * 1.5);
        LocationEditorMapPanel coordinateMapPanel = new LocationEditorMapPanel(startCoordinate, this.modelEnviroment);
        coordinateMapPanel.getNavigatorPanel().translate(width / 2, this.parent.getHeight() / 2);
        JDialog coordinateMapDialog = new JDialog();
        try {
            coordinateMapDialog.setIconImage(ImageIO.read(EditCoordinateOnMapAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        coordinateMapDialog.getContentPane().add((Component)coordinateMapPanel, "Center");
        coordinateMapDialog.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]) + " " + this.parent.getStopModel().getName());
        coordinateMapDialog.setPreferredSize(new Dimension(width, this.parent.getHeight()));
        coordinateMapDialog.setModal(true);
        coordinateMapDialog.setDefaultCloseOperation(2);
        coordinateMapDialog.pack();
        SwingUtils.centerDialog(coordinateMapDialog, this.parent);
        coordinateMapDialog.setVisible(true);
        Coordinate newCoordinate = coordinateMapPanel.getCoordinate();
        if (GeoUtil.areSamedPoints(startCoordinate, newCoordinate, (Double)1.0)) {
            return;
        }
        this.syncChange(newCoordinate);
    }

    private Coordinate getStartCoordinate() {
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.parent.getStopModel().getLocation());
        if (wrapper != null) {
            double y;
            ImmutablePoint geoLocation = wrapper.getGeoLocation();
            Coordinate coordinate = geoLocation == null ? Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0) : geoLocation.getCoordinate();
            double x = coordinate.getX();
            boolean error = false;
            if (Double.isNaN(x) || Double.isInfinite(x)) {
                x = 0.0;
                error = true;
            }
            if (Double.isNaN(y = coordinate.getY()) || Double.isInfinite(y)) {
                y = 0.0;
                error = true;
            }
            Coordinate correctedCoord = error ? coordinate.getFactory().createCoordinate(x, y) : coordinate;
            return Wgs84Factory.INSTANCE.createCoordinate(correctedCoord).correctToEarth();
        }
        return null;
    }

    private void syncChange(Coordinate newCoordinate) {
        StopModel stop = this.parent.getStopModel();
        ImmutablePoint newGeoLocation = ImmutableGeoObjectFactory.createImmutablePoint(newCoordinate);
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        int d = JOptionPane.showConfirmDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.location.changeOneOrAll", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 1);
        switch (d) {
            case 0: {
                TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
                LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
                LogisticLocationDto<Long> location = new LogisticLocationDto<Long>(wrapper.getId(), null, null, wrapper.getCountry(), wrapper.getPostcode(), wrapper.getCity(), wrapper.getDistrict(), wrapper.getStreet(), wrapper.getHousenumber(), wrapper.getHousenumberExtension());
                Collection<LocationModel> locations = tourCaller.fetchLocationsWithSameAddress(location);
                for (LocationModel l : locations) {
                    LocationWrapper lWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(l);
                    if (GeoUtil.areSamedPoints(newGeoLocation, lWrapper.getGeoLocation(), (Double)1.0)) continue;
                    lWrapper.setGeoLocation(newGeoLocation);
                    l.setFootSegment(null);
                    l.setMotorSegment(null);
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        LocationWrapper lWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
        if (lWrapper != null && !GeoUtil.areSamedPoints(newGeoLocation, lWrapper.getGeoLocation(), (Double)1.0)) {
            lWrapper.setGeoLocation(newGeoLocation);
            stop.getLocation().setFootSegment(null);
            stop.getLocation().setMotorSegment(null);
            undoManager.finishTransaction("Einsatz der neuen Koordinate: " + newGeoLocation.toString());
        }
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            e.printStackTrace();
        }
        if (this.parent.isParentUndoManagerStarted()) {
            undoManager.startTransaction();
        }
        this.parent.getAddAndUpdateStopActions().getStopLocationActions().loadLocationModel(stop.getLocation());
    }
}

