/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.handler.ShowParcelAction;
import de.datomino.peppergis.client.manager.handler.ShowSubscriptionAction;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.handler.action.filter.CreateFilterDialogAction;
import de.datomino.peppergis.tourmanager.handler.action.geotracking.GeoTrackSettingAction;
import de.datomino.peppergis.tourmanager.handler.action.printer.PrintLegendAction;
import de.datomino.peppergis.tourmanager.handler.action.printer.PrintScreenshotAction;
import de.datomino.peppergis.tourmanager.handler.action.printer.PrintSelectedToursAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.ChangeStopSymbolAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.ShowUnsortedStopsAction;
import de.datomino.peppergis.tourmanager.handler.action.tour.ClearSelectedToursAction;
import de.datomino.peppergis.tourmanager.handler.action.tour.ShowAllToursAction;
import de.datomino.peppergis.tourmanager.handler.action.tour.ShowSelectedToursAction;
import de.datomino.peppergis.tourmanager.handler.action.tour.ShowToursOfSelectedDayAction;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.collection.CollectionUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.ToggleAction;

public class TourMapActions {
    private TourMapGui tourMapGui;
    private Action clearSelectedToursAction;
    private Action showSelectedToursAction;
    private Action showAllToursAction;
    private Action showToursOfSelectedDayAction;
    private Action printSelectedToursAction;
    private Action printToursWithPoiAction;
    private Action printToursWithoutPoiAction;
    private Action printScreenShotAction;
    private Action changeStopSymbolAction;
    private Action removeFilterOnMapAction;
    private Action searchLocationAction;
    private ToggleAction showUnsortedStopsAction;
    private Action removeStopFromTourAction;
    private Action showSubscriptionAction;
    private Action showParcelAction;
    private Action printLegendWithPoiAction;
    private Action printLegendWithoutPoiAction;
    private Action geoTrackingAction;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private Action showPostcodeAction;

    public TourMapActions(TourMapGui touMapGui, TourManagerCalendarGui tourManagerCalendarGui) {
        this.tourMapGui = touMapGui;
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.initialize();
    }

    private void initialize() {
        this.clearSelectedToursAction = new ClearSelectedToursAction(this.tourMapGui);
        this.showSelectedToursAction = new ShowSelectedToursAction(this.tourManagerCalendarGui);
        this.showAllToursAction = new ShowAllToursAction(this.tourManagerCalendarGui);
        this.showToursOfSelectedDayAction = new ShowToursOfSelectedDayAction(this.tourManagerCalendarGui, this.tourManagerCalendarGui.getModelEnviroment());
        this.printToursWithPoiAction = new PrintSelectedToursAction(this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.pickuprouteWithPoi", new Serializable[0]), true);
        this.printToursWithoutPoiAction = new PrintSelectedToursAction(this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.pickuprouteWithoutPoi", new Serializable[0]), false);
        this.printScreenShotAction = new PrintScreenshotAction(this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.screenshot", new Serializable[0]));
        this.printLegendWithPoiAction = new PrintLegendAction(this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.deliveryrouteWithPoi", new Serializable[0]), true);
        this.printLegendWithoutPoiAction = new PrintLegendAction(this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.print.deliveryrouteWithoutPoi", new Serializable[0]), false);
        this.showParcelAction = new ShowParcelAction(this.tourMapGui);
        this.showSubscriptionAction = new ShowSubscriptionAction(this.tourMapGui);
        this.showPostcodeAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])){
            private static final long serialVersionUID = 6727293822313258498L;

            @Override
            public void turnOn() {
                if (TourMapActions.this.tourMapGui.getPostcodeAreaLayer() == null) {
                    AreaLayerModel postcodeLayer = null;
                    String defaultLayerName = TourMapActions.this.tourManagerCalendarGui.getProperties().getProperty("postcodeAreaLayer");
                    AreaCaller areaCaller = TourMapActions.this.tourManagerCalendarGui.getModelEnviroment().getAllCaller().getAreaCaller();
                    AreaObjectGenInfoDiscriminator[] discriminators = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE};
                    Collection<AreaLayerModel> postcodeLayers = areaCaller.getAreaLayersForType(discriminators);
                    if (defaultLayerName != null) {
                        for (AreaLayerModel areaLayer : postcodeLayers) {
                            if (!areaLayer.getDisplayname().equals(defaultLayerName)) continue;
                            postcodeLayer = areaLayer;
                            break;
                        }
                    }
                    if (postcodeLayer == null) {
                        AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(TourMapActions.this.tourManagerCalendarGui.getModelEnviroment(), false, discriminators);
                        if (areaLayerComboBox.getModel().getSize() > 0) {
                            areaLayerComboBox.setSelectedIndex(0);
                        }
                        int d = JOptionPane.showConfirmDialog(TourMapActions.this.tourManagerCalendarGui, areaLayerComboBox, "Bitte PLZ-Layer ausw\u00e4hlen: ", 2);
                        switch (d) {
                            case 0: {
                                postcodeLayer = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
                                break;
                            }
                        }
                    }
                    if (postcodeLayer != null) {
                        TourMapActions.this.tourMapGui.setPostcodeAreaLayer(postcodeLayer);
                    }
                }
                if (TourMapActions.this.tourMapGui.getPostcodeAreaLayer() == null) {
                    this.setSelected(false);
                } else {
                    TourMapActions.this.tourMapGui.getPostcodeLayerRenderer().setActive(true);
                    TourMapActions.this.tourMapGui.getNavigatorPanel().repaint(10L);
                }
            }

            @Override
            public void turnOff() {
                TourMapActions.this.tourMapGui.getPostcodeLayerRenderer().setActive(false);
            }
        };
        this.searchLocationAction = new SearchLocationAction(this.tourMapGui, this.tourMapGui.getNavigatorPanel(), this.tourManagerCalendarGui.getModelEnviroment(), false, false){
            private static final long serialVersionUID = -4352659602604593024L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourMapActions.this.tourManagerCalendarGui.getTabbedPane().setSelectedComponent(TourMapActions.this.tourManagerCalendarGui.getTourMapGui());
                super.actionPerformed(e);
            }
        };
        this.changeStopSymbolAction = new ChangeStopSymbolAction(this.tourMapGui);
        this.removeFilterOnMapAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.removefrommap", new Serializable[0])){
            private static final long serialVersionUID = -9169311427594403850L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourMapActions.this.tourMapGui.removeFiltersOnMap();
            }
        };
        this.removeFilterOnMapAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 8192));
        this.showUnsortedStopsAction = new ShowUnsortedStopsAction(this.tourManagerCalendarGui);
        this.removeStopFromTourAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.removefromroute", new Serializable[0])){
            private static final long serialVersionUID = 4519963724820006148L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourMapActions.this.tourMapGui.removeSelectedStopsFromTour();
            }
        };
        this.geoTrackingAction = new GeoTrackSettingAction(this.tourMapGui);
    }

    public Action getClearSelectedToursAction() {
        return this.clearSelectedToursAction;
    }

    public Action getShowSelectedToursAction() {
        return this.showSelectedToursAction;
    }

    public Action getShowAllToursAction() {
        return this.showAllToursAction;
    }

    public Action getShowToursOfSelectedDayAction() {
        return this.showToursOfSelectedDayAction;
    }

    public Action getPrintSelectedToursAction() {
        return this.printSelectedToursAction;
    }

    public Action getPrintToursWithPoiAction() {
        return this.printToursWithPoiAction;
    }

    public Action getPrintToursWithoutPoiAction() {
        return this.printToursWithoutPoiAction;
    }

    public Action getPrintScreenShotAction() {
        return this.printScreenShotAction;
    }

    public Action getChangeStopSymbolAction() {
        return this.changeStopSymbolAction;
    }

    public Action getShowGeoTrackingAction() {
        return this.geoTrackingAction;
    }

    public CreateFilterDialogAction getFilterAction(FilterEntity filterEntity, LegendType type) {
        String key = "";
        switch (type) {
            case STOP: 
            case UNSORTEDSTOP: {
                key = "Neuer Stopp-Filter ...";
                break;
            }
            case SUBSCRIPTION: {
                key = "Neuer Abonnenten-Filter ...";
                break;
            }
            case PARCEL: {
                key = "Neuer Geb\u00e4ude-Filter ...";
            }
        }
        if (filterEntity != null) {
            key = filterEntity.getKey();
        }
        return new CreateFilterDialogAction(filterEntity, key, type, this.tourManagerCalendarGui.getModelEnviroment(), this.tourManagerCalendarGui);
    }

    public Action getRemoveFilterOnMapAction() {
        return this.removeFilterOnMapAction;
    }

    public Action getSearchLocationAction() {
        return this.searchLocationAction;
    }

    public Action getShowUnsortedStopsAction() {
        return this.showUnsortedStopsAction;
    }

    public Action getRemoveStopFromTourAction() {
        return this.removeStopFromTourAction;
    }

    public Action getShowParcelAction() {
        return this.showParcelAction;
    }

    public Action getShowSubscriptionAction() {
        return this.showSubscriptionAction;
    }

    public Action getPrintLegendWithPoiAction() {
        return this.printLegendWithPoiAction;
    }

    public Action getPrintLegendWithoutPoiAction() {
        return this.printLegendWithoutPoiAction;
    }

    public Action getShowPostcodeAction() {
        return this.showPostcodeAction;
    }

    public JMenu getChangeTourOfStopsItem() {
        JMenu memu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.changeTour", new Serializable[0]));
        for (TourModel tour : this.tourMapGui.getToursWithColor().keySet()) {
            final TourPartModel tourPart = tour.getTourPartAt(tour.countTourParts() - 1);
            memu.add(new AbstractAction(tour.getName()){
                private static final long serialVersionUID = 196780229010121515L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    UndoManager undoManager = TourMapActions.this.tourMapGui.getModelEnviroment().getUndoManager();
                    undoManager.startTransaction();
                    for (StopModel stop : TourMapActions.this.tourMapGui.getSelectedStopsForRemove()) {
                        stop.setTourPart(tourPart);
                        stop.setEstimatedTimeOfArrival(null);
                        stop.setStreetMileageMetersFromTourStart(null);
                        stop.setStopStatus(null);
                    }
                    TourMapActions.this.tourMapGui.getSelectedStopsForRemove().clear();
                    TourMapActions.this.tourMapGui.repaintGui(true);
                    undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.changeTour.finished", new Serializable[]{tourPart.getTour().getName()}));
                    undoManager.startTransaction();
                }
            });
        }
        return memu;
    }

    public Action getDuplicateStopsAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0])){
            private static final long serialVersionUID = -6649448098250869953L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = TourMapActions.this.tourMapGui.getModelEnviroment().getUndoManager();
                undoManager.startTransaction();
                HashSet<StopModel> stops = new HashSet<StopModel>(TourMapActions.this.tourMapGui.getSelectedStopsForRemove());
                stops.addAll(TourMapActions.this.tourMapGui.getSelectedStopsForAdd());
                ArrayList<StopModel> newStops = new ArrayList<StopModel>(stops.size());
                boolean canceled = false;
                for (StopModel stop : stops) {
                    StopModel clone = this.cloneStop(stop);
                    if (clone == null) {
                        canceled = true;
                        break;
                    }
                    newStops.add(clone);
                }
                if (canceled) {
                    undoManager.rollbackTransaction();
                } else {
                    Set<StopModel> unsortedStops = TourMapActions.this.tourManagerCalendarGui.getUnsortedStops();
                    unsortedStops.addAll(newStops);
                    TourMapActions.this.tourMapGui.loadUnsortedStopsOnMap();
                    if (!TourMapActions.this.showUnsortedStopsAction.isSelected()) {
                        TourMapActions.this.showUnsortedStopsAction.actionPerformed(null);
                    }
                    TourMapActions.this.tourMapGui.repaintGui(false);
                    undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.duplicate", "gui.stop.stops"), new String[0]));
                }
                undoManager.startTransaction();
            }

            private StopModel cloneStop(StopModel stop) {
                String cloneName = JOptionPane.showInputDialog(TourMapActions.this.tourMapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.newStop", new Serializable[0]), stop.getName());
                if (cloneName == null) {
                    return null;
                }
                StopModel clone = StopModelUtil.cloneStop(stop);
                clone.setName(cloneName);
                return clone;
            }
        };
    }
}

