/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tracking;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticServiceRouteDto;
import de.datomino.logistic.dto.LogisticServiceRouteEntryDto;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.peppergis.util.TimeComparator;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourTrackingResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourTrackingResult.class);
    private static Integer DELAY_TOLERANCE = 900;
    private TourModel tour;
    private List<GeoTrackingModel> geoTrackings;
    private ModelEnviroment modelEnviroment;
    private List<TourTrackingObject> tourTrackingList;
    private int intervall = -1;
    private Map<Tupel<StopModel, StopModel>, Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto>> stopRouteMap = new HashMap<Tupel<StopModel, StopModel>, Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto>>();

    public TourTrackingResult(TourModel tour, ModelEnviroment modelEnviroment) {
        this.tour = tour;
        this.modelEnviroment = modelEnviroment;
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        this.geoTrackings = new ArrayList<GeoTrackingModel>(tourCaller.getGeoTrackings(null, CollectionUtil.buildArrayList(this.tour), CollectionUtil.buildHashSet(GeoTrackingType.values()), 0L, null));
        this.tour.addValueChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent e) {
                TourModelImpl.TourModelEnum property = (TourModelImpl.TourModelEnum)e.getProperty();
                if (property != null) {
                    switch (property) {
                        case PLANNED_START_TIME: {
                            Date oldValue = (Date)e.getOldValue();
                            Date newValue = (Date)e.getNewValue();
                            if (oldValue == null || newValue == null || oldValue.equals(newValue)) break;
                            TourTrackingResult.this.tourTrackingList = null;
                            break;
                        }
                    }
                }
            }
        });
    }

    public void createTourTrackingList(Collection<GeoTrackingModel> update, int intervall) {
        if (update == null) {
            return;
        }
        if (this.intervall != intervall || this.tourTrackingList == null) {
            this.intervall = intervall;
            this.initTourTrackingList();
        }
        for (GeoTrackingModel tracking : update) {
            if (tracking.getTour() == null || !tracking.getTour().equals(this.tour)) continue;
            this.geoTrackings.add(tracking);
        }
        Collections.sort(this.geoTrackings, new TimeComparator<GeoTrackingModel>(true){

            @Override
            protected Date getTime(GeoTrackingModel o) {
                return o.getTime();
            }
        });
        this.cluster(this.geoTrackings);
        this.setColor();
    }

    private void initTourTrackingList() {
        this.tourTrackingList = new ArrayList<TourTrackingObject>();
        Date tourStartTime = this.tour.getPlannedStartTime();
        Date tourEndTime = TourModelUtil.getPlannedEndTime(this.tour);
        if (tourStartTime == null || tourEndTime == null || !tourStartTime.before(tourEndTime)) {
            return;
        }
        Calendar signTime = Calendar.getInstance();
        signTime.setTime(tourStartTime);
        ArrayList<StopModel> finishedStops = new ArrayList<StopModel>();
        ImmutablePoint predPoint = null;
        boolean b = true;
        while (b) {
            TourTrackingObject trackingObject = new TourTrackingObject();
            trackingObject.startTime = signTime.getTime();
            this.updateSign(signTime);
            if (signTime.getTime().before(tourEndTime)) {
                trackingObject.endTime = signTime.getTime();
            } else {
                trackingObject.endTime = tourEndTime;
                b = false;
            }
            if (this.getCurrentTime() != null && TimeUtil.isBetween(this.getCurrentTime(), trackingObject.startTime, trackingObject.endTime)) {
                Date endTime = trackingObject.endTime;
                trackingObject.endTime = this.getCurrentTime();
                predPoint = this.loadTrackingObject(trackingObject, predPoint, finishedStops);
                this.tourTrackingList.add(trackingObject);
                trackingObject = new TourTrackingObject();
                trackingObject.startTime = this.getCurrentTime();
                trackingObject.endTime = endTime;
            }
            predPoint = this.loadTrackingObject(trackingObject, predPoint, finishedStops);
            this.tourTrackingList.add(trackingObject);
        }
        this.setDeadLine();
    }

    private void setDeadLine() {
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        Date nextDeadLine = this.tourTrackingList.get(this.tourTrackingList.size() - 1).endTime;
        for (int i = this.tourTrackingList.size() - 1; i >= 0; --i) {
            TourTrackingObject o = this.tourTrackingList.get(i);
            if (o.geoObject instanceof ImmutableLineString) {
                ImmutableLineString l = (ImmutableLineString)o.geoObject;
                try {
                    GeoDistanceMatrixWrapper wrapper;
                    ImmutablePoint endPoint = l.getEndPoint();
                    if (!o.stops.isEmpty()) {
                        StopModel first = (StopModel)o.stops.get(0);
                        endPoint = StopModelUtil.getGeom(first);
                    }
                    double duration = NumericUtil.getDoubleValue((wrapper = tourCaller.getGeoDistance(l.getStartPoint(), endPoint, o.vehicle, o.vehicle.getRouteType())) == null ? 0.0 : (double)wrapper.getDuration().intValue()) / o.difficultyLevel;
                    o.deadLine = TimeUtil.add(nextDeadLine, 13, (int)(-Math.round(duration)));
                }
                catch (LogisticException e) {
                    LOGGER.error("", e);
                }
            } else {
                o.deadLine = TimeUtil.add(nextDeadLine, 13, -this.intervall);
            }
            nextDeadLine = o.deadLine == null ? nextDeadLine : o.deadLine;
        }
    }

    private void updateSign(Calendar signTime) {
        if (this.intervall >= 60 && this.intervall <= 3600 && 3600 % this.intervall == 0) {
            int minuteIntervall = this.intervall / 60;
            int next = (signTime.get(12) / minuteIntervall + 1) * minuteIntervall;
            signTime.set(12, next);
            signTime.set(13, 0);
        } else {
            signTime.add(13, this.intervall);
        }
    }

    private ImmutablePoint loadTrackingObject(TourTrackingObject trackingObject, ImmutablePoint predPoint, List<StopModel> finishedStops) {
        RouteVehicleType vehicleType;
        Tupel<Date, Date> trackingTimeWindow = new Tupel<Date, Date>(trackingObject.startTime, trackingObject.endTime);
        StopModel pred = finishedStops.isEmpty() ? TourModelUtil.getFirstStop(this.tour, null, false) : finishedStops.get(finishedStops.size() - 1);
        StopModel succ = null;
        ArrayList<StopModel> between = new ArrayList<StopModel>();
        block6: for (TourPartModel part : this.tour.iterableTourParts()) {
            for (StopModel stop : part.iterableStops()) {
                Date leave;
                if (stop.getEstimatedTimeOfArrival() == null) continue;
                Date arrival = stop.getEstimatedTimeOfArrival();
                Tupel<Date, Date> stopTimeWindow = new Tupel<Date, Date>(arrival, leave = TimeUtil.add(arrival, 13, stop.getEstimatedDurationSeconds() == null ? 0 : stop.getEstimatedDurationSeconds()));
                if (TimeUtil.covers(trackingTimeWindow, stopTimeWindow)) {
                    between.add(stop);
                    if (!trackingObject.stops.contains(stop)) {
                        trackingObject.stops.add(stop);
                    }
                }
                if (leave.before(trackingObject.endTime) && arrival.before(trackingObject.endTime)) continue;
                succ = stop;
                break block6;
            }
        }
        finishedStops.addAll(between);
        TourPartModel nextTourPart = succ.getTourPart();
        ArrayList<ImmutablePoint> lineStringToSign = new ArrayList<ImmutablePoint>(){
            private static final long serialVersionUID = -5263933543835142166L;

            @Override
            public boolean add(ImmutablePoint e) {
                ImmutablePoint last;
                e = (ImmutablePoint)e.getTransformed(TourTrackingResult.this.getCoordinateFactory());
                if (!this.isEmpty() && (last = (ImmutablePoint)this.get(this.size() - 1)).equals(e)) {
                    return false;
                }
                return super.add(e);
            }

            @Override
            public boolean addAll(Collection<? extends ImmutablePoint> c) {
                for (ImmutablePoint immutablePoint : c) {
                    this.add(immutablePoint);
                }
                return true;
            }
        };
        if (predPoint != null) {
            lineStringToSign.add(predPoint);
        }
        RouteVehicleType routeVehicleType = vehicleType = nextTourPart.getRouteVehicleType() == null ? RouteVehicleType.MOTORCAR : nextTourPart.getRouteVehicleType();
        if (between.isEmpty()) {
            this.loadLineString(trackingObject, pred, succ, (List<ImmutablePoint>)lineStringToSign);
        } else {
            if (!pred.equals(between.get(0))) {
                this.loadLineString(trackingObject, pred, (StopModel)between.get(0), (List<ImmutablePoint>)lineStringToSign);
            }
            RouteType routeType = vehicleType.getRouteType();
            TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
            Iterator iter = between.iterator();
            pred = (StopModel)iter.next();
            lineStringToSign.add(StopModelUtil.getGeom(pred));
            while (iter.hasNext()) {
                StopModel next = (StopModel)iter.next();
                lineStringToSign.add(StopModelUtil.getGeom(pred));
                try {
                    GeoDistanceMatrixWrapper geoDistance = tourCaller.getGeoDistance(StopModelUtil.getAccessGeom(pred, this.modelEnviroment), StopModelUtil.getAccessGeom(next, this.modelEnviroment), vehicleType, routeType);
                    List points = geoDistance.getLineString() == null ? Collections.emptyList() : ((ImmutableLineString)geoDistance.getLineString().getGeoObject()).getCoordinates();
                    lineStringToSign.addAll(points);
                }
                catch (LogisticException e) {
                    LOGGER.error("", e);
                }
                lineStringToSign.add(StopModelUtil.getGeom(next));
                pred = next;
            }
            if (!succ.equals(between.get(between.size() - 1))) {
                this.loadLineString(trackingObject, (StopModel)between.get(between.size() - 1), succ, (List<ImmutablePoint>)lineStringToSign);
            }
        }
        switch (lineStringToSign.size()) {
            case 0: {
                trackingObject.geoObject = StopModelUtil.getGeom(succ);
                break;
            }
            case 1: {
                trackingObject.geoObject = (ImmutableGeoObject)lineStringToSign.get(0);
                break;
            }
            default: {
                trackingObject.geoObject = ImmutableGeoObjectFactory.createImmutableLineStringByPoints((List<ImmutablePoint>)lineStringToSign);
            }
        }
        trackingObject.vehicle = vehicleType;
        trackingObject.difficultyLevel = TourModelUtil.getDifficultyLevelValue(this.tour, nextTourPart, 1.0);
        trackingObject.lineType = nextTourPart.equals(pred.getTourPart()) ? AbstractLineRenderer.LineType.SOLID : AbstractLineRenderer.LineType.DASH;
        if (trackingObject.geoObject == null) {
            predPoint = null;
        } else if (trackingObject.geoObject instanceof ImmutableLineString) {
            predPoint = ((ImmutableLineString)trackingObject.geoObject).getEndPoint();
        } else if (trackingObject.geoObject instanceof ImmutablePoint) {
            predPoint = (ImmutablePoint)trackingObject.geoObject;
        }
        return predPoint;
    }

    private void loadLineString(TourTrackingObject trackingObject, StopModel from, StopModel to, List<ImmutablePoint> points) {
        Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto> tripel = this.getRouteDto(from, to);
        Date leave = from.getEstimatedTimeOfArrival();
        double lowerLimit = (int)((trackingObject.startTime.getTime() - leave.getTime()) / 1000L);
        double upperLimit = (int)((trackingObject.endTime.getTime() - leave.getTime()) / 1000L);
        LogisticServiceRouteEntryDto fromEntry = tripel.getElement2();
        double totalTime = NumericUtil.getIntegerValue(from.getEstimatedDurationSeconds()) + fromEntry.getTimeInSeconds();
        double fromPred = (to.getEstimatedTimeOfArrival().getTime() - leave.getTime()) / 1000L;
        fromPred -= (double)(NumericUtil.getIntegerValue(from.getEstimatedDurationSeconds()) + tripel.getElement2().getTimeInSeconds() + tripel.getElement3().getTimeInSeconds());
        LogisticServiceRouteDto routeDto = tripel.getElement1();
        double routeTime = routeDto.getTimeInSeconds().doubleValue();
        LogisticServiceRouteEntryDto predEntry = null;
        boolean b = false;
        for (int i = 0; i < routeDto.getEntries().size(); ++i) {
            ImmutablePoint sign;
            LogisticServiceRouteEntryDto entry = routeDto.getEntries().get(i);
            double time = entry.getTimeInSeconds() == null ? 0.0 : (double)entry.getTimeInSeconds().intValue();
            if ((totalTime += (time = time / routeTime * fromPred)) == upperLimit) {
                points.add((ImmutablePoint)entry.getCoordinate().getGeoObject());
                break;
            }
            if (totalTime > upperLimit && predEntry != null) {
                sign = this.getSign(predEntry, entry, (totalTime - upperLimit) * routeTime / fromPred);
                points.add(sign);
                break;
            }
            if (totalTime >= lowerLimit && totalTime < upperLimit) {
                if (!b) {
                    sign = predEntry == null ? (ImmutablePoint)entry.getCoordinate().getGeoObject() : this.getSign(predEntry, entry, (totalTime - lowerLimit) * routeTime / fromPred);
                    points.add(sign);
                    b = true;
                }
                points.add((ImmutablePoint)entry.getCoordinate().getGeoObject());
            }
            predEntry = entry;
        }
    }

    private Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto> getRouteDto(StopModel pred, StopModel succ) {
        Tupel<StopModel, StopModel> key = new Tupel<StopModel, StopModel>(pred, succ);
        Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto> tripel = this.stopRouteMap.get(key);
        if (tripel == null) {
            TourPartModel predPart = pred.getTourPart();
            RouteVehicleType predVehicle = predPart.getRouteVehicleType() == null ? RouteVehicleType.MOTORCAR : predPart.getRouteVehicleType();
            TourPartModel succPart = succ.getTourPart();
            RouteVehicleType succVehicle = succPart.getRouteVehicleType() == null ? RouteVehicleType.MOTORCAR : succPart.getRouteVehicleType();
            double difficultyLevel = TourModelUtil.getDifficultyLevelValue(this.tour, succPart, 1.0);
            LocationWrapper wrapperPred = LocationWrapperFactory.INSTANCE.createLocationWrapper(pred.getLocation());
            LocationWrapper wrapperSucc = LocationWrapperFactory.INSTANCE.createLocationWrapper(succ.getLocation());
            ImmutablePoint predAccessGeom = LocationModelUtil.getAccessGeom(pred.getLocation(), predVehicle, this.modelEnviroment);
            ImmutablePoint pointPred = predAccessGeom == null ? wrapperPred.getGeoLocation() : predAccessGeom;
            ImmutablePoint succAccessGeom = LocationModelUtil.getAccessGeom(succ.getLocation(), succVehicle, this.modelEnviroment);
            ImmutablePoint pointSucc = succAccessGeom == null ? wrapperSucc.getGeoLocation() : succAccessGeom;
            LogisticServiceRouteEntryDto predEntry = new LogisticServiceRouteEntryDto();
            predEntry.setCoordinate(ImmutablePointDto.create(wrapperPred.getGeoLocation()));
            double d = GeoUtils.getDistanceInMeter(pointPred.getCoordinate(), wrapperPred.getGeoLocation().getCoordinate());
            predEntry.setTimeInSeconds((int)Math.round(d / 1.3888888888888888));
            LogisticServiceRouteEntryDto succEntry = new LogisticServiceRouteEntryDto();
            succEntry.setCoordinate(ImmutablePointDto.create(wrapperSucc.getGeoLocation()));
            d = GeoUtils.getDistanceInMeter(pointSucc.getCoordinate(), wrapperSucc.getGeoLocation().getCoordinate());
            succEntry.setTimeInSeconds((int)Math.round(d / 1.3888888888888888));
            try {
                TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
                LogisticServiceRouteDto routeDto = tourCaller.calculateRouteBetweenPoints(pointPred, pointSucc, succVehicle, succVehicle.getRouteType());
                if (routeDto.getEntries().isEmpty()) {
                    Integer distance = NumericUtil.getIntegerValue(succ.getStreetMileageMetersFromTourStart()) - NumericUtil.getIntegerValue(pred.getStreetMileageMetersFromTourStart());
                    Integer duration = (int)((succ.getEstimatedTimeOfArrival().getTime() - pred.getEstimatedTimeOfArrival().getTime()) / 1000L);
                    LogisticServiceRouteEntryDto startEntry = new LogisticServiceRouteEntryDto();
                    startEntry.setCoordinate(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(pointPred.getCoordinate())));
                    startEntry.setDistanceInMeters(0);
                    startEntry.setTimeInSeconds(0);
                    routeDto.getEntries().add(startEntry);
                    LogisticServiceRouteEntryDto endEntry = new LogisticServiceRouteEntryDto();
                    endEntry.setCoordinate(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(pointSucc.getCoordinate())));
                    endEntry.setDistanceInMeters(distance);
                    endEntry.setTimeInSeconds(duration);
                    routeDto.getEntries().add(endEntry);
                } else {
                    for (LogisticServiceRouteEntryDto entry : routeDto.getEntries()) {
                        entry.setTimeInSeconds((int)Math.round((double)NumericUtil.getIntegerValue(entry.getTimeInSeconds()) / difficultyLevel));
                    }
                    routeDto.setTimeInSeconds((int)Math.round((double)NumericUtil.getIntegerValue(routeDto.getTimeInSeconds()) / difficultyLevel));
                }
                tripel = new Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto>(routeDto, predEntry, succEntry);
            }
            catch (LogisticException e) {
                LOGGER.warn(e.getMessage() + "(no route from " + pointPred + " to " + pointSucc + ")");
                tripel = new Tripel<LogisticServiceRouteDto, LogisticServiceRouteEntryDto, LogisticServiceRouteEntryDto>(new LogisticServiceRouteDto(), predEntry, succEntry);
            }
            this.stopRouteMap.put(key, tripel);
        }
        return tripel;
    }

    private void cluster(List<GeoTrackingModel> trackings) {
        Map<StopModel, List<GeoTrackingModel>> stopTrackingMap = this.cutTrackingsTillStop(trackings);
        HashMap trackingMap = new HashMap();
        ArrayList<TourTrackingObject> subObjects = new ArrayList<TourTrackingObject>();
        ArrayList<GeoTrackingModel> subTrackings = new ArrayList<GeoTrackingModel>();
        trackingMap.put(subObjects, subTrackings);
        ArrayList<TourTrackingObject> predObjects = subObjects;
        ArrayList<GeoTrackingModel> predTrackings = subTrackings;
        for (TourTrackingObject tourTrackingObject : this.tourTrackingList) {
            Object stop22;
            if (tourTrackingObject.stops.isEmpty()) {
                subObjects.add(tourTrackingObject);
                continue;
            }
            predObjects = subObjects;
            predTrackings = subTrackings;
            subObjects = new ArrayList();
            subObjects.add(tourTrackingObject);
            subTrackings = new ArrayList();
            trackingMap.put(subObjects, subTrackings);
            ArrayList<GeoTrackingModel> list = new ArrayList<GeoTrackingModel>();
            for (Object stop22 : tourTrackingObject.stops) {
                List<GeoTrackingModel> value = stopTrackingMap.remove(stop22);
                if (value == null) continue;
                list.addAll(value);
            }
            ArrayList<ImmutablePoint> predPoints = new ArrayList<ImmutablePoint>();
            stop22 = predObjects.iterator();
            while (stop22.hasNext()) {
                TourTrackingObject predO = (TourTrackingObject)stop22.next();
                if (predO.geoObject instanceof ImmutableLineString) {
                    predPoints.addAll(((ImmutableLineString)predO.geoObject).getCoordinates());
                    continue;
                }
                if (!(predO.geoObject instanceof ImmutablePoint)) continue;
                predPoints.add((ImmutablePoint)predO.geoObject);
            }
            ArrayList<ImmutablePoint> subPoints = new ArrayList<ImmutablePoint>();
            for (TourTrackingObject subO : subObjects) {
                if (subO.geoObject instanceof ImmutableLineString) {
                    subPoints.addAll(((ImmutableLineString)subO.geoObject).getCoordinates());
                    continue;
                }
                if (!(subO.geoObject instanceof ImmutablePoint)) continue;
                predPoints.add((ImmutablePoint)subO.geoObject);
            }
            for (GeoTrackingModel tracking : list) {
                ImmutablePoint trackingPoint = (ImmutablePoint)tracking.getGeoLocation().getTransformed(this.getCoordinateFactory());
                Double fromPred = this.calculateDistance(trackingPoint, predPoints);
                Double distance = this.calculateDistance(trackingPoint, subPoints);
                if (fromPred < distance) {
                    predTrackings.add(tracking);
                    continue;
                }
                subTrackings.add(tracking);
            }
        }
        for (Map.Entry entry : trackingMap.entrySet()) {
            this.cluster((List)entry.getKey(), (List)entry.getValue());
        }
        for (int i = 0; i < this.tourTrackingList.size(); ++i) {
            TourTrackingObject tourTrackingObject = this.tourTrackingList.get(i);
            if (tourTrackingObject.geoTrackings.isEmpty()) continue;
            ImmutablePoint point = null;
            if (tourTrackingObject.geoObject instanceof ImmutablePoint) {
                point = (ImmutablePoint)tourTrackingObject.geoObject;
            } else if (tourTrackingObject.geoObject instanceof ImmutableLineString) {
                point = ((ImmutableLineString)tourTrackingObject.geoObject).getStartPoint();
            }
            while (i++ < this.tourTrackingList.size() - 1) {
                TourTrackingObject nextObject = this.tourTrackingList.get(i);
                ImmutablePoint next = null;
                if (tourTrackingObject.geoObject instanceof ImmutableLineString && nextObject.geoObject instanceof ImmutablePoint) {
                    next = (ImmutablePoint)nextObject.geoObject;
                } else if (tourTrackingObject.geoObject instanceof ImmutablePoint && nextObject.geoObject instanceof ImmutableLineString) {
                    next = ((ImmutableLineString)nextObject.geoObject).getStartPoint();
                }
                if (point == null || next == null || !GeoUtil.areSamedPoints(point, next, (Double)1.0)) continue;
                nextObject.geoTrackings.addAll(tourTrackingObject.geoTrackings);
            }
        }
    }

    private Map<StopModel, List<GeoTrackingModel>> cutTrackingsTillStop(List<GeoTrackingModel> trackings) {
        HashMap<StopModel, List<GeoTrackingModel>> stopTrackingMap = new HashMap<StopModel, List<GeoTrackingModel>>();
        Iterator<GeoTrackingModel> trackingIter = trackings.iterator();
        block0: for (StopModel stop : TourModelUtil.getAllStops(this.tour, false)) {
            ArrayList<GeoTrackingModel> list = (ArrayList<GeoTrackingModel>)stopTrackingMap.get(stop);
            if (list == null) {
                list = new ArrayList<GeoTrackingModel>();
                stopTrackingMap.put(stop, list);
            }
            boolean inHome = false;
            while (trackingIter.hasNext()) {
                GeoTrackingModel next = trackingIter.next();
                ImmutablePoint trackingPoint = (ImmutablePoint)next.getGeoLocation().getTransformed(this.getCoordinateFactory());
                boolean b = false;
                if (StopModelUtil.inHomeZone(stop, trackingPoint)) {
                    b = true;
                    inHome = true;
                }
                if (inHome) {
                    if (!b) continue block0;
                    list.add(next);
                    continue;
                }
                list.add(next);
            }
        }
        return stopTrackingMap;
    }

    private void cluster(List<TourTrackingObject> objects, List<GeoTrackingModel> trackings) {
        TourTrackingObject lastFound = null;
        for (GeoTrackingModel tracking : trackings) {
            int start;
            ImmutablePoint trackingPoint = (ImmutablePoint)tracking.getGeoLocation().getTransformed(this.getCoordinateFactory());
            ImmutablePoint foot = null;
            double minDistance = Double.MAX_VALUE;
            TourTrackingObject found = null;
            for (int i = start = lastFound == null ? 0 : objects.indexOf(lastFound); i < objects.size(); ++i) {
                TourTrackingObject object = objects.get(i);
                Tupel<Double, ImmutablePoint> tupel = this.calculateDistance(trackingPoint, object);
                if (tupel.getElement2() == null) continue;
                boolean b = false;
                if (tupel.getElement1() < minDistance) {
                    minDistance = tupel.getElement1();
                    b = true;
                } else if (tupel.getElement1() == minDistance) {
                    TourTrackingObject foundNext;
                    int foundIndex = objects.indexOf(found);
                    if (found.geoObject instanceof ImmutableLineString && object.geoObject instanceof ImmutablePoint && !found.geoTrackings.isEmpty()) {
                        b = true;
                    } else if (foundIndex < objects.size() - 1 && !(foundNext = objects.get(foundIndex + 1)).geoTrackings.isEmpty()) {
                        b = true;
                    }
                }
                if (!b) continue;
                found = object;
                foot = tupel.getElement2();
            }
            if (found == null) continue;
            found.geoTrackings.add(new Tupel<GeoTrackingModel, Object>(tracking, foot));
            lastFound = found;
        }
    }

    private Double calculateDistance(ImmutablePoint geom, List<ImmutablePoint> points) {
        Tupel<Double, Object> tupel = new Tupel<Double, Object>((Double)Double.MAX_VALUE, null);
        if (points.size() == 1) {
            tupel = GeoUtil.getFoot(points.get(0), geom, geom, true);
        } else if (points.size() > 1) {
            try {
                ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(points);
                tupel = GeoUtil.getShortestPerpendicular(geom, lineString);
            }
            catch (Exception e) {
                tupel = GeoUtil.getFoot(points.get(0), geom, geom, true);
            }
        }
        return tupel.getElement1();
    }

    private Tupel<Double, ImmutablePoint> calculateDistance(ImmutablePoint geom, TourTrackingObject object) {
        Tupel<Double, Object> tupel = new Tupel<Double, Object>((Double)Double.MAX_VALUE, null);
        if (geom != null && object != null) {
            if (object.geoObject instanceof ImmutableLineString) {
                tupel = GeoUtil.getShortestPerpendicular(geom, (ImmutableLineString)object.geoObject);
            } else if (object.geoObject instanceof ImmutablePoint) {
                tupel = GeoUtil.getFoot((ImmutablePoint)object.geoObject, geom, geom, true);
            }
        }
        return tupel;
    }

    private void setColor() {
        List pred = Collections.emptyList();
        for (TourTrackingObject object : this.tourTrackingList) {
            List ts = object.geoTrackings;
            if (ts.isEmpty() && object.geoObject instanceof ImmutablePoint) {
                ts = pred;
            }
            if (ts.isEmpty()) {
                object.color = PeppergisConstants.TRACKING_MISSED_COLOR;
            } else {
                Date time = ((GeoTrackingModel)((Tupel)ts.get(0)).getElement1()).getTime();
                if (object.geoObject instanceof ImmutableLineString) {
                    Tupel last = (Tupel)ts.get(ts.size() - 1);
                    time = ((GeoTrackingModel)last.getElement1()).getTime();
                }
                if ((time.getTime() - object.deadLine.getTime()) / 1000L > (long)DELAY_TOLERANCE.intValue()) {
                    object.color = PeppergisConstants.TRACKING_DELAYED_COLOR;
                } else {
                    object.color = PeppergisConstants.TRACKING_DULY_COLOR;
                }
            }
            if (ts.isEmpty() && !(object.geoObject instanceof ImmutableLineString)) continue;
            pred = ts;
        }
    }

    private ImmutablePoint getSign(LogisticServiceRouteEntryDto pred, LogisticServiceRouteEntryDto succ, double restTime) {
        ImmutablePoint predPoint = (ImmutablePoint)((ImmutablePoint)pred.getCoordinate().getGeoObject()).getTransformed(this.getCoordinateFactory());
        double preX = predPoint.getX();
        double preY = predPoint.getY();
        ImmutablePoint succPoint = (ImmutablePoint)((ImmutablePoint)succ.getCoordinate().getGeoObject()).getTransformed(this.getCoordinateFactory());
        double succX = succPoint.getX();
        double succY = succPoint.getY();
        double restPart = restTime / (double)succ.getTimeInSeconds().intValue();
        double signX = preX + (succX - preX) * restPart;
        double signY = preY + (succY - preY) * restPart;
        Coordinate sign = this.getCoordinateFactory().createCoordinate(signX, signY);
        ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(sign);
        return point;
    }

    private CoordinateFactory getCoordinateFactory() {
        return Wgs84Factory.INSTANCE;
    }

    protected Date getCurrentTime() {
        return null;
    }

    public TourModel getTour() {
        return this.tour;
    }

    public List<TourTrackingObject> getTourTrackingList() {
        return this.tourTrackingList;
    }

    public int getIntervall() {
        return this.intervall;
    }

    public List<GeoTrackingModel> getGeoTrackings() {
        return new ArrayList<GeoTrackingModel>(this.geoTrackings);
    }

    static {
        String delayToleranceString = ModelEnviroment.getProperties().getProperty("tour.tracking.tolerantTime");
        try {
            DELAY_TOLERANCE = Integer.parseInt(delayToleranceString);
        }
        catch (Exception e) {
            LOGGER.warn("Invalid tracking tolerant time - " + delayToleranceString);
        }
    }

    public class TourTrackingObject {
        private ImmutableGeoObject geoObject;
        private AbstractLineRenderer.LineType lineType;
        private Color color = Color.BLACK;
        private Date startTime;
        private Date endTime;
        private Date deadLine;
        private RouteVehicleType vehicle;
        private double difficultyLevel;
        private List<Tupel<GeoTrackingModel, ImmutablePoint>> geoTrackings = new ArrayList<Tupel<GeoTrackingModel, ImmutablePoint>>();
        private List<StopModel> stops = new ArrayList<StopModel>();

        public ImmutableGeoObject getGeoObject() {
            return this.geoObject;
        }

        public AbstractLineRenderer.LineType getLinType() {
            return this.lineType;
        }

        public Color getColor() {
            return this.color;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public List<Tupel<GeoTrackingModel, ImmutablePoint>> getGeoTrackings() {
            return new ArrayList<Tupel<GeoTrackingModel, ImmutablePoint>>(this.geoTrackings);
        }
    }
}

