/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tracking;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingResult;
import de.datomino.peppergis.tourmanager.util.GeoTrackingModelUtil;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourTrackingRenderer
extends AbstractNavigatorRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourTrackingRenderer.class);
    private static TourTrackingType TYPE = TourTrackingType.TIME;
    private Map<TourModel, TourTrackingResult> trackingMap = new HashMap<TourModel, TourTrackingResult>();
    private Integer intervall = 300;
    private TourMapGui tourMapGui;
    private double margin;
    private GeoTrackingModel hover;
    private double defaultLineWidth;
    private Image autoSymbolImage;

    public TourTrackingRenderer(TourMapGui tourMapGui) {
        super("Tour Tracking Renderer");
        this.tourMapGui = tourMapGui;
        try {
            Properties properties = ModelEnviroment.getProperties();
            String typeString = properties.getProperty("tour.tracking.type");
            if (typeString != null) {
                TYPE = TourTrackingType.valueOf(typeString);
            }
        }
        catch (Exception properties) {
            // empty catch block
        }
        try {
            this.defaultLineWidth = Integer.parseInt(ModelEnviroment.getProperties().getProperty("geotracking.renderer.line.width"));
        }
        catch (Exception e) {
            this.defaultLineWidth = AbstractLineRenderer.DEFAULTWIDTH * 0.6;
        }
        String autoSymbol = ModelEnviroment.getProperties().getProperty("autoSymbol");
        if (autoSymbol == null) {
            autoSymbol = "/images/autos.png";
        }
        try {
            this.autoSymbolImage = ImageIO.read(TourManagerCalendarGui.class.getResourceAsStream(autoSymbol));
        }
        catch (IOException e) {
            LOGGER.error("auto symbol not found: " + autoSymbol);
        }
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, upp, this.getCoordinateFactory(), this.tourMapGui.getModelEnviroment());
        SolidLineRenderer solidLineRenderer = new SolidLineRenderer(upp, false, this.getCoordinateFactory());
        DashLineRenderer dashLineRenderer = new DashLineRenderer(upp, false, this.getCoordinateFactory());
        this.margin = 10.0 * Math.pow(upp, -0.2) * upp;
        Collection<TourTrackingResult> forPaint = this.getTrackingsForPaint();
        for (TourTrackingResult result : forPaint) {
            if (result == null || result.getTourTrackingList() == null) continue;
            for (TourTrackingResult.TourTrackingObject object : result.getTourTrackingList()) {
                if (!(object.getGeoObject() instanceof ImmutableLineString)) continue;
                ImmutableLineString lineString = (ImmutableLineString)object.getGeoObject();
                if (object.getLinType() == AbstractLineRenderer.LineType.SOLID) {
                    solidLineRenderer.render(g2d, lineString, object.getColor(), (float)(this.defaultLineWidth / AbstractLineRenderer.DEFAULTWIDTH));
                }
                if (object.getLinType() != AbstractLineRenderer.LineType.DASH) continue;
                dashLineRenderer.render(g2d, lineString, object.getColor(), (float)(this.defaultLineWidth / AbstractLineRenderer.DEFAULTWIDTH));
            }
        }
        for (TourTrackingResult result : forPaint) {
            if (result == null || result.getTourTrackingList() == null) continue;
            for (TourTrackingResult.TourTrackingObject object : result.getTourTrackingList()) {
                ImmutablePoint sign = null;
                if (object.getGeoObject() instanceof ImmutablePoint) {
                    sign = (ImmutablePoint)object.getGeoObject();
                } else if (object.getGeoObject() instanceof ImmutableLineString) {
                    sign = ((ImmutableLineString)object.getGeoObject()).getEndPoint();
                }
                pointRenderer.drawPin(sign.getCoordinate(), this.margin, Color.BLACK);
            }
        }
        for (TourTrackingResult result : forPaint) {
            List<TourTrackingResult.TourTrackingObject> tourTrackingList;
            if (result == null || (tourTrackingList = result.getTourTrackingList()) == null) continue;
            for (TourTrackingResult.TourTrackingObject object : tourTrackingList) {
                for (Tupel<GeoTrackingModel, ImmutablePoint> tupel : object.getGeoTrackings()) {
                    this.drawGeoTracking(tupel, pointRenderer, solidLineRenderer, g2d);
                }
            }
        }
        this.drawLastPoints(pointRenderer);
        this.showInfoBox(pointRenderer);
        return Collections.emptyList();
    }

    private void drawLastPoints(ManagerPointRenderer pointRenderer) {
        for (TourTrackingResult result : this.getTrackingsForPaint()) {
            GeoTrackingModel lastTracking = null;
            List<TourTrackingResult.TourTrackingObject> tourTrackingList = result.getTourTrackingList();
            if (tourTrackingList == null) continue;
            for (TourTrackingResult.TourTrackingObject object : tourTrackingList) {
                if (object.getGeoTrackings().isEmpty()) continue;
                lastTracking = object.getGeoTrackings().get(object.getGeoTrackings().size() - 1).getElement1();
            }
            if (lastTracking == null) continue;
            RendererNode node = new RendererNode("", lastTracking.getGeoLocation().getCoordinate(), this.margin);
            node.setImage(this.autoSymbolImage);
            node.setBackground(this.getColorOfTour(lastTracking.getTour()));
            pointRenderer.drawImage(node);
        }
    }

    public void doMouseMoved(Point2D.Double real) {
        if (this.isActive()) {
            this.hover = null;
            CoordinateFactory factory = this.getPanel().getCoordinateFactory();
            block0: for (TourTrackingResult result : this.getTrackingsForPaint()) {
                for (GeoTrackingModel geoTracking : result.getGeoTrackings()) {
                    Coordinate c = factory.createCoordinate(geoTracking.getGeoLocation().getCoordinate());
                    Ellipse2D.Double circle = DefaultPointRenderer.getCircle(c, this.margin);
                    if (!circle.contains(real)) continue;
                    this.hover = geoTracking;
                    continue block0;
                }
            }
        }
    }

    private Collection<TourTrackingResult> getTrackingsForPaint() {
        HashMap<TourModel, TourTrackingResult> filtered = new HashMap<TourModel, TourTrackingResult>();
        for (TourModel tour : this.tourMapGui.getToursWithColor().keySet()) {
            TourTrackingResult result = this.trackingMap.get(tour);
            if (result == null) continue;
            filtered.put(tour, result);
        }
        return filtered.values();
    }

    protected void showInfoBox(ManagerPointRenderer pointRenderer) {
        if (this.hover != null) {
            List<String> infoBox = GeoTrackingModelUtil.getInfoBoxString(this.hover);
            double left = this.hover.getGeoLocation().getX();
            double top = this.hover.getGeoLocation().getY();
            double upp = this.getPanel().getUpp();
            Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
            rectangleOfBox.height = (double)infoBox.size() * upp * 25.0;
            rectangleOfBox.width = (double)FormUtil.getMaxWordCount(infoBox) * upp * 10.0;
            rectangleOfBox.x = left;
            rectangleOfBox.y = top - rectangleOfBox.height;
            Color color = this.getColorOfTour(this.hover.getTour());
            RendererNode node = new RendererNode(null, null, Color.BLACK, Color.WHITE, upp);
            pointRenderer.drawShape(rectangleOfBox, node, upp);
            double marginTop = 20.0;
            Point2D.Double topLeftPixel = super.getPanel().getPixel(new Point2D.Double(left, top));
            for (String info : infoBox) {
                Point2D.Double real = super.getPanel().getReal(topLeftPixel.getX() + 5.0, topLeftPixel.getY() + marginTop);
                Coordinate c = super.getPanel().getCoordinateFactory().createCoordinate(real.getX(), real.getY());
                RendererNode n = new RendererNode(info, c, upp);
                n.setFontground(color);
                pointRenderer.drawText(n);
                marginTop += 20.0;
            }
        }
    }

    private void drawGeoTracking(Tupel<GeoTrackingModel, ImmutablePoint> tupel, ManagerPointRenderer pointRenderer, SolidLineRenderer lineRenderer, Graphics2D g2d) {
        ImmutablePoint tranformedFoot;
        AbstractImmutableGeoObject geoObject;
        ImmutablePoint tranformedPoint = (ImmutablePoint)tupel.getElement1().getGeoLocation().getTransformed(this.getPanel().getCoordinateFactory());
        RendererNode node = new RendererNode("", tranformedPoint.getCoordinate(), this.margin);
        Color color = this.getColorOfTour(tupel.getElement1().getTour());
        node.setBackground(color);
        node.setFontground(node.getBackground());
        pointRenderer.drawCircle(node);
        if (tupel.getElement2() != null && (geoObject = GeoUtil.createLineString(tranformedPoint, tranformedFoot = (ImmutablePoint)tupel.getElement2().getTransformed(this.getPanel().getCoordinateFactory()))) instanceof ImmutableLineString) {
            lineRenderer.render(g2d, (ImmutableLineString)geoObject, color, (float)(this.defaultLineWidth / AbstractLineRenderer.DEFAULTWIDTH));
        }
    }

    private Color getColorOfTour(TourModel tour) {
        Color color = null;
        for (TourModel t : this.tourMapGui.getToursWithColor().keySet()) {
            if (!t.equals(tour)) continue;
            color = this.tourMapGui.getToursWithColor().get(t);
            break;
        }
        return color;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    public void loadGeoTracks(Map<TourModel, List<GeoTrackingModel>> newMap) {
        for (TourModel tour : newMap.keySet()) {
            TourTrackingResult result = this.trackingMap.get(tour);
            if (result != null) continue;
            this.trackingMap.put(tour, new TourTrackingResult(tour, this.tourMapGui.getModelEnviroment()));
        }
        for (TourModel tour : this.trackingMap.keySet()) {
            TourTrackingResult result;
            List<GeoTrackingModel> newTrackings = newMap.get(tour);
            if (newTrackings == null || (result = this.trackingMap.get(tour)).getTourTrackingList() == null) continue;
            List<GeoTrackingModel> newList = result.getGeoTrackings();
            newList.addAll(newTrackings);
            result.createTourTrackingList(newList, this.intervall);
        }
        if (super.isActive()) {
            this.getPanel().repaint(10L);
        }
    }

    public void setTours(boolean refresh) {
        if (refresh) {
            this.clear();
        }
        for (TourModel tour : this.tourMapGui.getToursWithColor().keySet()) {
            if (this.trackingMap.get(tour) != null) continue;
            TourTrackingResult result = new TourTrackingResult(tour, this.tourMapGui.getModelEnviroment());
            List<GeoTrackingModel> list = result.getGeoTrackings();
            result.createTourTrackingList(list, this.intervall);
            this.trackingMap.put(tour, result);
        }
        this.getPanel().repaint(10L);
    }

    public void clear() {
        this.trackingMap.clear();
    }

    private static enum TourTrackingType {
        TIME,
        DISTANCE;

    }
}

