/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tracking;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineRenderer;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.util.GeoTrackingModelUtil;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoTrackingRenderer
extends AbstractNavigatorRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoTrackingRenderer.class);
    private Map<TourModel, List<GeoTrackingModel>> trackingMap = new HashMap<TourModel, List<GeoTrackingModel>>();
    private TourMapGui tourMapGui;
    private GeoTrackingModel hover;
    private boolean showLastTracking;
    private int defaultPointSize;
    private Integer drawCountEvery;
    private int countPointSize;
    private Image autoSymbolImage;
    private double lowSpeedLimit;
    private int lowSpeedCount;
    private Image breakSymbolImage;
    private Color defaultLineColor;
    private double defaultLineWidth;

    public GeoTrackingRenderer(TourMapGui tourMapGui) {
        super("Geo Tracking Renderer");
        this.tourMapGui = tourMapGui;
        this.defaultPointSize = 15;
        try {
            this.defaultPointSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("geotracking.renderer.point.size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String drawCountEveryString = ModelEnviroment.getProperties().getProperty("geotracking.renderer.drawEvery.count");
        if (drawCountEveryString == null) {
            this.drawCountEvery = 12;
        } else {
            try {
                this.drawCountEvery = Integer.valueOf(drawCountEveryString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.countPointSize = 15;
        try {
            this.countPointSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("geotracking.renderer.drawEvery.point.size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String autoSymbol = ModelEnviroment.getProperties().getProperty("autoSymbol");
        try {
            this.autoSymbolImage = ImageIO.read(TourManagerCalendarGui.class.getResourceAsStream(autoSymbol));
        }
        catch (Exception e) {
            LOGGER.error("auto symbol not found: " + autoSymbol);
        }
        String newAttribute = ModelEnviroment.getProperties().getProperty("geotracking.renderer.lowSpeed.limit");
        newAttribute = StringUtil.isBlank(newAttribute) ? "0" : newAttribute.replace(",", ".").trim();
        this.lowSpeedLimit = Double.parseDouble(newAttribute);
        String countString = ModelEnviroment.getProperties().getProperty("geotracking.renderer.lowSpeed.count");
        this.lowSpeedCount = StringUtil.isBlank(countString) ? 0 : Integer.parseInt(countString);
        String breakSymbol = ModelEnviroment.getProperties().getProperty("breakSymbol");
        try {
            this.breakSymbolImage = ImageIO.read(TourManagerCalendarGui.class.getResourceAsStream(breakSymbol));
        }
        catch (Exception e) {
            LOGGER.error("break symbol not found: " + breakSymbol);
        }
        try {
            this.defaultLineWidth = Integer.parseInt(ModelEnviroment.getProperties().getProperty("geotracking.renderer.line.width"));
        }
        catch (Exception e) {
            this.defaultLineWidth = AbstractLineRenderer.DEFAULTWIDTH * 0.6;
        }
        String defaultLineColorName = ModelEnviroment.getProperties().getProperty("geotracking.renderer.line.color");
        try {
            Field field = Color.class.getField(defaultLineColorName);
            this.defaultLineColor = (Color)field.get(null);
        }
        catch (Exception e) {
            LOGGER.warn("failed color code: " + defaultLineColorName);
            this.defaultLineColor = null;
        }
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, this.getPanel().getUpp(), this.getPanel().getCoordinateFactory(), this.tourMapGui.getModelEnviroment());
        double margin = (double)this.defaultPointSize * Math.pow(upp, -0.2) * upp;
        double countEveryMargin = (double)this.countPointSize * Math.pow(upp, -0.2) * upp;
        this.drawTrackingLines(g2d, upp);
        LinkedList<LinkedList<GeoTrackingModel>> breakList = new LinkedList<LinkedList<GeoTrackingModel>>();
        for (List<GeoTrackingModel> geoTrackings : this.getTrackingsForPaint()) {
            int count = 0;
            LinkedList<GeoTrackingModel> numbered = new LinkedList<GeoTrackingModel>();
            for (GeoTrackingModel geoTrackingModel : geoTrackings) {
                if (this.drawCountEvery != null && count % this.drawCountEvery == 0) {
                    numbered.add(geoTrackingModel);
                } else if (this.contains(realBoundaryBottomLeft, realBoundaryTopRight, geoTrackingModel.getGeoLocation())) {
                    Color color = this.getColorOfTour(geoTrackingModel.getTour());
                    this.drawGeoTracking(geoTrackingModel, pointRenderer, margin, "", color);
                }
                if (breakList.isEmpty()) {
                    breakList.add(CollectionUtil.buildLinkedList(geoTrackingModel));
                } else {
                    List last = (List)breakList.get(breakList.size() - 1);
                    if (this.inBreak(geoTrackingModel, last)) {
                        last.add(geoTrackingModel);
                    } else {
                        breakList.add(CollectionUtil.buildLinkedList(geoTrackingModel));
                    }
                }
                ++count;
            }
            count = 0;
            for (GeoTrackingModel geoTrackingModel : numbered) {
                if (this.contains(realBoundaryBottomLeft, realBoundaryTopRight, geoTrackingModel.getGeoLocation())) {
                    this.drawGeoTracking(geoTrackingModel, pointRenderer, countEveryMargin, Integer.toString(count), Color.WHITE);
                }
                ++count;
            }
            for (List list : breakList) {
                GeoTrackingModel geoTracking;
                if (list.size() <= this.lowSpeedCount || !this.contains(realBoundaryBottomLeft, realBoundaryTopRight, (geoTracking = (GeoTrackingModel)list.get(list.size() - 1)).getGeoLocation())) continue;
                RendererNode node = new RendererNode("", geoTracking.getGeoLocation().getCoordinate(), margin);
                node.setImage(this.breakSymbolImage);
                node.setBackground(this.getColorOfTour(geoTracking.getTour()));
                pointRenderer.drawImage(node);
            }
        }
        this.drawLastTrackings(pointRenderer, margin);
        this.showInfoBox(pointRenderer);
        return Collections.emptyList();
    }

    private boolean inBreak(GeoTrackingModel geoTracking, List<GeoTrackingModel> list) {
        long time = geoTracking.getTime().getTime();
        Coordinate coordinate = geoTracking.getGeoLocation().getCoordinate();
        for (GeoTrackingModel l : list) {
            long timeD = Math.abs(l.getTime().getTime() - time) / 1000L;
            double distanceD = GeoUtils.getDistanceInMeter(coordinate, l.getGeoLocation().getCoordinate());
            if (timeD == 0L || !(distanceD / (double)timeD < this.lowSpeedLimit)) continue;
            return true;
        }
        return false;
    }

    private void drawTrackingLines(Graphics2D g2d, double upp) {
        DashLineRenderer solidLineRenderer = new DashLineRenderer(upp, false, this.getPanel().getCoordinateFactory());
        for (List<GeoTrackingModel> list : this.getTrackingsForPaint()) {
            if (list.isEmpty()) continue;
            Iterator<GeoTrackingModel> iter = list.iterator();
            GeoTrackingModel pre = iter.next();
            while (iter.hasNext()) {
                GeoTrackingModel succ = iter.next();
                if (pre != null && pre.getGeoLocation() != null && succ != null && succ.getGeoLocation() != null && !pre.getGeoLocation().equals(succ.getGeoLocation())) {
                    ArrayList<Coordinate> coords = new ArrayList<Coordinate>(2);
                    coords.add(pre.getGeoLocation().getCoordinate());
                    coords.add(succ.getGeoLocation().getCoordinate());
                    ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineString(coords);
                    solidLineRenderer.render(g2d, lineString, this.getColorOfTour(pre.getTour()), (float)(this.defaultLineWidth / AbstractLineRenderer.DEFAULTWIDTH));
                }
                pre = succ;
            }
        }
    }

    private void drawLastTrackings(ManagerPointRenderer pointRenderer, double margin) {
        if (this.showLastTracking) {
            for (List<GeoTrackingModel> list : this.getTrackingsForPaint()) {
                if (list == null) continue;
                GeoTrackingModel lastTracking = list.get(list.size() - 1);
                RendererNode node = new RendererNode("", lastTracking.getGeoLocation().getCoordinate(), margin);
                node.setImage(this.autoSymbolImage);
                node.setBackground(this.getColorOfTour(lastTracking.getTour()));
                pointRenderer.drawImage(node);
            }
        }
    }

    public void doMouseMoved(Point2D.Double real, double upp) {
        if (this.isActive()) {
            double margin = (double)this.defaultPointSize * Math.pow(upp, -0.2) * upp;
            this.findHover(real, margin);
        }
    }

    public void doMouseRightClicked(int x, int y, double upp) {
        if (this.isActive()) {
            double margin = (double)this.defaultPointSize * Math.pow(upp, -0.2) * upp;
            this.findHover(this.tourMapGui.getNavigatorPanel().getReal(x, y), margin);
            if (this.hover != null) {
                final GeoTrackingModel clickedHover = this.hover;
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.deletePoint", new Serializable[0])){
                    private static final long serialVersionUID = -1293471591888928863L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UndoManager undoManager = GeoTrackingRenderer.this.tourMapGui.getModelEnviroment().getUndoManager();
                        undoManager.startTransaction();
                        GeoTrackingRenderer.this.removeGeoTracking(clickedHover);
                        clickedHover.delete();
                        GeoTrackingRenderer.this.hover = null;
                        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.pointDeleted", new Serializable[0]));
                        GeoTrackingRenderer.this.callRepaint();
                    }
                });
                popupMenu.show(this.getPanel(), x, y);
            }
        }
    }

    private void findHover(Point2D.Double real, double margin) {
        this.hover = null;
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        for (List<GeoTrackingModel> geoTrackings : this.getTrackingsForPaint()) {
            for (GeoTrackingModel geoTracking : geoTrackings) {
                Coordinate c = factory.createCoordinate(geoTracking.getGeoLocation().getCoordinate());
                Ellipse2D.Double circle = DefaultPointRenderer.getCircle(c, margin);
                if (!circle.contains(real)) continue;
                this.hover = geoTracking;
            }
        }
    }

    protected void showInfoBox(ManagerPointRenderer pointRenderer) {
        if (this.hover != null) {
            List<String> infoBox = GeoTrackingModelUtil.getInfoBoxString(this.hover);
            double left = this.hover.getGeoLocation().getX();
            double top = this.hover.getGeoLocation().getY();
            double upp = this.getPanel().getUpp();
            Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
            rectangleOfBox.height = (double)infoBox.size() * upp * 25.0;
            rectangleOfBox.width = (double)FormUtil.getMaxWordCount(infoBox) * upp * 10.0;
            rectangleOfBox.x = left;
            rectangleOfBox.y = top - rectangleOfBox.height;
            Color color = this.getColorOfTour(this.hover.getTour());
            RendererNode node = new RendererNode(null, null, Color.BLACK, Color.WHITE, upp);
            pointRenderer.drawShape(rectangleOfBox, node, upp);
            double marginTop = 20.0;
            Point2D.Double topLeftPixel = super.getPanel().getPixel(new Point2D.Double(left, top));
            for (String info : infoBox) {
                Point2D.Double real = super.getPanel().getReal(topLeftPixel.getX() + 5.0, topLeftPixel.getY() + marginTop);
                Coordinate c = super.getPanel().getCoordinateFactory().createCoordinate(real.getX(), real.getY());
                RendererNode n = new RendererNode(info, c, upp);
                n.setFontground(color);
                pointRenderer.drawText(n);
                marginTop += 20.0;
            }
        }
    }

    private void drawGeoTracking(GeoTrackingModel geoTracking, ManagerPointRenderer pointRenderer, double margin, String text, Color color) {
        if (color != null) {
            ImmutablePoint tranformedPoint = (ImmutablePoint)geoTracking.getGeoLocation().getTransformed(this.getPanel().getCoordinateFactory());
            RendererNode node = new RendererNode(text, tranformedPoint.getCoordinate(), margin);
            node.setBackground(color);
            pointRenderer.drawCircle(node);
            if (!StringUtil.isEmpty(text)) {
                pointRenderer.drawNumber(node);
            }
        }
    }

    private Color getColorOfTour(TourModel tour) {
        Color color = this.defaultLineColor;
        for (TourModel t : this.tourMapGui.getToursWithColor().keySet()) {
            if (!t.equals(tour)) continue;
            color = this.tourMapGui.getToursWithColor().get(t);
            break;
        }
        return color;
    }

    private boolean contains(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, ImmutablePoint point) {
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>();
        points.add(ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY())));
        points.add(ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryTopRight.getY())));
        points.add(ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY())));
        points.add(ImmutableGeoObjectFactory.createImmutablePoint(factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryBottomLeft.getY())));
        try {
            ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygon(points);
            return polygon.contains(point);
        }
        catch (IllegalPointCountException e) {
            return false;
        }
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    public void setValues(Map<TourModel, List<GeoTrackingModel>> trackingMap) {
        this.trackingMap = trackingMap;
        if (super.isActive()) {
            this.getPanel().repaint(10L);
        }
    }

    public void setShowLastTracking(boolean showLastTracking) {
        this.showLastTracking = showLastTracking;
        this.getPanel().repaint(10L);
    }

    private void removeGeoTracking(GeoTrackingModel geoTrackingModel) {
        for (Map.Entry<TourModel, List<GeoTrackingModel>> entry : this.trackingMap.entrySet()) {
            entry.getValue().remove(geoTrackingModel);
        }
    }

    private Collection<List<GeoTrackingModel>> getTrackingsForPaint() {
        HashMap<TourModel, List<GeoTrackingModel>> filtered = new HashMap<TourModel, List<GeoTrackingModel>>();
        for (TourModel tour : this.tourMapGui.getToursWithColor().keySet()) {
            List<GeoTrackingModel> trackings = this.trackingMap.get(tour);
            if (trackings == null) continue;
            filtered.put(tour, trackings);
        }
        return filtered.values();
    }
}

