/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tracking;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.handler.DisablingDoubleClickMouseListener;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.tourmanager.gui.map.GeoTrackingLegendTreeRenderer;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.map.legend.GeoTrackingAttribute;
import de.datomino.peppergis.tourmanager.gui.map.legend.GeoTrackingAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.GeoTrackingNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourNode;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLineGui;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingResult;
import de.datomino.peppergis.tourmanager.handler.TourManagerJobManager;
import de.datomino.peppergis.tourmanager.util.GeoTrackingModelUtil;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.peppergis.util.TimeComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.ktde.math.projection.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoTrackingLegendPane
extends JScrollPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoTrackingLegendPane.class);
    private static final long serialVersionUID = -1411273252413015193L;
    private TourMapGui tourMapGui;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private Set<GeoTrackingType> geoTrackingTypes = CollectionUtil.buildHashSet(GeoTrackingType.GPS);
    private long intervallInMillis = 300000L;
    private int updateInterval = 15;
    private Map<TourModel, List<GeoTrackingModel>> trackingMap = new HashMap<TourModel, List<GeoTrackingModel>>();
    private Set<Coordinate> areaRectangles;

    public GeoTrackingLegendPane(TourMapGui tourMapGui) {
        this.tourMapGui = tourMapGui;
        this.buildLayout();
    }

    private void buildLayout() {
        MouseListener[] listeners;
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.markingWithColor", new Serializable[0])));
        this.tree = new JTree(this.treeModel);
        for (MouseListener listener : listeners = this.tree.getMouseListeners()) {
            this.tree.removeMouseListener(listener);
            this.tree.addMouseListener(new DisablingDoubleClickMouseListener(listener));
        }
        this.tree.setCellRenderer(new GeoTrackingLegendTreeRenderer());
        this.tree.setScrollsOnExpand(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.setViewportView(this.tree);
        this.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
    }

    public void setValues(Set<GeoTrackingType> geoTrackingTypes, long intervallInMillis, int updateInterval) {
        this.geoTrackingTypes = geoTrackingTypes;
        this.intervallInMillis = intervallInMillis;
        this.updateInterval = updateInterval;
        this.loadGeoTracks();
    }

    public void loadGeoTracks() {
        if (this.tourMapGui.getGeoTrackingRenderer().isActive()) {
            HashSet<TourModel> tours = new HashSet<TourModel>();
            if (TourManagerJobManager.isJobRunning("time line")) {
                TourTimeLineGui timeLineGui = this.tourMapGui.getTourManagerCalendarGui().getTimeLineGui();
                CollectionUtil.transform(timeLineGui.getTours(), tours, new Transformer<TourTrackingResult, TourModel>(){

                    @Override
                    public TourModel transform(TourTrackingResult t) {
                        return t.getTour();
                    }
                });
            }
            tours.addAll(this.tourMapGui.getToursWithColor().keySet());
            Date lastTime = null;
            HashSet<TourModel> newTours = new HashSet<TourModel>();
            HashSet<TourModel> updates = new HashSet<TourModel>();
            for (TourModel tour : tours) {
                List<GeoTrackingModel> trackings = this.getTrackingMap().get(tour);
                if (trackings == null) {
                    newTours.add(tour);
                    continue;
                }
                for (GeoTrackingModel tracking : trackings) {
                    Date time = tracking.getTime();
                    if (time == null || lastTime != null && !lastTime.before(time)) continue;
                    lastTime = time;
                }
                updates.add(tour);
            }
            TourCaller tourCaller = this.tourMapGui.getModelEnviroment().getAllCaller().getTourCaller();
            Collection<GeoTrackingModel> geoTrackings = tourCaller.getGeoTrackings(null, newTours, this.geoTrackingTypes, 0L, null);
            geoTrackings.addAll(tourCaller.getGeoTrackings(null, updates, this.geoTrackingTypes, this.intervallInMillis, lastTime));
            for (GeoTrackingModel geoTrackingModel : geoTrackings) {
                if (geoTrackingModel.isDeleted()) continue;
                List<GeoTrackingModel> list = this.trackingMap.get(geoTrackingModel.getTour());
                if (list == null) {
                    list = new ArrayList<GeoTrackingModel>();
                    this.trackingMap.put(geoTrackingModel.getTour(), list);
                }
                if (list.contains(geoTrackingModel)) continue;
                list.add(geoTrackingModel);
                this.getAreaRectangles().add(geoTrackingModel.getGeoLocation().getCoordinate());
            }
            for (List list : this.trackingMap.values()) {
                Collections.sort(list, new TimeComparator<GeoTrackingModel>(true){

                    @Override
                    protected Date getTime(GeoTrackingModel o) {
                        return o.getTime();
                    }
                });
                if (list.isEmpty()) continue;
                GeoTrackingModel last = (GeoTrackingModel)list.get(list.size() - 1);
                LOGGER.info("Loading geo tracks - Tour: " + last.getTour().getName() + " Last track: " + last.getTime());
            }
        }
        this.loadTreeModel();
    }

    private void loadTreeModel() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        TreePath rootPath = new TreePath(rootNode);
        Set<TourModel> expandedTours = this.getExpandedTours(rootNode);
        rootNode.removeAllChildren();
        HashSet<TreePath> expandedTreePath = new HashSet<TreePath>(expandedTours.size());
        ArrayList<TourModel> list = new ArrayList<TourModel>(this.tourMapGui.getToursWithColor().keySet());
        Collections.sort(list, new StringComparator<TourModel>(true){

            @Override
            protected String getString(TourModel o) {
                return o.getName();
            }
        });
        for (TourModel tour : list) {
            List<GeoTrackingModel> trackings = this.getTrackingMap().get(tour);
            if (trackings == null) continue;
            TourNode tourNode = new TourNode(tour, this.tourMapGui.getToursWithColor().get(tour));
            Double duration = GeoTrackingModelUtil.calculateDuration(trackings);
            Double distance = GeoTrackingModelUtil.calculateDistance(trackings);
            String distanceString = ModelEnviroment.getMessageResolver().getNumberFormat().format((int)Math.round(distance));
            DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode("Tracking-Informationen");
            infoNode.add(new GeoTrackingAttributeNode(tour, GeoTrackingAttribute.DURATION, ClientFormUtil.getSecondTimeString(duration), Color.BLACK));
            infoNode.add(new GeoTrackingAttributeNode(tour, GeoTrackingAttribute.DISTANCE, distanceString, Color.BLACK));
            tourNode.add(infoNode);
            int index = 1;
            for (GeoTrackingModel tracking : trackings) {
                GeoTrackingNode trackingNode = new GeoTrackingNode(tracking, index, Color.BLACK);
                tourNode.add(trackingNode);
                ++index;
            }
            rootNode.add(tourNode);
            if (!expandedTours.contains(tour)) continue;
            expandedTreePath.add(rootPath.pathByAddingChild(tourNode));
        }
        this.treeModel.reload();
        for (TreePath treePath : expandedTreePath) {
            this.tree.expandPath(treePath);
        }
    }

    private Set<TourModel> getExpandedTours(DefaultMutableTreeNode rootNode) {
        HashSet<TourModel> expandedTours = new HashSet<TourModel>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            Object object;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            if (!this.tree.isExpanded(new TreePath(node.getPath())) || !((object = node.getUserObject()) instanceof TourModel)) continue;
            expandedTours.add((TourModel)object);
        }
        return expandedTours;
    }

    public Map<TourModel, List<GeoTrackingModel>> getTrackingMap() {
        if (this.trackingMap == null) {
            this.trackingMap = new HashMap<TourModel, List<GeoTrackingModel>>();
        }
        return this.trackingMap;
    }

    public Set<Coordinate> getAreaRectangles() {
        if (this.areaRectangles == null) {
            this.areaRectangles = new HashSet<Coordinate>();
        }
        return this.areaRectangles;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }
}

