/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.AbstractRoutingGui;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.stop.StopTableMenuBar;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.tourmanager.gui.stop.UnsortedStopPane;
import de.datomino.peppergis.tourmanager.handler.action.stop.StopTableRowHandler;
import de.datomino.peppergis.tourmanager.listener.stop.StopTableListener;
import de.datomino.peppergis.tourmanager.listener.stop.UnsortedStopListener;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.ktde.swing.navigator.NavigatorRenderer;

public class TourRoutingDialog
extends AbstractRoutingGui<TourModel>
implements Pausable {
    private static final long serialVersionUID = -8944894933101721123L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private StopTablePanel stopTablePanel;
    private UnsortedStopPane unsortedStopPanel;
    private StopTableListener stopTableListener;
    private boolean editable;
    private JDialog dialog;

    public TourRoutingDialog(TourManagerCalendarGui tourManagerCalendarGui, TourModel tourModel, boolean editable) {
        super(new BorderLayout());
        this.editable = editable;
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.stopTablePanel = new StopTablePanel(tourModel, editable, tourManagerCalendarGui.getModelEnviroment());
        this.stopTablePanel.setPausableDialog(this);
        this.unsortedStopPanel = new UnsortedStopPane(this.tourManagerCalendarGui, this);
        StopTableMenuBar stopTableMenuBar = new StopTableMenuBar(tourManagerCalendarGui, this, this.tourManagerCalendarGui.getBusyHandler());
        this.add((Component)stopTableMenuBar, "North");
        JSplitPane splitPane = new JSplitPane(0, this.stopTablePanel.createScrollPane(), this.unsortedStopPanel.getPanelWithTitel());
        int height = 450;
        if (Toolkit.getDefaultToolkit().getScreenSize().height < 700) {
            height = Toolkit.getDefaultToolkit().getScreenSize().height - 250;
        }
        splitPane.setDividerLocation(height);
        this.add(splitPane);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stopTableListener = new StopTableListener(this.tourManagerCalendarGui, this.stopTablePanel, this.unsortedStopPanel, this.editable);
        this.stopTablePanel.getStopTable().addMouseListener(this.stopTableListener);
        if (this.editable) {
            this.addListerner();
        }
    }

    @Override
    public TourModel getSelectedModel() {
        return this.stopTablePanel.getTour();
    }

    @Override
    public void repaintGui(boolean tourUpdate) {
        if (this.unsortedStopPanel != null) {
            this.unsortedStopPanel.getStopTable().reload(true);
        }
        if (this.stopTablePanel != null) {
            this.stopTablePanel.updateStopTable();
        }
    }

    @Override
    public List<NavigatorRenderer> getRenderer() {
        return null;
    }

    public void addListerner() {
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.DISPONENT_LOCAL_ACTIVE)) {
            this.stopTablePanel.getStopTable().addMouseMotionListener(this.stopTableListener);
            this.stopTablePanel.getStopTable().setTransferHandler(new StopTableRowHandler(this.stopTablePanel.getStopTable()));
            new DropTarget(this.unsortedStopPanel.getStopTable(), 2, this.stopTableListener);
            UnsortedStopListener unsortedStopListener = new UnsortedStopListener(this.unsortedStopPanel, this.stopTablePanel, this.tourManagerCalendarGui.getModelEnviroment());
            this.unsortedStopPanel.getStopTable().addMouseListener(unsortedStopListener);
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer(this.unsortedStopPanel.getStopTable(), 2, unsortedStopListener);
        }
    }

    public void clearSelection() {
        this.stopTablePanel.getStopTable().clearSelection();
        this.unsortedStopPanel.getStopTable().clearSelection();
    }

    private WindowListener getStopTableListener() {
        return this.stopTableListener;
    }

    public StopTablePanel getStopTablePanel() {
        return this.stopTablePanel;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public static void createAndShowGUI(TourManagerCalendarGui tourManangerCalendarGui, TourModel selTour, boolean editable) throws UnsupportedEncodingException {
        TourRoutingDialog tourRoutingDialog = new TourRoutingDialog(tourManangerCalendarGui, selTour, editable);
        tourRoutingDialog.setOpaque(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JDialog dialog = new JDialog((Frame)SwingUtilities.getRoot(tourManangerCalendarGui), ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.list", new Serializable[0]) + " (" + selTour.getName() + ")", true);
        try {
            dialog.setIconImage(ImageIO.read(TourRoutingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Point parentLoaction = tourManangerCalendarGui.getLocationOnScreen();
        dialog.setLocation(parentLoaction.x + 30, parentLoaction.y + 20);
        dialog.addWindowListener(tourRoutingDialog.getStopTableListener());
        dialog.add(tourRoutingDialog);
        Dimension sizeOfScreen = Toolkit.getDefaultToolkit().getScreenSize();
        if (sizeOfScreen.width < 1480 || sizeOfScreen.height < 700) {
            dialog.setPreferredSize(new Dimension(sizeOfScreen.width, sizeOfScreen.height));
        } else {
            dialog.setPreferredSize(new Dimension(1480, 700));
        }
        tourRoutingDialog.setDialog(dialog);
        dialog.pack();
        tourRoutingDialog.unsortedStopPanel.getStopTable().reload(true);
        dialog.setVisible(true);
    }

    @Override
    public void pause() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void resume() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
    }
}

